/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lol.bai.badpackets.api.C2SPacketReceiver;
import lol.bai.badpackets.api.S2CPacketReceiver;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import net.minecraft.resources.ResourceLocation;

public class ChannelRegistry<T> {
    public static final ChannelRegistry<S2CPacketReceiver> S2C = new ChannelRegistry(Set.of(Constants.CHANNEL_SYNC));
    public static final ChannelRegistry<C2SPacketReceiver> C2S = new ChannelRegistry(Set.of(Constants.CHANNEL_SYNC));
    public final Map<ResourceLocation, T> channels = new HashMap<ResourceLocation, T>();
    private final Set<ResourceLocation> reservedChannels;
    private final Set<AbstractPacketHandler<T>> handlers = new HashSet<AbstractPacketHandler<T>>();

    public ChannelRegistry(Set<ResourceLocation> reservedChannels) {
        this.reservedChannels = reservedChannels;
    }

    public void register(ResourceLocation id, T receiver) {
        if (this.reservedChannels.contains(id)) {
            throw new IllegalArgumentException("Reserved channel id " + id);
        }
        this.channels.put(id, receiver);
        for (AbstractPacketHandler<T> handler : this.handlers) {
            handler.onRegister(id, receiver);
        }
    }

    public void addHandler(AbstractPacketHandler<T> handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(AbstractPacketHandler<T> handler) {
        this.handlers.remove(handler);
    }
}

