/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.mcless.config.ConfigIo;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public enum PluginConfig implements IPluginConfig
{
    INSTANCE;

    private final Path path = Waila.CONFIG_DIR.resolve("waila/waila_plugins.json");
    private final ConfigIo<Map<String, Map<String, JsonPrimitive>>> io = new ConfigIo<Map>(arg_0 -> ((Logger)Waila.LOGGER).warn(arg_0), (arg_0, arg_1) -> ((Logger)Waila.LOGGER).error(arg_0, arg_1), new GsonBuilder().setPrettyPrinting().create(), new TypeToken<Map<String, Map<String, JsonPrimitive>>>(){}.getType(), LinkedHashMap::new);
    private final Map<ResourceLocation, ConfigEntry<?>> configs = new LinkedHashMap();

    public void addConfig(ConfigEntry<?> entry) {
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<ResourceLocation> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.m_135827_().equals(namespace)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean getBoolean(ResourceLocation key) {
        return (Boolean)this.getValue(key);
    }

    @Override
    public int getInt(ResourceLocation key) {
        return (Integer)this.getValue(key);
    }

    @Override
    public double getDouble(ResourceLocation key) {
        return (Double)this.getValue(key);
    }

    @Override
    public String getString(ResourceLocation key) {
        return (String)this.getValue(key);
    }

    @Override
    public <T extends Enum<T>> T getEnum(ResourceLocation key) {
        return (T)((Enum)this.getValue(key));
    }

    @Override
    public boolean get(ResourceLocation key, boolean defaultValue) {
        ConfigEntry<?> entry = this.configs.get(key);
        return entry == null ? defaultValue : (Boolean)entry.getValue();
    }

    public Set<ConfigEntry<Object>> getSyncableConfigs() {
        return this.configs.values().stream().filter(ConfigEntry::isSynced).map(t -> t).collect(Collectors.toSet());
    }

    public List<String> getNamespaces() {
        return this.configs.keySet().stream().map(ResourceLocation::m_135827_).distinct().sorted((o1, o2) -> o1.equals("waila") ? -1 : (o2.equals("waila") ? 1 : o1.compareToIgnoreCase((String)o2))).collect(Collectors.toList());
    }

    public <T> ConfigEntry<T> getEntry(ResourceLocation key) {
        return this.configs.get(key);
    }

    public <T> void set(ResourceLocation key, T value) {
        ConfigEntry<?> entry = this.configs.get(key);
        if (entry != null) {
            entry.setValue(value);
        }
    }

    public void reload() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            this.writeConfig();
        }
        Map<String, Map<String, JsonPrimitive>> config = this.io.read(this.path);
        config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
            ConfigEntry<?> entry = this.configs.get(new ResourceLocation(namespace, path));
            if (entry != null) {
                entry.setValue(entry.getType().parser.apply((JsonPrimitive)value, (JsonPrimitive)entry.getDefaultValue()));
            }
        }));
        Waila.LOGGER.info("Plugin config reloaded");
    }

    public void save() {
        this.writeConfig();
    }

    private <T> T getValue(ResourceLocation key) {
        return (T)this.configs.get(key).getValue();
    }

    private void writeConfig() {
        LinkedHashMap<String, Map> config = new LinkedHashMap<String, Map>();
        Iterator<ConfigEntry<?>> iterator = this.configs.values().iterator();
        while (iterator.hasNext()) {
            ConfigEntry<?> e;
            ConfigEntry<?> entry = e = iterator.next();
            ResourceLocation id = entry.getId();
            config.computeIfAbsent(id.m_135827_(), k -> new LinkedHashMap()).put(id.m_135815_(), entry.getType().serializer.apply(entry.getValue()));
        }
        this.io.write(this.path, config);
    }
}

