/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.gui.widget.value.IntInputValue;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class PluginConfigScreen
extends ConfigScreen {
    private static final String NO_CATEGORY = "no_category";
    private static final Map<ConfigEntry.Type<Object>, ConfigValueFunction<Object>> ENTRY_TO_VALUE = new HashMap<ConfigEntry.Type<Object>, ConfigValueFunction<Object>>();
    private static final Map<ConfigEntry<Object>, Object> SYNCED_VALUES;

    public PluginConfigScreen(Screen parent) {
        super(parent, (Component)new TranslatableComponent("gui.waila.plugin_settings"), PluginConfigScreen::saveAndRestore, PluginConfigScreen::reloadAndRestore);
        SYNCED_VALUES.clear();
        if (Minecraft.m_91087_().m_91089_() != null) {
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(entry -> SYNCED_VALUES.put((ConfigEntry<Object>)entry, entry.getValue()));
            PluginConfig.INSTANCE.reload();
        }
    }

    private static <T> void register(ConfigEntry.Type<T> type, ConfigValueFunction<T> function) {
        ENTRY_TO_VALUE.put(type, function);
    }

    private static void saveAndRestore() {
        PluginConfig.INSTANCE.save();
        SYNCED_VALUES.forEach(ConfigEntry::setValue);
    }

    private static void reloadAndRestore() {
        PluginConfig.INSTANCE.reload();
        SYNCED_VALUES.forEach(ConfigEntry::setValue);
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 26, PluginConfig.INSTANCE::save);
        for (String namespace : PluginConfig.INSTANCE.getNamespaces()) {
            final String translationKey = "config.waila.plugin_" + namespace;
            final Set<ResourceLocation> keys = PluginConfig.INSTANCE.getKeys(namespace);
            options.with(new ButtonEntry(translationKey, 100, 20, w -> this.f_96541_.m_91152_((Screen)new ConfigScreen(this, (Component)new TranslatableComponent(translationKey)){

                @Override
                public ConfigListWidget getOptions() {
                    ConfigListWidget options = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 26);
                    Object2IntLinkedOpenHashMap categories = new Object2IntLinkedOpenHashMap();
                    categories.put((Object)PluginConfigScreen.NO_CATEGORY, 0);
                    for (ResourceLocation key : keys) {
                        String c;
                        Object translation;
                        ConfigEntry entry = PluginConfig.INSTANCE.getEntry(key);
                        String path = key.m_135815_();
                        String category = PluginConfigScreen.NO_CATEGORY;
                        if (path.contains(".") && I18n.m_118936_((String)(translation = translationKey + "." + (c = path.split("[.]", 2)[0]))) && !categories.containsKey((Object)(category = c))) {
                            options.with(new CategoryEntry((String)translation));
                            categories.put((Object)category, options.m_6702_().size());
                        }
                        int index = categories.getInt((Object)category);
                        translation = categories.object2IntEntrySet().iterator();
                        while (translation.hasNext()) {
                            Object2IntMap.Entry e = (Object2IntMap.Entry)translation.next();
                            if (e.getIntValue() < index) continue;
                            e.setValue(e.getIntValue() + 1);
                        }
                        ConfigValue<Object> value = ENTRY_TO_VALUE.get(entry.getType()).create(key, translationKey + "." + path, entry.getValue(), entry.getDefaultValue(), entry::setValue);
                        if (entry.isSynced() && this.f_96541_.m_91089_() != null) {
                            value.serverOnly = true;
                            value.setValue(SYNCED_VALUES.get(entry));
                        }
                        options.with(index, value);
                    }
                    return options;
                }
            })));
        }
        return options;
    }

    static {
        PluginConfigScreen.register(ConfigEntry.BOOLEAN, (key, name, value, defaultValue, save) -> new BooleanValue(name, (boolean)value, (Boolean)defaultValue, save));
        PluginConfigScreen.register(ConfigEntry.INTEGER, (key, name, value, defaultValue, save) -> new IntInputValue(name, (Integer)value, (Integer)defaultValue, save, Registrar.INSTANCE.intConfigFormats.get(key)));
        PluginConfigScreen.register(ConfigEntry.DOUBLE, (key, name, value, defaultValue, save) -> new InputValue<Double>(name, (Double)value, (Double)defaultValue, save, InputValue.DECIMAL));
        PluginConfigScreen.register(ConfigEntry.STRING, (key, name, value, defaultValue, save) -> new InputValue<String>(name, (String)value, (String)defaultValue, save, InputValue.ANY));
        PluginConfigScreen.register(ConfigEntry.ENUM, (key, name, value, defaultValue, save) -> new EnumValue(name, (Enum[])value.getDeclaringClass().getEnumConstants(), value, defaultValue, save));
        SYNCED_VALUES = new HashMap<ConfigEntry<Object>, Object>();
    }

    @FunctionalInterface
    private static interface ConfigValueFunction<T> {
        public ConfigValue<T> create(ResourceLocation var1, String var2, T var3, T var4, Consumer<T> var5);
    }
}

