/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.hud.component.DrawableComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class Line
implements ITooltipLine,
MutableComponent {
    @Nullable
    public final ResourceLocation tag;
    public final List<ITooltipComponent> components = new ArrayList<ITooltipComponent>();
    private int width = -1;
    private int height;

    public Line(@Nullable ResourceLocation tag) {
        this.tag = tag;
    }

    @Override
    public Line with(ITooltipComponent component) {
        this.components.add(component);
        this.height = Math.max(component.getHeight(), this.height);
        return this;
    }

    @Override
    public Line with(Component component) {
        ITooltipComponent iTooltipComponent;
        if (component instanceof DrawableComponent) {
            DrawableComponent drawable = (DrawableComponent)component;
            iTooltipComponent = drawable;
        } else {
            iTooltipComponent = new WrappedComponent(component);
        }
        return this.with(iTooltipComponent);
    }

    public int getWidth() {
        if (this.width == -1) {
            this.width = this.components.stream().mapToInt(c -> c.getWidth() + 1).sum();
        }
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void render(PoseStack matrices, int x, int y, float delta) {
        int componentX = x;
        for (ITooltipComponent component : this.components) {
            int offset = component.getHeight() < this.height ? (this.height - component.getHeight()) / 2 : 0;
            component.render(matrices, componentX, y + offset, delta);
            componentX += component.getWidth() + 1;
        }
    }

    public MutableComponent m_6270_(Style style) {
        return this;
    }

    public MutableComponent m_7220_(Component component) {
        this.with(component);
        return this;
    }

    public Style m_7383_() {
        return Style.f_131099_;
    }

    public String m_6111_() {
        return "Line";
    }

    public List<Component> m_7360_() {
        return Collections.emptyList();
    }

    public MutableComponent m_6879_() {
        return this;
    }

    public MutableComponent m_6881_() {
        return this;
    }

    public FormattedCharSequence m_7532_() {
        return FormattedCharSequence.f_13691_;
    }
}

