/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.hud.ClientTickHandler;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.IClientService;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class WailaClient {
    public static KeyMapping openConfig;
    public static KeyMapping showOverlay;
    public static KeyMapping toggleLiquid;
    public static KeyMapping showRecipeInput;
    public static KeyMapping showRecipeOutput;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;

    protected static void registerKeyBinds() {
        openConfig = IClientService.INSTANCE.createKeyBind("config", 320);
        showOverlay = IClientService.INSTANCE.createKeyBind("show_overlay", 321);
        toggleLiquid = IClientService.INSTANCE.createKeyBind("toggle_liquid", 322);
        showRecipeInput = IClientService.INSTANCE.createKeyBind("show_recipe_input", 323);
        showRecipeOutput = IClientService.INSTANCE.createKeyBind("show_recipe_output", 324);
    }

    protected static void onClientTick() {
        Minecraft client = Minecraft.m_91087_();
        WailaConfig config = Waila.CONFIG.get();
        ClientTickHandler.tick();
        while (openConfig.m_90859_()) {
            client.m_91152_((Screen)new HomeScreen(null));
        }
        while (showOverlay.m_90859_()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (toggleLiquid.m_90859_()) {
            PluginConfig.INSTANCE.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (showRecipeInput.m_90859_() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (showRecipeOutput.m_90859_() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(ItemStack stack, List<Component> tooltip) {
        if (PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                String name = listener.getHoveredItemModName(stack, PluginConfig.INSTANCE);
                if (name == null) continue;
                tooltip.add(IWailaConfig.get().getFormatter().modName(name));
                return;
            }
        }
    }

    protected static void onServerLogIn(Connection connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        if (!connection.m_129531_()) {
            Waila.LOGGER.info("Connecting to dedicated server, resetting syncable config to client-only values");
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(config.getClientOnlyValue()));
        }
    }

    protected static void onServerLogout(Connection connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        if (!connection.m_129531_()) {
            PluginConfig.INSTANCE.reload();
        }
    }
}

