/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HealthComponent
implements ITooltipComponent {
    private final float health;
    private final float maxHealth;
    private final int heartsPerLine;
    private final int lineCount;

    public HealthComponent(float health, float maxHealth) {
        this.health = health;
        this.maxHealth = maxHealth;
        float maxHearts = IWailaConfig.get().getGeneral().getMaxHeartsPerLine();
        this.heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        this.lineCount = (int)Math.ceil(maxHealth / maxHearts);
    }

    @Override
    public int getWidth() {
        return 8 * this.heartsPerLine;
    }

    @Override
    public int getHeight() {
        return 10 * this.lineCount;
    }

    @Override
    public void render(PoseStack matrices, int x, int y, float delta) {
        int xOffset = 0;
        for (int i = 1; i <= Mth.m_14167_((float)this.maxHealth); ++i) {
            if (i <= Mth.m_14143_((float)this.health)) {
                Texture.HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if ((float)i > this.health && (float)i < this.health + 1.0f) {
                Texture.HALF_HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if ((float)i >= this.health + 1.0f) {
                Texture.EMPTY_HEART.render(matrices, x + xOffset, y);
                xOffset += 8;
            }
            if (i % this.heartsPerLine != 0) continue;
            y += 10;
            xOffset = 0;
        }
    }

    static enum Texture {
        HEART(52, 0, 9, 9, 16, 0, 9, 9, "a"),
        HALF_HEART(61, 0, 9, 9, 16, 0, 9, 9, "b"),
        EMPTY_HEART(16, 0, 9, 9, -1, -1, -1, -1, "c");

        final int u;
        final int v;
        final int su;
        final int sv;
        final int bu;
        final int bv;
        final int bsu;
        final int bsv;
        final String symbol;

        private Texture(int u, int v, int su, int sv, int bu, int bv, int bsu, int bsv, String symbol) {
            this.u = u;
            this.v = v;
            this.su = su;
            this.sv = sv;
            this.bu = bu;
            this.bv = bv;
            this.bsu = bsu;
            this.bsv = bsv;
            this.symbol = symbol;
        }

        void render(PoseStack matrices, int x, int y) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            RenderSystem.m_69478_();
            if (this.bu != -1) {
                GuiComponent.m_93160_((PoseStack)matrices, (int)x, (int)y, (int)8, (int)8, (float)this.bu, (float)this.bv, (int)this.bsu, (int)this.bsv, (int)256, (int)256);
            }
            GuiComponent.m_93160_((PoseStack)matrices, (int)x, (int)y, (int)8, (int)8, (float)this.u, (float)this.v, (int)this.su, (int)this.sv, (int)256, (int)256);
            RenderSystem.m_69461_();
        }
    }
}

