/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.core.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public enum BlockProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @Override
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        return new ItemComponent(accessor.getBlock().m_7397_((BlockGetter)accessor.getWorld(), accessor.getPosition(), accessor.getBlockState()));
    }

    @Override
    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        String name;
        if (accessor.getBlockState().m_60767_().m_76332_()) {
            return;
        }
        Block block = accessor.getBlock();
        String string = name = accessor.getBlockEntity() != null ? accessor.getServerData().m_128461_("customName") : "";
        if (name.isEmpty()) {
            name = block.m_49954_().getString();
        }
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.blockName(name));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(Registry.f_122824_.m_7981_((Object)block)));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.POS)) {
            BlockPos pos = accessor.getPosition();
            tooltip.addLine((Component)Component.m_237113_((String)("(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")")));
        }
        if (config.getBoolean(Options.STATES)) {
            BlockState state = accessor.getBlockState();
            state.m_61147_().forEach(p -> {
                Comparable value = state.m_61143_(p);
                MutableComponent valueText = Component.m_237113_((String)value.toString()).m_6270_(Style.f_131099_.m_131140_(p instanceof BooleanProperty ? (value == Boolean.TRUE ? ChatFormatting.GREEN : ChatFormatting.RED) : ChatFormatting.RESET));
                tooltip.addLine(new PairComponent((Component)Component.m_237113_((String)p.m_61708_()), (Component)valueText));
            });
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(accessor.getBlock()).getName()));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
        Nameable nameable;
        Component name;
        BlockEntity blockEntity = accessor.getTarget();
        if (blockEntity instanceof Nameable && (name = (nameable = (Nameable)blockEntity).m_7770_()) != null) {
            data.m_128359_("customName", name.getString());
        }
    }
}

