/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.provider;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.core.component.HealthComponent;
import mcp.mobius.waila.plugin.core.config.Options;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum EntityProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    @Nullable
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        if (entity instanceof Mob) {
            return null;
        }
        ItemStack stack = entity.m_142340_();
        return stack != null ? new ItemComponent(stack) : null;
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object entity = accessor.getEntity();
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(entity.m_5446_().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(Registry.f_122826_.m_7981_((Object)entity.m_6095_())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object t;
        if (config.getBoolean(Options.ENTITY_HEALTH) && (t = accessor.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)t;
            float health = living.m_21223_();
            float maxHealth = living.m_21233_();
            if (living.m_21233_() > (float)IWailaConfig.get().getGeneral().getMaxHealthForRender()) {
                tooltip.addLine((Component)Component.m_237110_((String)"tooltip.waila.health", (Object[])new Object[]{String.format("%.2f", Float.valueOf(health)), String.format("%.2f", Float.valueOf(maxHealth))}));
            } else {
                tooltip.addLine(new HealthComponent(health / 2.0f, maxHealth / 2.0f));
            }
        }
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(accessor.getEntity()).getName()));
        }
    }
}

