/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.registry.Register;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public enum Registrar implements IRegistrar
{
    INSTANCE;

    public final Register<IBlockComponentProvider> blockOverride = new Register();
    public final Register<IBlockComponentProvider> blockIcon = new Register();
    public final Register<IServerDataProvider<BlockEntity>> blockData = new Register();
    public final Map<TooltipPosition, Register<IBlockComponentProvider>> blockComponent = (Map)Util.m_137469_(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEntityComponentProvider> entityOverride = new Register();
    public final Register<IEntityComponentProvider> entityIcon = new Register();
    public final Register<IServerDataProvider<Entity>> entityData = new Register();
    public final Map<TooltipPosition, Register<IEntityComponentProvider>> entityComponent = (Map)Util.m_137469_(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new Register());
        }
    });
    public final Register<IEventListener> eventListeners = (Register)Util.m_137469_(new Register(), Register::reversed);
    public final BlacklistConfig blacklist = new BlacklistConfig();
    public final Map<ResourceLocation, IntFormat> intConfigFormats = new HashMap<ResourceLocation, IntFormat>();
    private boolean locked = false;

    private <T> void addConfig(ResourceLocation key, T defaultValue, T clientOnlyValue, boolean synced, ConfigEntry.Type<T> type) {
        this.assertLock();
        PluginConfig.INSTANCE.addConfig(type.create(key, defaultValue, clientOnlyValue, synced));
    }

    @Override
    public void addConfig(ResourceLocation key, boolean defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addConfig(ResourceLocation key, int defaultValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, defaultValue, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addConfig(ResourceLocation key, double defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addConfig(ResourceLocation key, String defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addConfig(ResourceLocation key, T defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, ConfigEntry.ENUM);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, boolean defaultValue, boolean clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, int defaultValue, int clientOnlyValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, clientOnlyValue, true, ConfigEntry.INTEGER);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, double defaultValue, double clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, ConfigEntry.DOUBLE);
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, String defaultValue, String clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addSyncedConfig(ResourceLocation key, T defaultValue, T clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, ConfigEntry.ENUM);
    }

    @Override
    public void addEventListener(IEventListener listener, int priority) {
        this.assertLock();
        this.eventListeners.add(Object.class, listener, priority);
    }

    @Override
    public void addBlacklist(Block ... blocks) {
        this.assertLock();
        this.blacklist.blocks.addAll(Arrays.asList(blocks));
    }

    @Override
    public void addBlacklist(BlockEntityType<?> ... blockEntityTypes) {
        this.blacklist.blockEntityTypes.addAll(Arrays.asList(blockEntityTypes));
    }

    @Override
    public <T> void addOverride(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IBlockComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, BE extends BlockEntity> void addBlockData(IServerDataProvider<BE> provider, Class<T> clazz) {
        this.assertLock();
        this.blockData.add(clazz, provider, 0);
    }

    @Override
    public void addBlacklist(EntityType<?> ... entityTypes) {
        this.assertLock();
        this.blacklist.entityTypes.addAll(Arrays.asList(entityTypes));
    }

    @Override
    public <T> void addOverride(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IEntityComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T, E extends Entity> void addEntityData(IServerDataProvider<E> provider, Class<T> clazz) {
        this.assertLock();
        this.entityData.add(clazz, provider, 0);
    }

    public void lock() {
        this.locked = true;
        int[] hash = new int[]{0, 0, 0};
        hash[0] = this.hash((Set)this.blacklist.blocks, (Registry)Registry.f_122824_);
        hash[1] = this.hash(this.blacklist.blockEntityTypes, Registry.f_122830_);
        hash[2] = this.hash((Set)this.blacklist.entityTypes, (Registry)Registry.f_122826_);
        if (Waila.BLACKLIST_CONFIG.isFileExists() && !Arrays.equals(Waila.BLACKLIST_CONFIG.get().pluginHash, hash)) {
            Waila.BLACKLIST_CONFIG.backup();
        }
        BlacklistConfig newBlacklist = Waila.BLACKLIST_CONFIG.get();
        newBlacklist.pluginHash = hash;
        newBlacklist.blocks.addAll(this.blacklist.blocks);
        newBlacklist.entityTypes.addAll(this.blacklist.entityTypes);
        Waila.BLACKLIST_CONFIG.save();
    }

    private void assertLock() {
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to register new component after the registrar is locked");
    }

    private void assertPriority(int priority) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be equals or more than 0");
    }

    private <T> int hash(Set<T> set, Registry<T> registry) {
        return set.stream().map(arg_0 -> registry.m_7981_(arg_0)).collect(Collectors.toSet()).hashCode();
    }
}

