/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import java.util.function.Predicate;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class RaycastUtil {
    private static final HitResult MISS = new HitResult(Vec3.f_82478_){

        public HitResult.Type m_6662_() {
            return HitResult.Type.MISS;
        }
    };

    public static HitResult fire() {
        Minecraft client = Minecraft.m_91087_();
        Entity camera = client.m_91288_();
        return camera != null ? RaycastUtil.fire(camera, client.f_91072_.m_105286_(), client.m_91296_()) : MISS;
    }

    public static HitResult fire(Entity camera, double reach, float tickDelta) {
        EntityHitResult entityHit;
        Vec3 viewVec = camera.m_20252_(tickDelta);
        Vec3 start = camera.m_20299_(tickDelta);
        Vec3 end = start.m_82520_(viewVec.f_82479_ * reach, viewVec.f_82480_ * reach, viewVec.f_82481_ * reach);
        ClipContext.Fluid fluidContext = PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_FLUID) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE;
        BlockHitResult blockHit = camera.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, fluidContext, camera));
        if (PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY) && (entityHit = ProjectileUtil.m_37287_((Entity)camera, (Vec3)start, (Vec3)end, (AABB)new AABB(start, end), (Predicate)EntitySelector.f_20402_, (double)0.0)) != null) {
            if (blockHit.m_6662_() == HitResult.Type.MISS) {
                return entityHit;
            }
            double blockDistance = blockHit.m_82450_().m_82557_(start);
            double entityDistance = entityHit.m_82450_().m_82557_(start);
            if (entityDistance < blockDistance) {
                return entityHit;
            }
        }
        return blockHit;
    }
}

