/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.scorpions.mobs;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;

public class ScorpionTemptGoal
extends Goal {
    private static final EntityPredicate TEMP_TARGETING = new EntityPredicate().func_221013_a(10.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    protected final CreatureEntity mob;
    private final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    protected PlayerEntity player;
    private int calmDown;
    private boolean isRunning;
    private final Ingredient items;
    private final boolean canScare;

    public ScorpionTemptGoal(CreatureEntity p_i47822_1_, double p_i47822_2_, Ingredient p_i47822_4_, boolean p_i47822_5_) {
        this(p_i47822_1_, p_i47822_2_, p_i47822_5_, p_i47822_4_);
    }

    public ScorpionTemptGoal(CreatureEntity p_i47823_1_, double p_i47823_2_, boolean p_i47823_4_, Ingredient p_i47823_5_) {
        this.mob = p_i47823_1_;
        this.speedModifier = p_i47823_2_;
        this.items = p_i47823_5_;
        this.canScare = p_i47823_4_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(p_i47823_1_.func_70661_as() instanceof GroundPathNavigator) && !(p_i47823_1_.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.mob.field_70173_aa - this.mob.func_142015_aE() < 60) {
            return false;
        }
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.mob.field_70170_p.func_217370_a(TEMP_TARGETING, (LivingEntity)this.mob);
        if (this.player == null) {
            return false;
        }
        return this.shouldFollowItem(this.player.func_184614_ca()) || this.shouldFollowItem(this.player.func_184592_cb());
    }

    protected boolean shouldFollowItem(ItemStack p_188508_1_) {
        return this.items.test(p_188508_1_);
    }

    public boolean func_75253_b() {
        if (this.canScare()) {
            if (this.mob.func_70068_e((Entity)this.player) < 36.0) {
                if (this.player.func_70092_e(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.field_70125_A - this.pRotX) > 5.0 || Math.abs((double)this.player.field_70177_z - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.player.func_226277_ct_();
                this.py = this.player.func_226278_cu_();
                this.pz = this.player.func_226281_cx_();
            }
            this.pRotX = this.player.field_70125_A;
            this.pRotY = this.player.field_70177_z;
        }
        return this.func_75250_a();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void func_75249_e() {
        this.px = this.player.func_226277_ct_();
        this.py = this.player.func_226278_cu_();
        this.pz = this.player.func_226281_cx_();
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.player = null;
        this.mob.func_70661_as().func_75499_g();
        this.calmDown = 100;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.mob.func_70671_ap().func_75651_a((Entity)this.player, (float)(this.mob.func_184649_cE() + 20), (float)this.mob.func_70646_bf());
        if (this.mob.func_70068_e((Entity)this.player) < 6.25) {
            this.mob.func_70661_as().func_75499_g();
        } else {
            this.mob.func_70661_as().func_75497_a((Entity)this.player, this.speedModifier);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

