/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.scorpions.setup.config;

import net.minecraftforge.common.ForgeConfigSpec;

final class CommonConfig {
    final ForgeConfigSpec.IntValue[] SCORPION = new ForgeConfigSpec.IntValue[6];
    final ForgeConfigSpec.ConfigValue<String> SCORPION_BIOME;
    final ForgeConfigSpec.IntValue[] EMPEROR_SCORPION = new ForgeConfigSpec.IntValue[6];
    final ForgeConfigSpec.ConfigValue<String> EMPEROR_SCORPION_BIOME;
    final ForgeConfigSpec.IntValue[] NETHER_SCORPION = new ForgeConfigSpec.IntValue[6];
    final ForgeConfigSpec.ConfigValue<String> NETHER_SCORPION_BIOME;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        builder.comment("Spawn settings").push("spawnrate");
        this.SCORPION_BIOME = builder.comment("\nBiome name where Brown Scorpion should spawn").define("biome_name_1", (Object)"minecraft:desert,minecraft:badlands,minecraft:eroded_badlands");
        this.EMPEROR_SCORPION_BIOME = builder.comment("\nBiome name where Emperor Scorpion should spawn").define("biome_name_2", (Object)"minecraft:desert,minecraft:badlands,minecraft:eroded_badlands");
        this.NETHER_SCORPION_BIOME = builder.comment("\nBiome name where Nether Scorpion should spawn").define("biome_name_3", (Object)"minecraft:soul_sand_valley");
        CommonConfig.initMobSpawnRate(builder, "Brown Scorpion", "brown_scorpion", 5, 0, 1, 20, 30, 4, this.SCORPION);
        CommonConfig.initMobSpawnRate(builder, "Emperor Scorpion", "emperor_scorpion", 5, 0, 1, 5, 35, 6, this.EMPEROR_SCORPION);
        CommonConfig.initMobSpawnRate(builder, "Nether Scorpion", "nether_scorpion", 5, 0, 1, 8, 50, 7, this.NETHER_SCORPION);
        builder.pop();
        builder.pop();
    }

    public static void initMobSpawnRate(ForgeConfigSpec.Builder builder, String name, String pushname, int weight, int min, int max, int poisonDuration, int hp, int da, ForgeConfigSpec.IntValue[] array) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("Spawn Chance").translation("scorpions.config." + name + ".weight").defineInRange("weight", weight, 0, Integer.MAX_VALUE);
        array[1] = builder.comment("Monster Spawn Minimum Number").translation("scorpions.config." + name + ".min").defineInRange("min", min, 0, Integer.MAX_VALUE);
        array[2] = builder.comment("Monster Spawn Maximum Number").translation("scorpions.config." + name + ".max").defineInRange("max", max, 0, Integer.MAX_VALUE);
        array[3] = builder.comment("Poison duration").translation("scorpions.config." + name + ".summon").defineInRange("duration", poisonDuration, 0, Integer.MAX_VALUE);
        array[4] = builder.comment("Health points").translation("scorpions.config." + name + ".hp").defineInRange("hp", hp, 1, Integer.MAX_VALUE);
        array[5] = builder.comment("Damage").translation("scorpions.config." + name + ".da").defineInRange("damage", da, 1, Integer.MAX_VALUE);
        builder.pop();
    }
}

