/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.scorpions.setup;

import com.google.gson.JsonElement;
import com.minecraftserverzone.scorpions.datagen.BiomeTags;
import com.minecraftserverzone.scorpions.setup.Registrations;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scorpions", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeModifierTest {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "scorpions";
    public static final ResourceLocation ADD_FEATURES_TO_BIOMES_RL = new ResourceLocation("scorpions", "scorpions");
    public static final String SPAWN_BROWN = "spawn_brown_scorpion";
    public static final String SPAWN_EMPEROR = "spawn_emperor_scorpion";
    public static final String SPAWN_NETHER = "spawn_nether_scorpion";

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        Path outputFolder = generator.m_123916_();
        final RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)RegistryAccess.f_123049_.get()));
        String directory = PackType.SERVER_DATA.m_10305_();
        ResourceLocation biomeModifiersRegistryID = ForgeRegistries.Keys.BIOME_MODIFIERS.m_135782_();
        final String biomeModifierPathString = String.join((CharSequence)"/", directory, MODID, biomeModifiersRegistryID.m_135827_(), biomeModifiersRegistryID.m_135815_(), "spawn_brown_scorpion.json");
        final Path biomeModifierPath = outputFolder.resolve(biomeModifierPathString);
        final TestModifier biomeModifiersBrownScorpion = new TestModifier((HolderSet<Biome>)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), Registrations.HAS_BROWN_SCORPIONS), new MobSpawnSettings.SpawnerData((EntityType)Registrations.BROWN_SCORPION.get(), 5, 1, 2));
        final String biomeModifierPathStringEmperor = String.join((CharSequence)"/", directory, MODID, biomeModifiersRegistryID.m_135827_(), biomeModifiersRegistryID.m_135815_(), "spawn_emperor_scorpion.json");
        final Path biomeModifierPathEmperor = outputFolder.resolve(biomeModifierPathStringEmperor);
        final TestModifier biomeModifierEmperorScorpion = new TestModifier((HolderSet<Biome>)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), Registrations.HAS_EMPEROR_SCORPIONS), new MobSpawnSettings.SpawnerData((EntityType)Registrations.EMPEROR_SCORPION.get(), 5, 1, 2));
        final String biomeModifierPathStringNether = String.join((CharSequence)"/", directory, MODID, biomeModifiersRegistryID.m_135827_(), biomeModifiersRegistryID.m_135815_(), "spawn_nether_scorpion.json");
        final Path biomeModifierPathNether = outputFolder.resolve(biomeModifierPathStringNether);
        final TestModifier biomeModifierNetherScorpion = new TestModifier((HolderSet<Biome>)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), Registrations.HAS_NETHER_SCORPIONS), new MobSpawnSettings.SpawnerData((EntityType)Registrations.NETHER_SCORPION.get(), 5, 1, 2));
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new BiomeTags(generator, event.getExistingFileHelper()));
        }
        generator.m_236039_(event.includeServer(), new DataProvider(){

            public void m_213708_(CachedOutput cache) throws IOException {
                BiomeModifier.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)biomeModifiersBrownScorpion).resultOrPartial(msg -> LOGGER.error("Failed to encode {}: {}", (Object)biomeModifierPathString, msg)).ifPresent(json -> {
                    try {
                        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)biomeModifierPath);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                BiomeModifier.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)biomeModifierEmperorScorpion).resultOrPartial(msg -> LOGGER.error("Failed to encode {}: {}", (Object)biomeModifierPathStringEmperor, msg)).ifPresent(json -> {
                    try {
                        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)biomeModifierPathEmperor);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                BiomeModifier.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)biomeModifierNetherScorpion).resultOrPartial(msg -> LOGGER.error("Failed to encode {}: {}", (Object)biomeModifierPathStringNether, msg)).ifPresent(json -> {
                    try {
                        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)biomeModifierPathNether);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }

            public String m_6055_() {
                return "scorpions data provider";
            }
        });
    }

    public record TestModifier(HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)ADD_FEATURES_TO_BIOMES_RL, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"scorpions");

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
                builder.getMobSpawnSettings().m_48376_(this.spawn.f_48404_.m_20674_(), this.spawn);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<TestModifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(TestModifier::biomes), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawn").forGetter(TestModifier::spawn)).apply((Applicative)builder, TestModifier::new));
        }
    }
}

