/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.scorpions.setup.config;

import net.minecraftforge.common.ForgeConfigSpec;

final class CommonConfig {
    final ForgeConfigSpec.IntValue[] SCORPION = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.IntValue[] EMPEROR_SCORPION = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.IntValue[] NETHER_SCORPION = new ForgeConfigSpec.IntValue[3];

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        CommonConfig.initMobSpawnRate(builder, "Brown Scorpion", "brown_scorpion", 205, 0, 10, 20, 30, 4, this.SCORPION);
        CommonConfig.initMobSpawnRate(builder, "Emperor Scorpion", "emperor_scorpion", 205, 0, 10, 5, 35, 6, this.EMPEROR_SCORPION);
        CommonConfig.initMobSpawnRate(builder, "Nether Scorpion", "nether_scorpion", 205, 0, 10, 8, 50, 7, this.NETHER_SCORPION);
        builder.pop();
    }

    public static void initMobSpawnRate(ForgeConfigSpec.Builder builder, String name, String pushname, int weight, int min, int max, int poisonDuration, int hp, int da, ForgeConfigSpec.IntValue[] array) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("Poison duration").translation("scorpions.config." + name + ".summon").defineInRange("duration", poisonDuration, 0, Integer.MAX_VALUE);
        array[1] = builder.comment("Health points").translation("scorpions.config." + name + ".hp").defineInRange("hp", hp, 1, Integer.MAX_VALUE);
        array[2] = builder.comment("Damage").translation("scorpions.config." + name + ".da").defineInRange("damage", da, 1, Integer.MAX_VALUE);
        builder.pop();
    }
}

