/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.capability;

import daripher.autoleveling.api.ILevelingData;
import daripher.autoleveling.api.LevelingApi;
import daripher.autoleveling.network.NetworkDispatcher;
import daripher.autoleveling.network.message.SyncLevelingData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="autoleveling")
public class LevelingDataProvider
implements ICapabilitySerializable<CompoundNBT> {
    private ILevelingData instance = (ILevelingData)LevelingApi.CAPABILITY.getDefaultInstance();

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(LevelingApi.CAPABILITY_ID, (ICapabilityProvider)new LevelingDataProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)event.getTarget();
            LevelingDataProvider.get(livingEntity).ifPresent(levelingData -> LevelingDataProvider.syncWith((ServerPlayerEntity)event.getPlayer(), livingEntity, levelingData));
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (LevelingApi.CAPABILITY == capability) {
            return LazyOptional.of(() -> this.instance);
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)LevelingApi.CAPABILITY.writeNBT((Object)this.instance, null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        LevelingApi.CAPABILITY.readNBT((Object)this.instance, null, (INBT)nbt);
    }

    public static LazyOptional<ILevelingData> get(LivingEntity entity) {
        return entity.getCapability(LevelingApi.CAPABILITY);
    }

    public static void syncWith(ServerPlayerEntity player, LivingEntity entity, ILevelingData levelingData) {
        NetworkDispatcher.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncLevelingData(entity, levelingData));
    }
}

