/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.event;

import daripher.autoleveling.api.LevelingApi;
import daripher.autoleveling.capability.LevelingDataProvider;
import daripher.autoleveling.config.Config;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="autoleveling")
public class MobsLevelingEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (LevelingApi.canHaveLevel(event.getEntity())) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (!entity.field_70170_p.field_72995_K) {
                ServerWorld serverWorld = (ServerWorld)entity.field_70170_p;
                BlockPos spawnPos = serverWorld.func_241135_u_();
                double distance = Math.sqrt(spawnPos.func_177951_i((Vector3i)entity.func_233580_cy_()));
                int level = (int)((Double)Config.COMMON.levelBonus.get() * distance);
                LevelingDataProvider.get(entity).ifPresent(levelingData -> levelingData.setLevel(level));
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.field_233821_d_, (Double)Config.COMMON.movementSpeedBonus.get() * (double)level);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.field_233822_e_, (Double)Config.COMMON.flyingSpeedBonus.get() * (double)level);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.field_233823_f_, (Double)Config.COMMON.attackDamageBonus.get() * (double)level);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.field_233826_i_, (Double)Config.COMMON.armorBonus.get() * (double)level);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.field_233818_a_, (Double)Config.COMMON.healthBonus.get() * (double)level);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderNameplate(RenderNameplateEvent event) {
        if (!((Boolean)Config.COMMON.showLevel.get()).booleanValue()) {
            return;
        }
        if (LevelingApi.canHaveLevel(event.getEntity())) {
            Minecraft minecraft = Minecraft.func_71410_x();
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (MobsLevelingEvents.shouldShowName(entity)) {
                event.setResult(Event.Result.ALLOW);
                double distance = minecraft.func_175598_ae().func_229099_b_((Entity)entity);
                if (ForgeHooksClient.isNameplateInRenderDistance((Entity)entity, (double)distance)) {
                    LevelingDataProvider.get(entity).ifPresent(levelingData -> {
                        int level = levelingData.getLevel() + 1;
                        ITextComponent entityName = event.getContent();
                        IFormattableTextComponent levelString = new StringTextComponent("" + level).func_240699_a_(TextFormatting.GREEN);
                        float y = entity.func_213302_cg() + 0.5f;
                        int yShift = "deadmau5".equals(entityName.getString()) ? -10 : 0;
                        event.getMatrixStack().func_227860_a_();
                        event.getMatrixStack().func_227861_a_(0.0, (double)y, 0.0);
                        event.getMatrixStack().func_227863_a_(minecraft.func_175598_ae().func_229098_b_());
                        event.getMatrixStack().func_227862_a_(-0.025f, -0.025f, 0.025f);
                        Matrix4f matrix4f = event.getMatrixStack().func_227866_c_().func_227870_a_();
                        float backgroundOpacity = minecraft.field_71474_y.func_216840_a(0.25f);
                        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
                        FontRenderer font = minecraft.field_71466_p;
                        float x = -font.func_238414_a_((ITextProperties)entityName) / 2 - 5 - font.func_238414_a_((ITextProperties)levelString);
                        font.func_243247_a((ITextComponent)levelString, x, (float)yShift, 0x20FFFFFF, false, matrix4f, event.getRenderTypeBuffer(), !entity.func_226273_bm_(), alpha, event.getPackedLight());
                        if (!entity.func_226273_bm_()) {
                            font.func_243247_a((ITextComponent)levelString, x, (float)yShift, -1, false, matrix4f, event.getRenderTypeBuffer(), false, 0, event.getPackedLight());
                        }
                        event.getMatrixStack().func_227865_b_();
                    });
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static boolean shouldShowName(LivingEntity entity) {
        Minecraft minecraft = Minecraft.func_71410_x();
        return Minecraft.func_71382_s() && entity != minecraft.func_175606_aa() && !entity.func_98034_c((PlayerEntity)minecraft.field_71439_g) && !entity.func_184207_aI() && minecraft.field_71439_g.func_70685_l((Entity)entity);
    }

    private static void applyAttributeBonusIfPossible(LivingEntity entity, Attribute attribute, double bonus) {
        ModifiableAttributeInstance attributeInstance = entity.func_110148_a(attribute);
        UUID modifierId = UUID.fromString("6a102cb4-d735-4cb7-8ab2-3d383219a44e");
        if (attributeInstance != null && attributeInstance.func_111127_a(modifierId) == null) {
            attributeInstance.func_233769_c_(new AttributeModifier(modifierId, "Auto Leveling Bonus", bonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
            if (attribute == Attributes.field_233818_a_) {
                entity.func_70691_i(entity.func_110138_aP());
            }
        }
    }
}

