/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.network.message;

import daripher.autoleveling.api.ILevelingData;
import daripher.autoleveling.api.LevelingApi;
import daripher.autoleveling.capability.LevelingDataProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncLevelingData {
    private CompoundNBT nbt;
    private int entityId;

    private SyncLevelingData() {
    }

    public SyncLevelingData(LivingEntity entity, ILevelingData levelingData) {
        this.nbt = (CompoundNBT)LevelingApi.CAPABILITY.writeNBT((Object)levelingData, null);
        this.entityId = entity.func_145782_y();
    }

    public static SyncLevelingData decode(PacketBuffer buf) {
        SyncLevelingData result = new SyncLevelingData();
        result.nbt = buf.func_244273_m();
        result.entityId = buf.readInt();
        return result;
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
        buf.writeInt(this.entityId);
    }

    public static void receive(SyncLevelingData message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SyncLevelingData.handlePacket(message, ctx)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SyncLevelingData message, NetworkEvent.Context ctx) {
        Minecraft client = Minecraft.func_71410_x();
        Entity entity = client.field_71441_e.func_73045_a(message.entityId);
        if (entity instanceof LivingEntity) {
            LevelingDataProvider.get((LivingEntity)entity).ifPresent(levelingData -> LevelingApi.CAPABILITY.readNBT(levelingData, null, (INBT)message.nbt));
        }
    }
}

