/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.capability;

import daripher.autoleveling.api.ILevelingData;
import daripher.autoleveling.api.LevelingApi;
import daripher.autoleveling.capability.LevelingData;
import daripher.autoleveling.network.NetworkDispatcher;
import daripher.autoleveling.network.message.SyncLevelingData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="autoleveling")
public class LevelingDataProvider
implements ICapabilitySerializable<CompoundTag> {
    private LazyOptional<ILevelingData> lazyOptional = LazyOptional.of(LevelingData::new);

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(LevelingApi.CAPABILITY_ID, (ICapabilityProvider)new LevelingDataProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)event.getTarget();
            LevelingDataProvider.get(livingEntity).ifPresent(levelingData -> LevelingDataProvider.syncWith((ServerPlayer)event.getPlayer(), livingEntity, levelingData));
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (LevelingApi.CAPABILITY == capability) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)((ILevelingData)this.lazyOptional.orElseThrow(NullPointerException::new)).serializeNBT();
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        ((ILevelingData)this.lazyOptional.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)compoundTag);
    }

    public static LazyOptional<ILevelingData> get(LivingEntity entity) {
        return entity.getCapability(LevelingApi.CAPABILITY);
    }

    public static void syncWith(ServerPlayer player, LivingEntity entity, ILevelingData levelingData) {
        NetworkDispatcher.networkChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncLevelingData(entity, levelingData));
    }
}

