/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.config;

import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Double> movementSpeedBonus;
        public final ForgeConfigSpec.ConfigValue<Double> flyingSpeedBonus;
        public final ForgeConfigSpec.ConfigValue<Double> attackDamageBonus;
        public final ForgeConfigSpec.ConfigValue<Double> armorBonus;
        public final ForgeConfigSpec.ConfigValue<Double> healthBonus;
        public final ForgeConfigSpec.ConfigValue<Double> levelBonus;
        public final ForgeConfigSpec.ConfigValue<Boolean> showLevel;

        public Common(ForgeConfigSpec.Builder builder) {
            Predicate<Object> positiveOrZeroDoublePredicate = d -> d instanceof Double && (Double)d >= 0.0;
            builder.push("mobs");
            this.levelBonus = builder.define("levels_per_distance", (Object)0.01, positiveOrZeroDoublePredicate);
            this.showLevel = builder.define("show_level", true);
            builder.push("attributes");
            this.movementSpeedBonus = builder.define("movement_speed_per_level", (Object)0.001, positiveOrZeroDoublePredicate);
            this.flyingSpeedBonus = builder.define("flying_speed_per_level", (Object)0.001, positiveOrZeroDoublePredicate);
            this.attackDamageBonus = builder.define("attack_damage_per_level", (Object)0.1, positiveOrZeroDoublePredicate);
            this.armorBonus = builder.define("armor_per_level", (Object)0.1, positiveOrZeroDoublePredicate);
            this.healthBonus = builder.define("health_per_level", (Object)0.1, positiveOrZeroDoublePredicate);
            builder.pop(2);
        }
    }
}

