/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.event;

import com.mojang.math.Matrix4f;
import daripher.autoleveling.api.LevelingApi;
import daripher.autoleveling.capability.LevelingDataProvider;
import daripher.autoleveling.config.Config;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="autoleveling")
public class MobsLevelingEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (LevelingApi.canHaveLevel(event.getEntity())) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (!entity.f_19853_.f_46443_) {
                ServerLevel level = (ServerLevel)entity.f_19853_;
                BlockPos spawnPos = level.m_8900_();
                double distance = Math.sqrt(spawnPos.m_123331_((Vec3i)entity.m_142538_()));
                int monsterLevel = (int)((Double)Config.COMMON.levelBonus.get() * distance);
                LevelingDataProvider.get(entity).ifPresent(levelingData -> levelingData.setLevel(monsterLevel));
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.f_22279_, (Double)Config.COMMON.movementSpeedBonus.get() * (double)monsterLevel);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.f_22280_, (Double)Config.COMMON.flyingSpeedBonus.get() * (double)monsterLevel);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.f_22281_, (Double)Config.COMMON.attackDamageBonus.get() * (double)monsterLevel);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.f_22284_, (Double)Config.COMMON.armorBonus.get() * (double)monsterLevel);
                MobsLevelingEvents.applyAttributeBonusIfPossible(entity, Attributes.f_22276_, (Double)Config.COMMON.healthBonus.get() * (double)monsterLevel);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderNameplate(RenderNameplateEvent event) {
        if (!((Boolean)Config.COMMON.showLevel.get()).booleanValue()) {
            return;
        }
        if (LevelingApi.canHaveLevel(event.getEntity())) {
            Minecraft minecraft = Minecraft.m_91087_();
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (MobsLevelingEvents.shouldShowName(entity)) {
                event.setResult(Event.Result.ALLOW);
                double distance = minecraft.m_91290_().m_114471_((Entity)entity);
                if (ForgeHooksClient.isNameplateInRenderDistance((Entity)entity, (double)distance)) {
                    LevelingDataProvider.get(entity).ifPresent(levelingData -> {
                        int level = levelingData.getLevel() + 1;
                        Component entityName = event.getContent();
                        MutableComponent levelString = new TextComponent("" + level).m_130940_(ChatFormatting.GREEN);
                        float y = entity.m_20206_() + 0.5f;
                        int yShift = "deadmau5".equals(entityName.getString()) ? -10 : 0;
                        event.getPoseStack().m_85836_();
                        event.getPoseStack().m_85837_(0.0, (double)y, 0.0);
                        event.getPoseStack().m_85845_(minecraft.m_91290_().m_114470_());
                        event.getPoseStack().m_85841_(-0.025f, -0.025f, 0.025f);
                        Matrix4f matrix4f = event.getPoseStack().m_85850_().m_85861_();
                        float backgroundOpacity = minecraft.f_91066_.m_92141_(0.25f);
                        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
                        Font font = minecraft.f_91062_;
                        float x = -font.m_92852_((FormattedText)entityName) / 2 - 5 - font.m_92852_((FormattedText)levelString);
                        font.m_92841_((Component)levelString, x, (float)yShift, 0x20FFFFFF, false, matrix4f, event.getMultiBufferSource(), !entity.m_20163_(), alpha, event.getPackedLight());
                        if (!entity.m_20163_()) {
                            font.m_92841_((Component)levelString, x, (float)yShift, -1, false, matrix4f, event.getMultiBufferSource(), false, 0, event.getPackedLight());
                        }
                        event.getPoseStack().m_85849_();
                    });
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static boolean shouldShowName(LivingEntity entity) {
        Minecraft minecraft = Minecraft.m_91087_();
        return Minecraft.m_91404_() && entity != minecraft.m_91288_() && !entity.m_20177_((Player)minecraft.f_91074_) && !entity.m_20160_() && minecraft.f_91074_.m_142582_((Entity)entity);
    }

    private static void applyAttributeBonusIfPossible(LivingEntity entity, Attribute attribute, double bonus) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        UUID modifierId = UUID.fromString("6a102cb4-d735-4cb7-8ab2-3d383219a44e");
        if (attributeInstance != null && attributeInstance.m_22111_(modifierId) == null) {
            attributeInstance.m_22125_(new AttributeModifier(modifierId, "Auto Leveling Bonus", bonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
            if (attribute == Attributes.f_22276_) {
                entity.m_5634_(entity.m_21233_());
            }
        }
    }
}

