/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.network.message;

import daripher.autoleveling.api.ILevelingData;
import daripher.autoleveling.capability.LevelingDataProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncLevelingData {
    private CompoundTag compoundTag;
    private int entityId;

    private SyncLevelingData() {
    }

    public SyncLevelingData(LivingEntity entity, ILevelingData levelingData) {
        this.compoundTag = (CompoundTag)levelingData.serializeNBT();
        this.entityId = entity.m_142049_();
    }

    public static SyncLevelingData decode(FriendlyByteBuf buf) {
        SyncLevelingData result = new SyncLevelingData();
        result.compoundTag = buf.m_130261_();
        result.entityId = buf.readInt();
        return result;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.compoundTag);
        buf.writeInt(this.entityId);
    }

    public static void receive(SyncLevelingData message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SyncLevelingData.handlePacket(message, ctx)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SyncLevelingData message, NetworkEvent.Context ctx) {
        Minecraft client = Minecraft.m_91087_();
        Entity entity = client.f_91073_.m_6815_(message.entityId);
        if (entity instanceof LivingEntity) {
            LevelingDataProvider.get((LivingEntity)entity).ifPresent(levelingData -> levelingData.deserializeNBT((Tag)message.compoundTag));
        }
    }
}

