/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bloxysstructures.init;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.bloxysstructures.world.biome.AdventureRealmForestBiome;
import net.mcreator.bloxysstructures.world.biome.AdventureRealmLoreoForestBiome;
import net.mcreator.bloxysstructures.world.biome.AdventureRealmMjinForestBiome;
import net.mcreator.bloxysstructures.world.biome.AdventureRealmPlainsBiome;
import net.mcreator.bloxysstructures.world.biome.AdventureRealmXizaForestBiome;
import net.mcreator.bloxysstructures.world.biome.BloxyVoidPlainsBiome;
import net.mcreator.bloxysstructures.world.biome.CorruptedPlainsBiome;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BloxysStructuresModBiomes {
    private static final List<Biome> REGISTRY = new ArrayList<Biome>();
    public static Biome ADVENTURE_REALM_FOREST = BloxysStructuresModBiomes.register("adventure_realm_forest", AdventureRealmForestBiome.createBiome());
    public static Biome BLOXY_VOID_PLAINS = BloxysStructuresModBiomes.register("bloxy_void_plains", BloxyVoidPlainsBiome.createBiome());
    public static Biome CORRUPTED_PLAINS = BloxysStructuresModBiomes.register("corrupted_plains", CorruptedPlainsBiome.createBiome());
    public static Biome ADVENTURE_REALM_MJIN_FOREST = BloxysStructuresModBiomes.register("adventure_realm_mjin_forest", AdventureRealmMjinForestBiome.createBiome());
    public static Biome ADVENTURE_REALM_LOREO_FOREST = BloxysStructuresModBiomes.register("adventure_realm_loreo_forest", AdventureRealmLoreoForestBiome.createBiome());
    public static Biome ADVENTURE_REALM_XIZA_FOREST = BloxysStructuresModBiomes.register("adventure_realm_xiza_forest", AdventureRealmXizaForestBiome.createBiome());
    public static Biome ADVENTURE_REALM_PLAINS = BloxysStructuresModBiomes.register("adventure_realm_plains", AdventureRealmPlainsBiome.createBiome());

    private static Biome register(String registryname, Biome biome) {
        REGISTRY.add((Biome)biome.setRegistryName(new ResourceLocation("bloxys_structures", registryname)));
        return biome;
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])REGISTRY.toArray(new Biome[0]));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AdventureRealmForestBiome.init();
            BloxyVoidPlainsBiome.init();
            CorruptedPlainsBiome.init();
            AdventureRealmMjinForestBiome.init();
            AdventureRealmLoreoForestBiome.init();
            AdventureRealmXizaForestBiome.init();
            AdventureRealmPlainsBiome.init();
        });
    }
}

