/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.data;

import de.markusbordihn.dailyrewards.rewards.Rewards;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardUserData
extends SavedData {
    protected static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    public static final String ITEMS_TAG = "RewardItems";
    public static final String ITEM_LIST_TAG = "ItemList";
    public static final String LAST_REWARDED_DAY_TAG = "LastRewardedDay";
    public static final String REWARDED_DAYS_TAG = "RewardedDays";
    public static final String USER_REWARDS_TAG = "UserRewards";
    public static final String YEAR_MONTH_TAG = "YearMonth";
    public static final String YEAR_MONTH_USER_TAG = "YearMonthUser";
    private static final String FILE_ID = "daily_rewards_user";
    private static MinecraftServer server;
    private static RewardUserData data;
    private static ConcurrentHashMap<String, List<ItemStack>> rewardItemsMap;
    private static ConcurrentHashMap<String, Integer> rewardedDaysMap;
    private static ConcurrentHashMap<String, String> lastRewardedDayMap;

    public RewardUserData() {
        this.m_77762_();
    }

    public static void prepare(MinecraftServer server) {
        if (server == null || server == RewardUserData.server && data != null) {
            return;
        }
        log.info("{} preparing reward user data for {}", (Object)"Daily Rewards", (Object)server);
        RewardUserData.server = server;
        data = (RewardUserData)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(RewardUserData::load, RewardUserData::new, RewardUserData.getFileId());
    }

    public static boolean available() {
        RewardUserData.get();
        return data != null;
    }

    public static RewardUserData get() {
        if (data == null) {
            RewardUserData.prepare(ServerLifecycleHooks.getCurrentServer());
        }
        return data;
    }

    public static String getFileId() {
        return FILE_ID;
    }

    public static String getKeyId(int year, int month, UUID uuid) {
        return year + "-" + month + ":" + uuid.toString();
    }

    public void addRewardFor(int year, int month, int day, UUID uuid, ItemStack itemStack) {
        int rewardIndex;
        List<ItemStack> rewards = this.getRewardsFor(year, month, uuid);
        if ((rewardIndex = --day) >= 0 && rewards.size() > rewardIndex) {
            rewards.add(rewardIndex, itemStack);
        } else {
            rewards.add(itemStack);
        }
        this.m_77762_();
    }

    public void addRewardForCurrentMonth(int day, UUID uuid, ItemStack itemStack) {
        this.addRewardFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), day, uuid, itemStack);
    }

    public List<ItemStack> getRewardsFor(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        return rewardItemsMap.computeIfAbsent(key, id -> new ArrayList());
    }

    public List<ItemStack> getRewardsForCurrentMonth(UUID uuid) {
        return this.getRewardsFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public CompoundTag getRewardsForCurrentMonthSyncData(UUID uuid) {
        List<ItemStack> rewardItems = this.getRewardsForCurrentMonth(uuid);
        CompoundTag syncData = new CompoundTag();
        ListTag itemListTag = new ListTag();
        for (int i = 0; i < rewardItems.size(); ++i) {
            ItemStack itemStack = rewardItems.get(i);
            CompoundTag itemStackTag = new CompoundTag();
            itemStack.m_41739_(itemStackTag);
            itemListTag.add((Object)itemStackTag);
        }
        syncData.m_128365_(ITEM_LIST_TAG, (Tag)itemListTag);
        return syncData;
    }

    public void setRewardsForCurrentMonth(UUID uuid, List<ItemStack> rewardItems) {
        this.setRewardsFor(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid, rewardItems);
    }

    public void setRewardsFor(int year, int month, UUID uuid, List<ItemStack> rewardItems) {
        log.debug("Set rewards for {}-{} and player {} to: {}", (Object)year, (Object)month, (Object)uuid, rewardItems);
        String key = RewardUserData.getKeyId(year, month, uuid);
        rewardItemsMap.put(key, rewardItems);
        this.m_77762_();
    }

    public String getLastRewardedDay(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        return lastRewardedDayMap.computeIfAbsent(key, id -> "");
    }

    public String getLastRewardedDayForCurrentMonth(UUID uuid) {
        return this.getLastRewardedDay(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public void setLastRewardedDay(int year, int month, UUID uuid, String lastRewardedDay) {
        log.debug("Set last rewarded day for {}-{} and player {} to {}", (Object)year, (Object)month, (Object)uuid, (Object)lastRewardedDay);
        String key = RewardUserData.getKeyId(year, month, uuid);
        lastRewardedDayMap.put(key, lastRewardedDay);
        this.m_77762_();
    }

    public void setLastRewardedDayForCurrentMonth(UUID uuid) {
        this.setLastRewardedDay(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid, Rewards.getCurrentYearMonthDay());
    }

    public boolean hasRewardedToday(UUID uuid) {
        String lastRewardedDay = this.getLastRewardedDayForCurrentMonth(uuid);
        return Rewards.getCurrentYearMonthDay().equals(lastRewardedDay);
    }

    public int getRewardedDays(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        return rewardedDaysMap.getOrDefault(key, 0);
    }

    public int getRewardedDaysForCurrentMonth(UUID uuid) {
        return this.getRewardedDays(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public int increaseRewardedDays(int year, int month, UUID uuid) {
        String key = RewardUserData.getKeyId(year, month, uuid);
        int rewardedDays = rewardedDaysMap.getOrDefault(key, 0);
        rewardedDaysMap.put(key, ++rewardedDays);
        this.m_77762_();
        return rewardedDays;
    }

    public int increaseRewardedDaysForCurrentMonth(UUID uuid) {
        return this.increaseRewardedDays(Rewards.getCurrentYear(), Rewards.getCurrentMonth(), uuid);
    }

    public static RewardUserData load(CompoundTag compoundTag) {
        RewardUserData rewardData = new RewardUserData();
        log.info("{} loading reward user data ... {}", (Object)"Daily Rewards", (Object)compoundTag);
        if (compoundTag.m_128441_(USER_REWARDS_TAG)) {
            ListTag listTag = compoundTag.m_128437_(USER_REWARDS_TAG, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag rewardUserTag = listTag.m_128728_(i);
                String rewardKey = rewardUserTag.m_128461_(YEAR_MONTH_USER_TAG);
                ArrayList<ItemStack> rewardItems = new ArrayList<ItemStack>();
                ListTag itemListTag = rewardUserTag.m_128437_(ITEMS_TAG, 10);
                for (int i2 = 0; i2 < itemListTag.size(); ++i2) {
                    ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemListTag.m_128728_(i2));
                    rewardItems.add(itemStack);
                }
                rewardItemsMap.put(rewardKey, rewardItems);
                rewardedDaysMap.put(rewardKey, rewardUserTag.m_128451_(REWARDED_DAYS_TAG));
                lastRewardedDayMap.put(rewardKey, rewardUserTag.m_128461_(LAST_REWARDED_DAY_TAG));
            }
        }
        log.debug("{} Loaded stored rewards user data from disk: {}", (Object)"Daily Rewards", (Object)rewardData);
        return rewardData;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        HashSet rewardKeys = new HashSet();
        rewardKeys.addAll(rewardItemsMap.keySet());
        rewardKeys.addAll(rewardedDaysMap.keySet());
        rewardKeys.addAll(lastRewardedDayMap.keySet());
        if (rewardKeys.isEmpty()) {
            log.warn("{} unable to save reward user data, because data are empty!", (Object)"Daily Rewards");
            return compoundTag;
        }
        log.info("{} saving reward user data for {} ...", (Object)"Daily Rewards", rewardKeys);
        ListTag listTag = new ListTag();
        compoundTag.m_128365_(USER_REWARDS_TAG, (Tag)listTag);
        for (String rewardKey : rewardKeys) {
            CompoundTag rewardUserTag = new CompoundTag();
            rewardUserTag.m_128359_(YEAR_MONTH_USER_TAG, rewardKey);
            ListTag itemListTag = new ListTag();
            List<ItemStack> rewardItems = rewardItemsMap.get(rewardKey);
            for (int i = 0; i < rewardItems.size(); ++i) {
                ItemStack itemStack = rewardItems.get(i);
                CompoundTag itemStackTag = new CompoundTag();
                itemStack.m_41739_(itemStackTag);
                itemListTag.add((Object)itemStackTag);
            }
            rewardUserTag.m_128365_(ITEMS_TAG, (Tag)itemListTag);
            rewardUserTag.m_128405_(REWARDED_DAYS_TAG, rewardedDaysMap.getOrDefault(rewardKey, 0).intValue());
            rewardUserTag.m_128359_(LAST_REWARDED_DAY_TAG, lastRewardedDayMap.getOrDefault(rewardKey, ""));
            listTag.add((Object)rewardUserTag);
        }
        return compoundTag;
    }

    static {
        rewardItemsMap = new ConcurrentHashMap();
        rewardedDaysMap = new ConcurrentHashMap();
        lastRewardedDayMap = new ConcurrentHashMap();
    }
}

