/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.dailyrewards.menu;

import de.markusbordihn.dailyrewards.data.RewardClientData;
import de.markusbordihn.dailyrewards.data.RewardData;
import de.markusbordihn.dailyrewards.data.RewardUserData;
import de.markusbordihn.dailyrewards.menu.ModMenuTypes;
import de.markusbordihn.dailyrewards.menu.slots.RewardSlot;
import de.markusbordihn.dailyrewards.menu.slots.TakeableRewardSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RewardMenu
extends AbstractContainerMenu {
    public static final Logger log = LogManager.getLogger((String)"Daily Rewards");
    public static final int PLAYER_SLOT_START = 9;
    public static final int PLAYER_INVENTORY_SLOT_START = 9;
    public static final int PLAYER_SLOT_STOP = 44;
    private static int containerSize = 32;
    private static int slotSize = 18;
    private static int rewardSlotSizeX = 23;
    private static int rewardSlotSizeY = 28;
    private Container rewardsContainer = new SimpleContainer(containerSize);
    private Container rewardsUserContainer = new SimpleContainer(containerSize);
    private int rewardedDays = 0;
    protected final Level level;
    protected final Player player;

    public RewardMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (MenuType)ModMenuTypes.REWARD_MENU.get());
    }

    public RewardMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory);
    }

    public RewardMenu(int windowId, Inventory playerInventory, MenuType<?> menuType) {
        super(menuType, windowId);
        List<ItemStack> userRewards;
        List<ItemStack> rewardsForCurrentMonth;
        this.player = playerInventory.f_35978_;
        this.level = this.player.m_9236_();
        this.rewardedDays = this.level.f_46443_ ? RewardClientData.getRewardedDaysForCurrentMonth() : RewardUserData.get().getRewardedDaysForCurrentMonth(this.player.m_20148_());
        List<ItemStack> list = rewardsForCurrentMonth = this.level.f_46443_ ? RewardClientData.getGeneralRewardsForCurrentMonth() : RewardData.get().getRewardsForCurrentMonth();
        if (!rewardsForCurrentMonth.isEmpty()) {
            for (int index = 0; index < rewardsForCurrentMonth.size(); ++index) {
                this.rewardsContainer.m_6836_(index, rewardsForCurrentMonth.get(index));
            }
        }
        List<ItemStack> list2 = userRewards = this.level.f_46443_ ? RewardClientData.getUserRewardsForCurrentMonth() : RewardUserData.get().getRewardsForCurrentMonth(this.player.m_20148_());
        if (!userRewards.isEmpty()) {
            for (int index = 0; index < userRewards.size(); ++index) {
                this.rewardsUserContainer.m_6836_(index, userRewards.get(index));
            }
        }
        int rewardStartPositionY = 17;
        int rewardStartPositionX = 9;
        for (int rewardRow = 0; rewardRow < 5; ++rewardRow) {
            for (int rewardColumn = 0; rewardColumn < 7; ++rewardColumn) {
                int rewardSlotIndex = rewardColumn + rewardRow * 7;
                if (userRewards.size() > rewardSlotIndex && userRewards.get(rewardSlotIndex) != null && !userRewards.get(rewardSlotIndex).m_41619_()) {
                    this.m_38897_(new TakeableRewardSlot(this.rewardsUserContainer, rewardSlotIndex, rewardStartPositionX + rewardColumn * rewardSlotSizeX, rewardStartPositionY + rewardRow * rewardSlotSizeY, this));
                    continue;
                }
                if (rewardsForCurrentMonth.size() <= rewardSlotIndex) continue;
                this.m_38897_(new RewardSlot(this.rewardsContainer, rewardSlotIndex, rewardStartPositionX + rewardColumn * rewardSlotSizeX, rewardStartPositionY + rewardRow * rewardSlotSizeY, this));
            }
        }
        int playerInventoryStartPositionY = 168;
        int playerInventoryStartPositionX = 6;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.m_38897_(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + inventoryColumn * slotSize, playerInventoryStartPositionY + inventoryRow * slotSize));
            }
        }
        int hotbarStartPositionY = 226;
        int hotbarStartPositionX = 6;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.m_38897_(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + playerInventorySlot * slotSize, hotbarStartPositionY));
        }
    }

    public void syncRewardsUserContainer(Player player) {
        ArrayList<ItemStack> userRewards = new ArrayList<ItemStack>();
        for (int index = 0; index < this.rewardsUserContainer.m_6643_(); ++index) {
            ItemStack itemStack = this.rewardsUserContainer.m_8020_(index);
            if (itemStack == null || itemStack.m_41619_()) continue;
            userRewards.add(itemStack);
        }
        if (this.level.f_46443_) {
            RewardClientData.setUserRewardsForCurrentMonth(userRewards);
        } else {
            RewardUserData.get().setRewardsForCurrentMonth(player.m_20148_(), userRewards);
        }
    }

    public int getRewardedDays() {
        return this.rewardedDays;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

