/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.blocks;

import com.fizzware.dramaticdoors.blocks.DramaticDoorsBlocks;
import com.fizzware.dramaticdoors.compat.Compats;
import com.fizzware.dramaticdoors.state.properties.DoorBlockStateProperties;
import com.fizzware.dramaticdoors.state.properties.TripleBlockPart;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.NotImplementedException;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TallDoorBlock
extends Block {
    public static final String NAME_OAK = "tall_oak_door";
    public static final String NAME_SPRUCE = "tall_spruce_door";
    public static final String NAME_BIRCH = "tall_birch_door";
    public static final String NAME_JUNGLE = "tall_jungle_door";
    public static final String NAME_ACACIA = "tall_acacia_door";
    public static final String NAME_DARK_OAK = "tall_dark_oak_door";
    public static final String NAME_IRON = "tall_iron_door";
    public static final String NAME_CRIMSON = "tall_crimson_door";
    public static final String NAME_WARPED = "tall_warped_door";
    public static final String NAME_BOP_CHERRY = "tall_bop_cherry_door";
    public static final String NAME_BOP_DEAD = "tall_bop_dead_door";
    public static final String NAME_BOP_FIR = "tall_bop_fir_door";
    public static final String NAME_BOP_HELLBARK = "tall_bop_hellbark_door";
    public static final String NAME_BOP_JACARANDA = "tall_bop_jacaranda_door";
    public static final String NAME_BOP_MAGIC = "tall_bop_magic_door";
    public static final String NAME_BOP_MAHOGANY = "tall_bop_mahogany_door";
    public static final String NAME_BOP_PALM = "tall_bop_palm_door";
    public static final String NAME_BOP_REDWOOD = "tall_bop_redwood_door";
    public static final String NAME_BOP_UMBRAN = "tall_bop_umbran_door";
    public static final String NAME_BOP_WILLOW = "tall_bop_willow_door";
    public static final String NAME_ARAUCARIA = "tall_araucaria_door";
    public static final String NAME_HEIDIPHYLLUM = "tall_heidiphyllum_door";
    public static final String NAME_LIRIODENDRITES = "tall_liriodendrites_door";
    public static final String NAME_METASEQUOIA = "tall_metasequoia_door";
    public static final String NAME_PROTOJUNIPEROXYLON = "tall_protojuniperoxylon_door";
    public static final String NAME_PROTOPICEOXYLON = "tall_protopiceoxylon_door";
    public static final String NAME_ZAMITES = "tall_zamites_door";
    public static final String NAME_CANOPY = "tall_canopy_door";
    public static final String NAME_DARKWOOD = "tall_darkwood_door";
    public static final String NAME_MANGROVE = "tall_mangrove_door";
    public static final String NAME_MINEWOOD = "tall_minewood_door";
    public static final String NAME_SORTINGWOOD = "tall_sortingwood_door";
    public static final String NAME_TIMEWOOD = "tall_timewood_door";
    public static final String NAME_TRANSWOOD = "tall_transwood_door";
    public static final String NAME_TWILIGHT_OAK = "tall_twilight_oak_door";
    public static final String NAME_ASPEN = "tall_aspen_door";
    public static final String NAME_GRIMWOOD = "tall_grimwood_door";
    public static final String NAME_KOUSA = "tall_kousa_door";
    public static final String NAME_MORADO = "tall_morado_door";
    public static final String NAME_ROSEWOOD = "tall_rosewood_door";
    public static final String NAME_YUCCA = "tall_yucca_door";
    public static final String NAME_MAPLE = "tall_maple_door";
    public static final String NAME_BAMBOO = "tall_bamboo_door";
    public static final String NAME_HONEYCOMB = "tall_honeycomb_door";
    public static final String NAME_POISE = "tall_poise_door";
    public static final String NAME_CHERRY = "tall_cherry_door";
    public static final String NAME_WISTERIA = "tall_wisteria_door";
    public static final String NAME_WILLOW = "tall_willow_door";
    public static final String NAME_DRIFTWOOD = "tall_driftwood_door";
    public static final String NAME_RIVER = "tall_river_door";
    public static final String NAME_GLASS = "tall_glass_door";
    public static final String NAME_TOOTH = "tall_tooth_door";
    public static final String NAME_JACARANDA = "tall_jacaranda_door";
    public static final String NAME_REDBUD = "tall_redbud_door";
    public static final String NAME_CYPRESS = "tall_cypress_door";
    public static final String NAME_BROWN_MUSHROOM = "tall_brown_mushroom_door";
    public static final String NAME_RED_MUSHROOM = "tall_red_mushroom_door";
    public static final String NAME_GLOWSHROOM = "tall_glowshroom_door";
    public static final String NAME_PETRIFIED = "tall_petrified_door";
    public static final String NAME_CARDBOARD = "tall_cardboard_door";
    public static final String NAME_CHAIN = "tall_chain_door";
    public static final String NAME_INDUSTRIAL_IRON = "tall_industrial_iron_door";
    public static final String NAME_IRON_BAR = "tall_iron_bar_door";
    public static final String NAME_PADDED = "tall_padded_door";
    public static final String NAME_RUSTY_IRON = "tall_rusty_iron_door";
    public static final String NAME_RUSTY_SHEET_METAL = "tall_rusty_sheet_metal_door";
    public static final String NAME_SHEET_METAL = "tall_sheet_metal_door";
    public static final String NAME_FAIRY_RING_MUSHROOM = "tall_fairy_ring_mushroom_door";
    public static final String NAME_AZURE = "tall_azure_door";
    public static final String NAME_GOLD = "tall_gold_door";
    public static final String NAME_NETHERITE = "tall_netherite_door";
    public static final EnumProperty<TripleBlockPart> THIRD = DoorBlockStateProperties.TRIPLE_BLOCK_THIRD;
    public static final DirectionProperty FACING = HorizontalFaceBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public static String[] getNames(DramaticDoorsBlocks.DoorSeries series) {
        switch (series) {
            case VANILLA: {
                return new String[]{NAME_OAK, NAME_SPRUCE, NAME_BIRCH, NAME_JUNGLE, NAME_ACACIA, NAME_DARK_OAK, NAME_IRON, NAME_CRIMSON, NAME_WARPED};
            }
            case BOP: {
                return new String[]{NAME_BOP_CHERRY, NAME_BOP_DEAD, NAME_BOP_FIR, NAME_BOP_HELLBARK, NAME_BOP_JACARANDA, NAME_BOP_MAGIC, NAME_BOP_MAHOGANY, NAME_BOP_PALM, NAME_BOP_REDWOOD, NAME_BOP_UMBRAN, NAME_BOP_WILLOW};
            }
            case BYG: {
                throw new NotImplementedException("Oh the Biomes You'll Go mod is not currently implemented.");
            }
            case PREHISTORIC_FAUNA: {
                return new String[]{NAME_ARAUCARIA, NAME_HEIDIPHYLLUM, NAME_LIRIODENDRITES, NAME_METASEQUOIA, NAME_PROTOJUNIPEROXYLON, NAME_PROTOPICEOXYLON, NAME_ZAMITES};
            }
            case TWILIGHT_FOREST: {
                return new String[]{NAME_CANOPY, NAME_DARKWOOD, NAME_MANGROVE, NAME_MINEWOOD, NAME_SORTINGWOOD, NAME_TIMEWOOD, NAME_TRANSWOOD, NAME_TWILIGHT_OAK};
            }
            case ATMOSPHERIC: {
                return new String[]{NAME_ASPEN, NAME_GRIMWOOD, NAME_KOUSA, NAME_MORADO, NAME_ROSEWOOD, NAME_YUCCA};
            }
            case AUTUMNITY: {
                return new String[]{NAME_MAPLE};
            }
            case BAMBOO: {
                return new String[]{NAME_BAMBOO};
            }
            case BUZZIER: {
                return new String[]{NAME_HONEYCOMB};
            }
            case ENDERGETIC: {
                return new String[]{NAME_POISE};
            }
            case ENVIRONMENTAL: {
                return new String[]{NAME_CHERRY, NAME_WISTERIA, NAME_WILLOW};
            }
            case UPGRADE_AQUATIC: {
                return new String[]{NAME_DRIFTWOOD, NAME_RIVER, NAME_GLASS, NAME_TOOTH};
            }
            case ABUNDANCE: {
                return new String[]{NAME_JACARANDA, NAME_REDBUD};
            }
            case BAYOU_BLUES: {
                return new String[]{NAME_CYPRESS};
            }
            case ENH_MUSHROOMS: {
                return new String[]{NAME_BROWN_MUSHROOM, NAME_RED_MUSHROOM, NAME_GLOWSHROOM};
            }
            case DARKER_DEPTHS: {
                return new String[]{NAME_PETRIFIED};
            }
            case DUSTRIAL_DECOR: {
                return new String[]{NAME_CARDBOARD, NAME_CHAIN, NAME_INDUSTRIAL_IRON, NAME_IRON_BAR, NAME_PADDED, NAME_RUSTY_IRON, NAME_RUSTY_SHEET_METAL, NAME_SHEET_METAL};
            }
            case HABITAT: {
                return new String[]{NAME_FAIRY_RING_MUSHROOM};
            }
            case OUTER_END: {
                return new String[]{NAME_AZURE};
            }
            case SUPPLEMENTARIES: {
                return new String[]{NAME_GOLD, NAME_NETHERITE};
            }
        }
        throw new NotImplementedException("Don't use the tall version of DoorSeries.");
    }

    public TallDoorBlock(Block from) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)from));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.FALSE)).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)POWERED, (Comparable)Boolean.FALSE)).func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.LOWER)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)stateIn.func_177229_b(THIRD));
        if (facing.func_176740_k() == Direction.Axis.Y && (tripleblockpart == TripleBlockPart.LOWER == (facing == Direction.UP) || tripleblockpart == TripleBlockPart.MIDDLE)) {
            if (facingState.func_177230_c() == this && facingState.func_177229_b(THIRD) != tripleblockpart) {
                return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a((Property)FACING, (Comparable)((Direction)facingState.func_177229_b((Property)FACING)))).func_206870_a((Property)OPEN, (Comparable)((Boolean)facingState.func_177229_b((Property)OPEN)))).func_206870_a(HINGE, (Comparable)((DoorHingeSide)facingState.func_177229_b(HINGE)))).func_206870_a((Property)POWERED, (Comparable)((Boolean)facingState.func_177229_b((Property)POWERED)));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (tripleblockpart == TripleBlockPart.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K && player.func_184812_l_()) {
            BlockPos otherPos1 = pos;
            BlockPos otherPos2 = pos;
            TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)state.func_177229_b(THIRD));
            switch (tripleblockpart) {
                case LOWER: {
                    otherPos1 = pos.func_177984_a();
                    otherPos2 = pos.func_177981_b(2);
                    break;
                }
                case MIDDLE: {
                    otherPos1 = pos.func_177977_b();
                    otherPos2 = pos.func_177984_a();
                    break;
                }
                case UPPER: {
                    otherPos1 = pos.func_177979_c(2);
                    otherPos2 = pos.func_177977_b();
                }
            }
            BlockState blockstate1 = worldIn.func_180495_p(otherPos1);
            BlockState blockstate2 = worldIn.func_180495_p(otherPos2);
            if (blockstate1.func_177230_c() == state.func_177230_c() && blockstate1.func_177229_b(THIRD) == TripleBlockPart.LOWER) {
                worldIn.func_180501_a(otherPos1, Blocks.field_150350_a.func_176223_P(), 35);
                worldIn.func_217378_a(player, 2001, otherPos1, Block.func_196246_j((BlockState)blockstate1));
            }
            if (blockstate2.func_177230_c() == state.func_177230_c() && blockstate2.func_177229_b(THIRD) == TripleBlockPart.LOWER) {
                worldIn.func_180501_a(otherPos2, Blocks.field_150350_a.func_176223_P(), 35);
                worldIn.func_217378_a(player, 2001, otherPos1, Block.func_196246_j((BlockState)blockstate1));
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context) && context.func_195991_k().func_180495_p(blockpos.func_177981_b(2)).func_196953_a(context)) {
            World level = context.func_195991_k();
            boolean flag = level.func_175640_z(blockpos) || level.func_175640_z(blockpos.func_177984_a());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(HINGE, (Comparable)this.getHinge(context))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(flag))).func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.LOWER));
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE)), 3);
        worldIn.func_180501_a(pos.func_177984_a().func_177984_a(), (BlockState)state.func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.UPPER)), 3);
    }

    private DoorHingeSide getHinge(BlockItemUseContext context) {
        boolean rightIsLowerOfSameType;
        World IBlockReader2 = context.func_195991_k();
        BlockPos placePos = context.func_195995_a();
        Direction behindDir = context.func_195992_f();
        BlockPos placePosAbove = placePos.func_177984_a();
        Direction leftDir = behindDir.func_176735_f();
        BlockPos leftPos = placePos.func_177972_a(leftDir);
        BlockState leftBlockstate = IBlockReader2.func_180495_p(leftPos);
        BlockPos leftPosAbove = placePosAbove.func_177972_a(leftDir);
        BlockState leftAboveBlockstate = IBlockReader2.func_180495_p(leftPosAbove);
        Direction rightDir = behindDir.func_176746_e();
        BlockPos rightPos = placePos.func_177972_a(rightDir);
        BlockState rightBlockstate = IBlockReader2.func_180495_p(rightPos);
        BlockPos rightPosAbove = placePosAbove.func_177972_a(rightDir);
        BlockState rightAboveBlockstate = IBlockReader2.func_180495_p(rightPosAbove);
        int i = (leftBlockstate.func_235785_r_((IBlockReader)IBlockReader2, leftPos) ? -1 : 0) + (leftAboveBlockstate.func_235785_r_((IBlockReader)IBlockReader2, leftPosAbove) ? -1 : 0) + (rightBlockstate.func_235785_r_((IBlockReader)IBlockReader2, rightPos) ? 1 : 0) + (rightAboveBlockstate.func_235785_r_((IBlockReader)IBlockReader2, rightPosAbove) ? 1 : 0);
        boolean leftIsLowerOfSameType = leftBlockstate.func_177230_c() == this && leftBlockstate.func_177229_b(THIRD) == TripleBlockPart.LOWER;
        boolean bl = rightIsLowerOfSameType = rightBlockstate.func_177230_c() == this && rightBlockstate.func_177229_b(THIRD) == TripleBlockPart.LOWER;
        if ((!leftIsLowerOfSameType || rightIsLowerOfSameType) && i <= 0) {
            if ((!rightIsLowerOfSameType || leftIsLowerOfSameType) && i >= 0) {
                int j = behindDir.func_82601_c();
                int k = behindDir.func_82599_e();
                Vector3d vec3d = context.func_221532_j();
                double d0 = vec3d.field_72450_a - (double)placePos.func_177958_n();
                double d1 = vec3d.field_72449_c - (double)placePos.func_177952_p();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == Material.field_151573_f && this != DramaticDoorsBlocks.TALL_GOLD_DOOR && this != DramaticDoorsBlocks.TALL_NETHERITE_DOOR) {
            return ActionResultType.PASS;
        }
        if (this == DramaticDoorsBlocks.TALL_GOLD_DOOR && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return ActionResultType.PASS;
        }
        TallDoorBlock.tryOpenDoubleDoor(worldIn, state, pos);
        state = (BlockState)state.func_235896_a_((Property)OPEN);
        worldIn.func_180501_a(pos, state, 10);
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        if (this == DramaticDoorsBlocks.TALL_TOOTH_DOOR) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 20);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            state = (BlockState)state.func_235896_a_((Property)OPEN);
            worldIn.func_180501_a(pos, state, 10);
            worldIn.func_217378_a(null, (Boolean)state.func_177229_b((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        }
    }

    public void toggleDoor(World worldIn, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((Property)OPEN) != open) {
            worldIn.func_180501_a(pos, (BlockState)blockstate.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            if (blockstate.func_177229_b(THIRD) == TripleBlockPart.UPPER) {
                BlockState middle = worldIn.func_180495_p(pos.func_177977_b());
                BlockState bottom = worldIn.func_180495_p(pos.func_177979_c(2));
                if (middle.func_177230_c() == this) {
                    worldIn.func_180501_a(pos.func_177977_b(), (BlockState)middle.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
                }
                if (bottom.func_177230_c() == this) {
                    worldIn.func_180501_a(pos.func_177979_c(2), (BlockState)middle.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
                }
            }
            this.playSound(worldIn, pos, open);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = worldIn.func_175640_z(pos);
        if (!flag) {
            switch ((TripleBlockPart)((Object)state.func_177229_b(THIRD))) {
                case LOWER: {
                    flag = worldIn.func_175640_z(pos.func_177972_a(Direction.UP)) || worldIn.func_175640_z(pos.func_177967_a(Direction.UP, 2));
                    break;
                }
                case MIDDLE: {
                    flag = worldIn.func_175640_z(pos.func_177972_a(Direction.DOWN)) || worldIn.func_175640_z(pos.func_177972_a(Direction.UP));
                    break;
                }
                case UPPER: {
                    boolean bl = flag = worldIn.func_175640_z(pos.func_177972_a(Direction.DOWN)) || worldIn.func_175640_z(pos.func_177967_a(Direction.DOWN, 2));
                }
            }
        }
        if (blockIn != this && flag != (Boolean)state.func_177229_b((Property)POWERED)) {
            if (this == DramaticDoorsBlocks.TALL_GOLD_DOOR) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            } else {
                if (flag != (Boolean)state.func_177229_b((Property)OPEN)) {
                    this.playSound(worldIn, pos, flag);
                }
                TallDoorBlock.tryOpenDoubleDoor(worldIn, state, pos);
                worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        BlockPos below2 = below.func_177977_b();
        BlockState belowState = worldIn.func_180495_p(below);
        BlockState below2State = worldIn.func_180495_p(below2);
        if (state.func_177229_b(THIRD) == TripleBlockPart.LOWER) {
            boolean result = belowState.func_224755_d((IBlockReader)worldIn, below, Direction.UP);
            return result;
        }
        if (state.func_177229_b(THIRD) == TripleBlockPart.MIDDLE) {
            boolean result = belowState.func_177230_c() == this;
            return result;
        }
        boolean result = belowState.func_177230_c() == this && below2State.func_177230_c() == this;
        return result;
    }

    private void playSound(World level, BlockPos pos, boolean isOpen) {
        level.func_217378_a(null, isOpen ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(THIRD) == TripleBlockPart.LOWER ? 0 : (state.func_177229_b(THIRD) == TripleBlockPart.MIDDLE ? 1 : 2)).func_177956_o(), (int)pos.func_177952_p());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{THIRD, FACING, OPEN, HINGE, POWERED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        boolean flag = (Boolean)state.func_177229_b((Property)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean allowsMovement(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((Property)OPEN);
            }
        }
        return false;
    }

    public PushReaction getPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING))).func_235896_a_(HINGE);
    }

    public static boolean isWoodenDoor(World level, BlockPos pos) {
        return TallDoorBlock.isWoodenDoor(level.func_180495_p(pos));
    }

    public static boolean isWoodenDoor(BlockState state) {
        return state.func_177230_c() instanceof TallDoorBlock && (state.func_185904_a() == Material.field_151575_d || state.func_185904_a() == Material.field_237214_y_);
    }

    public static void tryOpenDoubleDoor(World world, BlockState state, BlockPos pos) {
        if (Compats.DOUBLE_DOORS_INSTALLED) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            boolean isOpen = (Boolean)state.func_177229_b((Property)OPEN);
            DoorHingeSide isMirrored = (DoorHingeSide)state.func_177229_b(HINGE);
            BlockPos mirrorPos = pos.func_177972_a(isMirrored == DoorHingeSide.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
            BlockPos doorPos = state.func_177229_b(THIRD) == TripleBlockPart.LOWER ? mirrorPos : mirrorPos.func_177977_b();
            BlockState other = world.func_180495_p(doorPos);
            if (other.func_177230_c() == state.func_177230_c() && other.func_177229_b((Property)FACING) == direction && !((Boolean)other.func_177229_b((Property)POWERED)).booleanValue() && (Boolean)other.func_177229_b((Property)OPEN) == isOpen && other.func_177229_b(HINGE) != isMirrored) {
                BlockState newState = (BlockState)other.func_235896_a_((Property)OPEN);
                world.func_180501_a(doorPos, newState, 10);
            }
        }
    }
}

