/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.blocks;

import com.fizzware.dramaticdoors.blocks.DramaticDoorsBlocks;
import com.fizzware.dramaticdoors.compat.Compats;
import com.fizzware.dramaticdoors.state.properties.DoorBlockStateProperties;
import com.fizzware.dramaticdoors.state.properties.TripleBlockPart;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.NotImplementedException;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TallDoorBlock
extends Block {
    public static final String NAME_OAK = "tall_oak_door";
    public static final String NAME_SPRUCE = "tall_spruce_door";
    public static final String NAME_BIRCH = "tall_birch_door";
    public static final String NAME_JUNGLE = "tall_jungle_door";
    public static final String NAME_ACACIA = "tall_acacia_door";
    public static final String NAME_DARK_OAK = "tall_dark_oak_door";
    public static final String NAME_IRON = "tall_iron_door";
    public static final String NAME_CRIMSON = "tall_crimson_door";
    public static final String NAME_WARPED = "tall_warped_door";
    public static final String NAME_BOP_CHERRY = "tall_bop_cherry_door";
    public static final String NAME_BOP_DEAD = "tall_bop_dead_door";
    public static final String NAME_BOP_FIR = "tall_bop_fir_door";
    public static final String NAME_BOP_HELLBARK = "tall_bop_hellbark_door";
    public static final String NAME_BOP_JACARANDA = "tall_bop_jacaranda_door";
    public static final String NAME_BOP_MAGIC = "tall_bop_magic_door";
    public static final String NAME_BOP_MAHOGANY = "tall_bop_mahogany_door";
    public static final String NAME_BOP_PALM = "tall_bop_palm_door";
    public static final String NAME_BOP_REDWOOD = "tall_bop_redwood_door";
    public static final String NAME_BOP_UMBRAN = "tall_bop_umbran_door";
    public static final String NAME_BOP_WILLOW = "tall_bop_willow_door";
    public static final String NAME_ARAUCARIA = "tall_araucaria_door";
    public static final String NAME_HEIDIPHYLLUM = "tall_heidiphyllum_door";
    public static final String NAME_LIRIODENDRITES = "tall_liriodendrites_door";
    public static final String NAME_METASEQUOIA = "tall_metasequoia_door";
    public static final String NAME_PROTOJUNIPEROXYLON = "tall_protojuniperoxylon_door";
    public static final String NAME_PROTOPICEOXYLON = "tall_protopiceoxylon_door";
    public static final String NAME_ZAMITES = "tall_zamites_door";
    public static final String NAME_CANOPY = "tall_canopy_door";
    public static final String NAME_DARKWOOD = "tall_darkwood_door";
    public static final String NAME_MANGROVE = "tall_mangrove_door";
    public static final String NAME_MINEWOOD = "tall_minewood_door";
    public static final String NAME_SORTINGWOOD = "tall_sortingwood_door";
    public static final String NAME_TIMEWOOD = "tall_timewood_door";
    public static final String NAME_TRANSWOOD = "tall_transwood_door";
    public static final String NAME_TWILIGHT_OAK = "tall_twilight_oak_door";
    public static final String NAME_ASPEN = "tall_aspen_door";
    public static final String NAME_GRIMWOOD = "tall_grimwood_door";
    public static final String NAME_KOUSA = "tall_kousa_door";
    public static final String NAME_MORADO = "tall_morado_door";
    public static final String NAME_ROSEWOOD = "tall_rosewood_door";
    public static final String NAME_YUCCA = "tall_yucca_door";
    public static final String NAME_MAPLE = "tall_maple_door";
    public static final String NAME_BAMBOO = "tall_bamboo_door";
    public static final String NAME_HONEYCOMB = "tall_honeycomb_door";
    public static final String NAME_AZALEA = "tall_azalea_door";
    public static final String NAME_POISE = "tall_poise_door";
    public static final String NAME_CHERRY = "tall_cherry_door";
    public static final String NAME_WILLOW = "tall_willow_door";
    public static final String NAME_WISTERIA = "tall_wisteria_door";
    public static final String NAME_DRIFTWOOD = "tall_driftwood_door";
    public static final String NAME_RIVER = "tall_river_door";
    public static final String NAME_GLASS = "tall_glass_door";
    public static final String NAME_TOOTH = "tall_tooth_door";
    public static final String NAME_JACARANDA = "tall_jacaranda_door";
    public static final String NAME_REDBUD = "tall_redbud_door";
    public static final String NAME_CYPRESS = "tall_cypress_door";
    public static final String NAME_BROWN_MUSHROOM = "tall_brown_mushroom_door";
    public static final String NAME_RED_MUSHROOM = "tall_red_mushroom_door";
    public static final String NAME_GLOWSHROOM = "tall_glowshroom_door";
    public static final String NAME_TWISTED = "tall_twisted_door";
    public static final String NAME_BA_AZALEA = "tall_ba_azalea_door";
    public static final String NAME_BA_FLOWERING_AZALEA = "tall_ba_flowering_azalea_door";
    public static final String NAME_PETRIFIED = "tall_petrified_door";
    public static final String NAME_CARDBOARD = "tall_cardboard_door";
    public static final String NAME_CHAIN = "tall_chain_door";
    public static final String NAME_INDUSTRIAL_IRON = "tall_industrial_iron_door";
    public static final String NAME_IRON_BAR = "tall_iron_bar_door";
    public static final String NAME_PADDED = "tall_padded_door";
    public static final String NAME_RUSTY_IRON = "tall_rusty_iron_door";
    public static final String NAME_RUSTY_SHEET_METAL = "tall_rusty_sheet_metal_door";
    public static final String NAME_SHEET_METAL = "tall_sheet_metal_door";
    public static final String NAME_COCONUT = "tall_coconut_door";
    public static final String NAME_FAIRY_RING_MUSHROOM = "tall_fairy_ring_mushroom_door";
    public static final String NAME_AZURE = "tall_azure_door";
    public static final String NAME_QUARK_AZALEA = "tall_quark_azalea_door";
    public static final String NAME_QUARK_BLOSSOM = "tall_quark_blossom_door";
    public static final String NAME_GOLD = "tall_gold_door";
    public static final String NAME_SILVER = "tall_silver_door";
    public static final String NAME_LEAD = "tall_lead_door";
    public static final String NAME_NETHERITE = "tall_netherite_door";
    public static final EnumProperty<TripleBlockPart> THIRD = DoorBlockStateProperties.TRIPLE_BLOCK_THIRD;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public static String[] getNames(DramaticDoorsBlocks.DoorSeries series) {
        switch (series) {
            case VANILLA: {
                return new String[]{NAME_OAK, NAME_SPRUCE, NAME_BIRCH, NAME_JUNGLE, NAME_ACACIA, NAME_DARK_OAK, NAME_IRON, NAME_CRIMSON, NAME_WARPED};
            }
            case BOP: {
                return new String[]{NAME_BOP_CHERRY, NAME_BOP_DEAD, NAME_BOP_FIR, NAME_BOP_HELLBARK, NAME_BOP_JACARANDA, NAME_BOP_MAGIC, NAME_BOP_MAHOGANY, NAME_BOP_PALM, NAME_BOP_REDWOOD, NAME_BOP_UMBRAN, NAME_BOP_WILLOW};
            }
            case BYG: {
                throw new NotImplementedException("Oh the Biomes You'll Go mod is not currently implemented.");
            }
            case PREHISTORIC_FAUNA: {
                return new String[]{NAME_ARAUCARIA, NAME_HEIDIPHYLLUM, NAME_LIRIODENDRITES, NAME_METASEQUOIA, NAME_PROTOJUNIPEROXYLON, NAME_PROTOPICEOXYLON, NAME_ZAMITES};
            }
            case TWILIGHT_FOREST: {
                return new String[]{NAME_CANOPY, NAME_DARKWOOD, NAME_MANGROVE, NAME_MINEWOOD, NAME_SORTINGWOOD, NAME_TIMEWOOD, NAME_TRANSWOOD, NAME_TWILIGHT_OAK};
            }
            case ATMOSPHERIC: {
                return new String[]{NAME_ASPEN, NAME_GRIMWOOD, NAME_KOUSA, NAME_MORADO, NAME_ROSEWOOD, NAME_YUCCA};
            }
            case AUTUMNITY: {
                return new String[]{NAME_MAPLE};
            }
            case BAMBOO: {
                return new String[]{NAME_BAMBOO};
            }
            case BUZZIER: {
                return new String[]{NAME_HONEYCOMB};
            }
            case CAVERNS_CHASMS: {
                return new String[]{NAME_AZALEA};
            }
            case ENDERGETIC: {
                return new String[]{NAME_POISE};
            }
            case ENVIRONMENTAL: {
                return new String[]{NAME_CHERRY, NAME_WILLOW, NAME_WISTERIA};
            }
            case UPGRADE_AQUATIC: {
                return new String[]{NAME_DRIFTWOOD, NAME_RIVER, NAME_GLASS, NAME_TOOTH};
            }
            case ABUNDANCE: {
                return new String[]{NAME_JACARANDA, NAME_REDBUD};
            }
            case BAYOU_BLUES: {
                return new String[]{NAME_CYPRESS};
            }
            case ENH_MUSHROOMS: {
                return new String[]{NAME_BROWN_MUSHROOM, NAME_RED_MUSHROOM, NAME_GLOWSHROOM};
            }
            case ARCHITECTS_PALETTE: {
                return new String[]{NAME_TWISTED};
            }
            case BETTER_AZALEA: {
                return new String[]{NAME_BA_AZALEA, NAME_BA_FLOWERING_AZALEA};
            }
            case DARKER_DEPTHS: {
                return new String[]{NAME_PETRIFIED};
            }
            case DUSTRIAL_DECOR: {
                return new String[]{NAME_CARDBOARD, NAME_CHAIN, NAME_INDUSTRIAL_IRON, NAME_IRON_BAR, NAME_PADDED, NAME_RUSTY_IRON, NAME_RUSTY_SHEET_METAL, NAME_SHEET_METAL};
            }
            case ECOLOGICS: {
                return new String[]{NAME_COCONUT};
            }
            case HABITAT: {
                return new String[]{NAME_FAIRY_RING_MUSHROOM};
            }
            case OUTER_END: {
                return new String[]{NAME_AZURE};
            }
            case QUARK: {
                return new String[]{NAME_QUARK_AZALEA, NAME_QUARK_BLOSSOM};
            }
            case SUPPLEMENTARIES: {
                return new String[]{NAME_GOLD, NAME_SILVER, NAME_LEAD, NAME_NETHERITE};
            }
        }
        throw new NotImplementedException("Please don't use the tall version of DoorSeries.");
    }

    public TallDoorBlock(Block from) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)from));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(THIRD, (Comparable)((Object)TripleBlockPart.LOWER)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)stateIn.m_61143_(THIRD));
        if (facing.m_122434_() == Direction.Axis.Y && (tripleblockpart == TripleBlockPart.LOWER == (facing == Direction.UP) || tripleblockpart == TripleBlockPart.MIDDLE)) {
            if (facingState.m_60734_() == this && facingState.m_61143_(THIRD) != tripleblockpart) {
                return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)facingState.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)facingState.m_61143_(HINGE)))).m_61124_((Property)POWERED, (Comparable)((Boolean)facingState.m_61143_((Property)POWERED)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        if (tripleblockpart == TripleBlockPart.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_ && player.m_7500_()) {
            BlockPos otherPos1 = pos;
            BlockPos otherPos2 = pos;
            TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)state.m_61143_(THIRD));
            switch (tripleblockpart) {
                case LOWER: {
                    otherPos1 = pos.m_7494_();
                    otherPos2 = pos.m_6630_(2);
                    break;
                }
                case MIDDLE: {
                    otherPos1 = pos.m_7495_();
                    otherPos2 = pos.m_7494_();
                    break;
                }
                case UPPER: {
                    otherPos1 = pos.m_6625_(2);
                    otherPos2 = pos.m_7495_();
                }
            }
            BlockState blockstate1 = worldIn.m_8055_(otherPos1);
            BlockState blockstate2 = worldIn.m_8055_(otherPos2);
            if (blockstate1.m_60734_() == state.m_60734_() && blockstate1.m_61143_(THIRD) == TripleBlockPart.LOWER) {
                worldIn.m_7731_(otherPos1, Blocks.f_50016_.m_49966_(), 35);
                worldIn.m_5898_(player, 2001, otherPos1, Block.m_49956_((BlockState)blockstate1));
            }
            if (blockstate2.m_60734_() == state.m_60734_() && blockstate2.m_61143_(THIRD) == TripleBlockPart.LOWER) {
                worldIn.m_7731_(otherPos2, Blocks.f_50016_.m_49966_(), 35);
                worldIn.m_5898_(player, 2001, otherPos1, Block.m_49956_((BlockState)blockstate1));
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    private int getCloseSound() {
        return this.f_60442_ == Material.f_76279_ ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.f_60442_ == Material.f_76279_ ? 1005 : 1006;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context) && context.m_43725_().m_8055_(blockpos.m_6630_(2)).m_60629_(context)) {
            Level level = context.m_43725_();
            boolean flag = level.m_46753_(blockpos) || level.m_46753_(blockpos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(context))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_(THIRD, (Comparable)((Object)TripleBlockPart.LOWER));
        }
        return null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE)), 3);
        worldIn.m_7731_(pos.m_7494_().m_7494_(), (BlockState)state.m_61124_(THIRD, (Comparable)((Object)TripleBlockPart.UPPER)), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        boolean rightIsLowerOfSameType;
        Level BlockGetter2 = context.m_43725_();
        BlockPos placePos = context.m_8083_();
        Direction behindDir = context.m_8125_();
        BlockPos placePosAbove = placePos.m_7494_();
        Direction leftDir = behindDir.m_122428_();
        BlockPos leftPos = placePos.m_142300_(leftDir);
        BlockState leftBlockstate = BlockGetter2.m_8055_(leftPos);
        BlockPos leftPosAbove = placePosAbove.m_142300_(leftDir);
        BlockState leftAboveBlockstate = BlockGetter2.m_8055_(leftPosAbove);
        Direction rightDir = behindDir.m_122427_();
        BlockPos rightPos = placePos.m_142300_(rightDir);
        BlockState rightBlockstate = BlockGetter2.m_8055_(rightPos);
        BlockPos rightPosAbove = placePosAbove.m_142300_(rightDir);
        BlockState rightAboveBlockstate = BlockGetter2.m_8055_(rightPosAbove);
        int i = (leftBlockstate.m_60838_((BlockGetter)BlockGetter2, leftPos) ? -1 : 0) + (leftAboveBlockstate.m_60838_((BlockGetter)BlockGetter2, leftPosAbove) ? -1 : 0) + (rightBlockstate.m_60838_((BlockGetter)BlockGetter2, rightPos) ? 1 : 0) + (rightAboveBlockstate.m_60838_((BlockGetter)BlockGetter2, rightPosAbove) ? 1 : 0);
        boolean leftIsLowerOfSameType = leftBlockstate.m_60734_() == this && leftBlockstate.m_61143_(THIRD) == TripleBlockPart.LOWER;
        boolean bl = rightIsLowerOfSameType = rightBlockstate.m_60734_() == this && rightBlockstate.m_61143_(THIRD) == TripleBlockPart.LOWER;
        if ((!leftIsLowerOfSameType || rightIsLowerOfSameType) && i <= 0) {
            if ((!rightIsLowerOfSameType || leftIsLowerOfSameType) && i >= 0) {
                int j = behindDir.m_122429_();
                int k = behindDir.m_122431_();
                Vec3 vec3d = context.m_43720_();
                double d0 = vec3d.f_82479_ - (double)placePos.m_123341_();
                double d1 = vec3d.f_82481_ - (double)placePos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.f_60442_ == Material.f_76279_ && this != DramaticDoorsBlocks.TALL_SILVER_DOOR && this != DramaticDoorsBlocks.TALL_GOLD_DOOR && this != DramaticDoorsBlocks.TALL_NETHERITE_DOOR) {
            return InteractionResult.PASS;
        }
        if (this == DramaticDoorsBlocks.TALL_GOLD_DOOR && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (this == DramaticDoorsBlocks.TALL_SILVER_DOOR && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        TallDoorBlock.tryOpenDoubleDoor(worldIn, state, pos);
        state = (BlockState)state.m_61122_((Property)OPEN);
        worldIn.m_7731_(pos, state, 10);
        worldIn.m_5898_(player, (Boolean)state.m_61143_((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        worldIn.m_142346_((Entity)player, (Boolean)state.m_61143_((Property)OPEN) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        if (DramaticDoorsBlocks.TALL_TOOTH_DOOR != null && this == DramaticDoorsBlocks.TALL_TOOTH_DOOR) {
            worldIn.m_186460_(pos, (Block)this, 20);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (!worldIn.f_46443_) {
            state = (BlockState)state.m_61122_((Property)OPEN);
            worldIn.m_7731_(pos, state, 10);
            worldIn.m_5898_(null, (Boolean)state.m_61143_((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        }
    }

    public void toggleDoor(Level worldIn, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.m_8055_(pos);
        if (blockstate.m_60734_() == this && (Boolean)blockstate.m_61143_((Property)OPEN) != open) {
            worldIn.m_7731_(pos, (BlockState)blockstate.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            if (blockstate.m_61143_(THIRD) == TripleBlockPart.UPPER) {
                BlockState middle = worldIn.m_8055_(pos.m_7495_());
                BlockState bottom = worldIn.m_8055_(pos.m_6625_(2));
                if (middle.m_60734_() == this) {
                    worldIn.m_7731_(pos.m_7495_(), (BlockState)middle.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
                }
                if (bottom.m_60734_() == this) {
                    worldIn.m_7731_(pos.m_6625_(2), (BlockState)middle.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
                }
            }
            this.playSound(worldIn, pos, open);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = worldIn.m_46753_(pos);
        if (!flag) {
            switch ((TripleBlockPart)((Object)state.m_61143_(THIRD))) {
                case LOWER: {
                    flag = worldIn.m_46753_(pos.m_142300_(Direction.UP)) || worldIn.m_46753_(pos.m_5484_(Direction.UP, 2));
                    break;
                }
                case MIDDLE: {
                    flag = worldIn.m_46753_(pos.m_142300_(Direction.DOWN)) || worldIn.m_46753_(pos.m_142300_(Direction.UP));
                    break;
                }
                case UPPER: {
                    boolean bl = flag = worldIn.m_46753_(pos.m_142300_(Direction.DOWN)) || worldIn.m_46753_(pos.m_5484_(Direction.DOWN, 2));
                }
            }
        }
        if (blockIn != this && flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (this == DramaticDoorsBlocks.TALL_GOLD_DOOR || this == DramaticDoorsBlocks.TALL_SILVER_DOOR || this == DramaticDoorsBlocks.TALL_LEAD_DOOR) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            } else {
                if (flag != (Boolean)state.m_61143_((Property)OPEN)) {
                    this.playSound(worldIn, pos, flag);
                }
                TallDoorBlock.tryOpenDoubleDoor(worldIn, state, pos);
                worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockPos below2 = below.m_7495_();
        BlockState belowState = worldIn.m_8055_(below);
        BlockState below2State = worldIn.m_8055_(below2);
        if (state.m_61143_(THIRD) == TripleBlockPart.LOWER) {
            boolean result = belowState.m_60783_((BlockGetter)worldIn, below, Direction.UP);
            return result;
        }
        if (state.m_61143_(THIRD) == TripleBlockPart.MIDDLE) {
            boolean result = belowState.m_60734_() == this;
            return result;
        }
        boolean result = belowState.m_60734_() == this && below2State.m_60734_() == this;
        return result;
    }

    private void playSound(Level level, BlockPos pos, boolean isOpen) {
        level.m_5898_(null, isOpen ? this.getOpenSound() : this.getCloseSound(), pos, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(THIRD) == TripleBlockPart.LOWER ? 0 : (state.m_61143_(THIRD) == TripleBlockPart.MIDDLE ? 1 : 2)).m_123342_(), (int)pos.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{THIRD, FACING, OPEN, HINGE, POWERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean allowsMovement(BlockState state, BlockGetter worldIn, BlockPos pos, BlockPathTypes type) {
        switch (type) {
            case WALKABLE: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case OPEN: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
        }
        return false;
    }

    public PushReaction getPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public static boolean isWoodenDoor(Level level, BlockPos pos) {
        return TallDoorBlock.isWoodenDoor(level.m_8055_(pos));
    }

    public static boolean isWoodenDoor(BlockState state) {
        return state.m_60734_() instanceof TallDoorBlock && (state.m_60767_() == Material.f_76320_ || state.m_60767_() == Material.f_76321_);
    }

    public static void tryOpenDoubleDoor(Level world, BlockState state, BlockPos pos) {
        if (Compats.DOUBLE_DOORS_INSTALLED) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            boolean isOpen = (Boolean)state.m_61143_((Property)OPEN);
            DoorHingeSide isMirrored = (DoorHingeSide)state.m_61143_(HINGE);
            BlockPos mirrorPos = pos.m_142300_(isMirrored == DoorHingeSide.RIGHT ? direction.m_122428_() : direction.m_122427_());
            BlockPos doorPos = state.m_61143_(THIRD) == TripleBlockPart.LOWER ? mirrorPos : mirrorPos.m_7495_();
            BlockState other = world.m_8055_(doorPos);
            if (other.m_60734_() == state.m_60734_() && other.m_61143_((Property)FACING) == direction && !((Boolean)other.m_61143_((Property)POWERED)).booleanValue() && (Boolean)other.m_61143_((Property)OPEN) == isOpen && other.m_61143_(HINGE) != isMirrored) {
                BlockState newState = (BlockState)other.m_61122_((Property)OPEN);
                world.m_7731_(doorPos, newState, 10);
            }
        }
    }
}

