/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.blocks;

import com.fizzware.dramaticdoors.state.properties.DoorBlockStateProperties;
import com.fizzware.dramaticdoors.state.properties.TripleBlockPart;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TallDoorBlock
extends Block {
    public static final String NAME_OAK = "tall_oak_door";
    public static final String NAME_SPRUCE = "tall_spruce_door";
    public static final String NAME_BIRCH = "tall_birch_door";
    public static final String NAME_JUNGLE = "tall_jungle_door";
    public static final String NAME_ACACIA = "tall_acacia_door";
    public static final String NAME_DARK_OAK = "tall_dark_oak_door";
    public static final String NAME_IRON = "tall_iron_door";
    public static final EnumProperty<TripleBlockPart> THIRD = DoorBlockStateProperties.TRIPLE_BLOCK_THIRD;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public TallDoorBlock(Block from) {
        super(Block.Properties.func_200950_a((Block)from));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.FALSE)).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.FALSE)).func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.LOWER)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)stateIn.func_177229_b(THIRD));
        if (facing.func_176740_k() == Direction.Axis.Y && (tripleblockpart == TripleBlockPart.LOWER == (facing == Direction.UP) || tripleblockpart == TripleBlockPart.MIDDLE)) {
            if (facingState.func_177230_c() == this && facingState.func_177229_b(THIRD) != tripleblockpart) {
                return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a((IProperty)FACING, facingState.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)OPEN, facingState.func_177229_b((IProperty)OPEN))).func_206870_a(HINGE, facingState.func_177229_b(HINGE))).func_206870_a((IProperty)POWERED, facingState.func_177229_b((IProperty)POWERED));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (tripleblockpart == TripleBlockPart.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TripleBlockPart tripleblockpart = (TripleBlockPart)((Object)state.func_177229_b(THIRD));
        BlockPos otherPos1 = pos;
        BlockPos otherPos2 = pos;
        ItemStack itemstack = player.func_184614_ca();
        switch (tripleblockpart) {
            case LOWER: {
                otherPos1 = pos.func_177984_a();
                otherPos2 = pos.func_177981_b(2);
                break;
            }
            case MIDDLE: {
                otherPos1 = pos.func_177977_b();
                otherPos2 = pos.func_177984_a();
                break;
            }
            case UPPER: {
                otherPos1 = pos.func_177979_c(2);
                otherPos2 = pos.func_177977_b();
            }
        }
        BlockState blockstate1 = worldIn.func_180495_p(otherPos1);
        BlockState blockstate2 = worldIn.func_180495_p(otherPos2);
        boolean flag = false;
        if (blockstate1.func_177230_c() == this && blockstate1.func_177229_b(THIRD) != tripleblockpart) {
            worldIn.func_180501_a(otherPos1, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, otherPos1, Block.func_196246_j((BlockState)blockstate1));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                flag = true;
                Block.func_220054_a((BlockState)blockstate1, (World)worldIn, (BlockPos)otherPos1, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
            }
        }
        if (blockstate2.func_177230_c() == this && blockstate2.func_177229_b(THIRD) != tripleblockpart) {
            worldIn.func_180501_a(otherPos1, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, otherPos1, Block.func_196246_j((BlockState)blockstate2));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                flag = true;
                Block.func_220054_a((BlockState)blockstate2, (World)worldIn, (BlockPos)otherPos1, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
            }
        }
        if (flag) {
            Block.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context) && context.func_195991_k().func_180495_p(blockpos.func_177981_b(2)).func_196953_a(context)) {
            World world = context.func_195991_k();
            boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f())).func_206870_a(HINGE, (Comparable)this.getHingeSide(context))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag))).func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.LOWER));
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.MIDDLE)), 3);
        worldIn.func_180501_a(pos.func_177984_a().func_177984_a(), (BlockState)state.func_206870_a(THIRD, (Comparable)((Object)TripleBlockPart.UPPER)), 3);
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext p_208073_1_) {
        boolean rightIsLowerOfSameType;
        World iblockreader = p_208073_1_.func_195991_k();
        BlockPos placePos = p_208073_1_.func_195995_a();
        Direction behindDir = p_208073_1_.func_195992_f();
        BlockPos placePosAbove = placePos.func_177984_a();
        Direction leftDir = behindDir.func_176735_f();
        BlockPos leftPos = placePos.func_177972_a(leftDir);
        BlockState leftBlockstate = iblockreader.func_180495_p(leftPos);
        BlockPos leftPosAbove = placePosAbove.func_177972_a(leftDir);
        BlockState leftAboveBlockstate = iblockreader.func_180495_p(leftPosAbove);
        Direction rightDir = behindDir.func_176746_e();
        BlockPos rightPos = placePos.func_177972_a(rightDir);
        BlockState rightBlockstate = iblockreader.func_180495_p(rightPos);
        BlockPos rightPosAbove = placePosAbove.func_177972_a(rightDir);
        BlockState rightAboveBlockstate = iblockreader.func_180495_p(rightPosAbove);
        int i = (leftBlockstate.func_224756_o((IBlockReader)iblockreader, leftPos) ? -1 : 0) + (leftAboveBlockstate.func_224756_o((IBlockReader)iblockreader, leftPosAbove) ? -1 : 0) + (rightBlockstate.func_224756_o((IBlockReader)iblockreader, rightPos) ? 1 : 0) + (rightAboveBlockstate.func_224756_o((IBlockReader)iblockreader, rightPosAbove) ? 1 : 0);
        boolean leftIsLowerOfSameType = leftBlockstate.func_177230_c() == this && leftBlockstate.func_177229_b(THIRD) == TripleBlockPart.LOWER;
        boolean bl = rightIsLowerOfSameType = rightBlockstate.func_177230_c() == this && rightBlockstate.func_177229_b(THIRD) == TripleBlockPart.LOWER;
        if ((!leftIsLowerOfSameType || rightIsLowerOfSameType) && i <= 0) {
            if ((!rightIsLowerOfSameType || leftIsLowerOfSameType) && i >= 0) {
                int j = behindDir.func_82601_c();
                int k = behindDir.func_82599_e();
                Vec3d vec3d = p_208073_1_.func_221532_j();
                double d0 = vec3d.field_72450_a - (double)placePos.func_177958_n();
                double d1 = vec3d.field_72449_c - (double)placePos.func_177952_p();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == Material.field_151573_f) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos, state, 10);
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return ActionResultType.SUCCESS;
    }

    public void toggleDoor(World worldIn, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((IProperty)OPEN) != open) {
            worldIn.func_180501_a(pos, (BlockState)blockstate.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            if (blockstate.func_177229_b(THIRD) == TripleBlockPart.UPPER) {
                BlockState middle = worldIn.func_180495_p(pos.func_177977_b());
                BlockState bottom = worldIn.func_180495_p(pos.func_177979_c(2));
                if (middle.func_177230_c() == this) {
                    middle = (BlockState)middle.func_177231_a((IProperty)OPEN);
                    worldIn.func_180501_a(pos.func_177977_b(), middle, 10);
                }
                if (bottom.func_177230_c() == this) {
                    bottom = (BlockState)bottom.func_177231_a((IProperty)OPEN);
                    worldIn.func_180501_a(pos.func_177979_c(2), bottom, 10);
                }
            }
            this.playSound(worldIn, pos, open);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = worldIn.func_175640_z(pos);
        if (!flag) {
            switch ((TripleBlockPart)((Object)state.func_177229_b(THIRD))) {
                case LOWER: {
                    flag = worldIn.func_175640_z(pos.func_177972_a(Direction.UP)) || worldIn.func_175640_z(pos.func_177967_a(Direction.UP, 2));
                    break;
                }
                case MIDDLE: {
                    flag = worldIn.func_175640_z(pos.func_177972_a(Direction.DOWN)) || worldIn.func_175640_z(pos.func_177972_a(Direction.UP));
                    break;
                }
                case UPPER: {
                    boolean bl = flag = worldIn.func_175640_z(pos.func_177972_a(Direction.DOWN)) || worldIn.func_175640_z(pos.func_177967_a(Direction.DOWN, 2));
                }
            }
        }
        if (blockIn != this && flag != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            if (flag != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                this.playSound(worldIn, pos, flag);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        BlockPos below2 = below.func_177977_b();
        BlockState belowState = worldIn.func_180495_p(below);
        BlockState below2State = worldIn.func_180495_p(below2);
        if (state.func_177229_b(THIRD) == TripleBlockPart.LOWER) {
            boolean result = belowState.func_224755_d((IBlockReader)worldIn, below, Direction.UP);
            field_196273_d.error("isValid? " + result + " FROM BRANCH 1");
            return result;
        }
        if (state.func_177229_b(THIRD) == TripleBlockPart.MIDDLE) {
            boolean result = belowState.func_177230_c() == this;
            field_196273_d.error("isValid? " + result + " FROM BRANCH 2");
            return result;
        }
        boolean result = belowState.func_177230_c() == this && below2State.func_177230_c() == this;
        field_196273_d.error("isValid? " + result + " FROM BRANCH 3");
        return result;
    }

    private void playSound(World p_196426_1_, BlockPos p_196426_2_, boolean p_196426_3_) {
        p_196426_1_.func_217378_a((PlayerEntity)null, p_196426_3_ ? this.getOpenSound() : this.getCloseSound(), p_196426_2_, 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(THIRD) == TripleBlockPart.LOWER ? 0 : (state.func_177229_b(THIRD) == TripleBlockPart.MIDDLE ? 1 : 2)).func_177956_o(), (int)pos.func_177952_p());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{THIRD, FACING, OPEN, HINGE, POWERED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
        }
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }
}

