/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.math;

import com.google.common.collect.Lists;
import com.hamusuke.fallingattack.FallingAttack;
import com.hamusuke.fallingattack.math.Circle;
import com.hamusuke.fallingattack.math.Vec2d;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;

public class FallingAttackShockWave {
    private final class_3222 owner;
    private final class_1799 sword;
    private final class_243 pos;
    private final class_238 box;
    private final class_3218 world;
    private final Circle primary;
    private final Circle secondary;
    private final List<class_1309> exceptEntities = Lists.newArrayList();
    private final BiFunction<Float, Integer, Float> fallingAttackDamageComputer;
    private final BiFunction<Float, Integer, Float> knockbackStrengthComputer;
    private boolean isDead;

    public FallingAttackShockWave(class_3222 owner, class_1799 swordItem, class_238 box, BiFunction<Float, Integer, Float> fallingAttackDamageComputer, BiFunction<Float, Integer, Float> knockbackStrengthComputer) {
        this.owner = owner;
        this.sword = swordItem;
        this.fallingAttackDamageComputer = fallingAttackDamageComputer;
        this.knockbackStrengthComputer = knockbackStrengthComputer;
        class_243 pos = this.owner.method_19538();
        this.pos = new class_243(pos.field_1352, pos.field_1351, pos.field_1350);
        this.box = box;
        this.world = this.owner.method_14220();
        this.primary = new Circle(this.pos.method_10216(), this.pos.method_10215(), 0.0);
        this.secondary = new Circle(this.pos.method_10216(), this.pos.method_10215(), (double)(-class_3532.field_15724) * 1.7);
    }

    static double distanceTo2D(class_243 from, class_243 to) {
        double x = to.field_1352 - from.field_1352;
        double z = to.field_1350 - from.field_1350;
        return Math.sqrt(x * x + z * z);
    }

    public void tick() {
        if (!this.isDead) {
            this.primary.spread(1.7);
            this.forEachVec2d(vec2d -> this.world.method_14199((class_2394)class_2398.field_11236.method_29140(), vec2d.x(), this.pos.field_1351, vec2d.y(), 1, 1.0, 0.0, 0.0, 1.0), 6);
            this.secondary.spread(1.7);
            this.getEntitiesStruckByShockWave().forEach(livingEntity -> {
                this.damage((class_1297)livingEntity, (float)((this.box.method_17939() - this.primary.getRadius()) / this.box.method_17939()));
                this.exceptEntities.add((class_1309)livingEntity);
            });
            if (this.primary.getRadius() >= this.box.method_17939()) {
                this.isDead = true;
            }
        }
    }

    private void damage(class_1297 target, float damageModifier) {
        if (target.method_5732() && !target.method_5698((class_1297)this.owner)) {
            float damageAmount = (float)this.owner.method_26825(class_5134.field_23721);
            float attackDamage = target instanceof class_1309 ? class_1890.method_8218((class_1799)this.sword, (class_1310)((class_1309)target).method_6046()) : class_1890.method_8218((class_1799)this.sword, (class_1310)class_1310.field_6290);
            if (damageAmount > 0.0f || attackDamage > 0.0f) {
                boolean bl3;
                float distanceToTarget = (float)this.pos.method_1022(target.method_19538());
                int fallingAttackLevel = class_1890.method_8225((class_1887)FallingAttack.SHARPNESS_OF_FALLING_ATTACK, (class_1799)this.sword) + 1;
                fallingAttackLevel = class_3532.method_15340((int)fallingAttackLevel, (int)1, (int)255);
                attackDamage += this.fallingAttackDamageComputer.apply(Float.valueOf(distanceToTarget), fallingAttackLevel).floatValue();
                this.world.method_8465(null, this.owner.method_23317(), this.owner.method_23318(), this.owner.method_23321(), class_3417.field_14999, this.owner.method_5634(), 1.0f, 1.0f);
                boolean bl = bl3 = !this.owner.method_6101() && !this.owner.method_5799() && !this.owner.method_6059(class_1294.field_5919) && !this.owner.method_5765() && target instanceof class_1309;
                if (bl3) {
                    damageAmount *= 1.5f;
                }
                damageAmount += attackDamage;
                float targetHealth = 0.0f;
                boolean fireAspectEnchanted = false;
                int fireAspectLevel = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)this.sword);
                if (target instanceof class_1309) {
                    targetHealth = ((class_1309)target).method_6032();
                    if (fireAspectLevel > 0 && !target.method_5809()) {
                        fireAspectEnchanted = true;
                        target.method_5639(1);
                    }
                }
                class_243 vec3d = target.method_18798();
                boolean tookDamage = target.method_5643(class_1282.method_5532((class_1657)this.owner), damageAmount * damageModifier);
                if (tookDamage) {
                    float yaw = (float)(-class_3532.method_15349((double)(target.method_23317() - this.pos.method_10216()), (double)(target.method_23321() - this.pos.method_10215())));
                    float strength = this.knockbackStrengthComputer.apply(Float.valueOf(distanceToTarget), fallingAttackLevel).floatValue();
                    if (target instanceof class_1309) {
                        ((class_1309)target).method_6005((double)strength, (double)class_3532.method_15374((float)yaw), (double)(-class_3532.method_15362((float)yaw)));
                    } else {
                        target.method_5762((double)(-class_3532.method_15374((float)yaw) * strength), 0.1, (double)(class_3532.method_15362((float)yaw) * strength));
                    }
                    this.owner.method_18799(this.owner.method_18798().method_18805(0.6, 1.0, 0.6));
                    this.owner.method_5728(false);
                    if (target instanceof class_3222 && target.field_6037) {
                        ((class_3222)target).field_13987.method_14364((class_2596)new class_2743(target));
                        target.field_6037 = false;
                        target.method_18799(vec3d);
                    }
                    if (bl3) {
                        this.world.method_8465(null, this.owner.method_23317(), this.owner.method_23318(), this.owner.method_23321(), class_3417.field_15016, this.owner.method_5634(), 1.0f, 1.0f);
                        this.owner.method_7277(target);
                    }
                    if (attackDamage > 0.0f) {
                        this.owner.method_7304(target);
                    }
                    this.owner.method_6114(target);
                    if (target instanceof class_1309) {
                        float n = targetHealth - ((class_1309)target).method_6032();
                        this.owner.method_7339(class_3468.field_15399, Math.round(n * 10.0f));
                        if (fireAspectLevel > 0) {
                            target.method_5639(fireAspectLevel * 4);
                        }
                        if (n > 2.0f) {
                            int o = (int)((double)n * 0.5);
                            this.world.method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), o, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.world.method_8465(null, this.owner.method_23317(), this.owner.method_23318(), this.owner.method_23321(), class_3417.field_14914, this.owner.method_5634(), 1.0f, 1.0f);
                    if (fireAspectEnchanted) {
                        target.method_5646();
                    }
                }
            }
        }
    }

    public void forEachVec2d(Consumer<Vec2d> consumer, int slices) {
        for (int i = 0; i < 360; ++i) {
            if (i % slices != 0) continue;
            consumer.accept(this.primary.getCoordinates((float)((double)i * Math.PI / 180.0), true));
        }
    }

    public List<class_1309> getEntitiesStruckByShockWave() {
        return this.world.method_8390(class_1309.class, this.box, livingEntity -> {
            double d = FallingAttackShockWave.distanceTo2D(livingEntity.method_19538(), this.pos);
            boolean flag = !this.exceptEntities.contains(livingEntity) && !livingEntity.method_7325() && livingEntity != this.owner && d >= this.secondary.getRadius() && this.primary.getRadius() >= d;
            for (int i = 0; i < 2 && flag; ++i) {
                class_243 vec3d = new class_243(livingEntity.method_23317(), livingEntity.method_23323(0.5 * (double)i), livingEntity.method_23321());
                class_3965 hitResult = this.world.method_17742(new class_3959(this.pos, vec3d, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.owner));
                if (hitResult.method_17783() != class_239.class_240.field_1333) continue;
                return true;
            }
            return false;
        });
    }

    public boolean isDead() {
        return this.isDead;
    }
}

