/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.mixin;

import com.hamusuke.fallingattack.FallingAttack;
import com.hamusuke.fallingattack.config.Config;
import com.hamusuke.fallingattack.invoker.IPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements IPlayerEntity {
    @Shadow
    @Final
    public PlayerAbilities field_71075_bZ;
    protected boolean fallingAttack;
    protected float yPosWhenStartFallingAttack;
    protected int fallingAttackProgress;
    protected int fallingAttackCooldown;
    protected float storeYaw = Float.NaN;

    @Shadow
    public abstract void func_184821_cY();

    @Shadow
    public abstract SoundCategory func_184176_by();

    @Shadow
    public abstract void func_71009_b(Entity var1);

    @Shadow
    public abstract void func_71047_c(Entity var1);

    @Shadow
    public abstract void func_195067_a(ResourceLocation var1, int var2);

    @Shadow
    public abstract void func_71020_j(float var1);

    @Shadow
    public abstract void func_226568_ek_();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> p_i48577_1_, World p_i48577_2_) {
        super(p_i48577_1_, p_i48577_2_);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void tickV(CallbackInfo ci) {
        if (!this.isUsingFallingAttack() && this.fallingAttackCooldown > 0) {
            --this.fallingAttackCooldown;
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    void aiStepV(CallbackInfo ci) {
        if (this.isUsingFallingAttack()) {
            if (!this.field_70170_p.func_201670_d() && !(this.func_184614_ca().func_77973_b() instanceof SwordItem)) {
                this.stopFallingAttack();
                this.sendFallingAttackPacket(false);
            }
            if (this.fallingAttackProgress < 10) {
                if (this.fallingAttackProgress == 0) {
                    this.func_213293_j(0.0, 0.5, 0.0);
                } else if (this.fallingAttackProgress > 5) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                if (this.fallingAttackProgress == 9) {
                    this.yPosWhenStartFallingAttack = (float)this.func_226278_cu_();
                }
                ++this.fallingAttackProgress;
            } else if (this.fallingAttackProgress == 10) {
                if (this.func_70090_H() || this.func_180799_ab() || 0 > this.func_233580_cy_().func_177956_o()) {
                    this.stopFallingAttack();
                    this.func_213317_d(Vector3d.field_186680_a);
                } else if (this.field_70122_E) {
                    ++this.fallingAttackProgress;
                    if (!this.field_70170_p.func_201670_d()) {
                        AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0);
                        Vector3d vector3d = this.func_213303_ch();
                        this.field_70170_p.func_175647_a(LivingEntity.class, new AxisAlignedBB(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e - 1.0, axisAlignedBB.field_72334_f), livingEntity -> {
                            boolean flag = !livingEntity.func_175149_v() && livingEntity != this;
                            for (int i = 0; i < 2 && flag; ++i) {
                                Vector3d vector3d1 = new Vector3d(livingEntity.func_226277_ct_(), livingEntity.func_226283_e_(0.5 * (double)i), livingEntity.func_226281_cx_());
                                BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                                if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) continue;
                                return true;
                            }
                            return false;
                        }).forEach(this::fallingAttack);
                    }
                } else {
                    this.func_213293_j(0.0, -3.0, 0.0);
                }
            } else if (this.fallingAttackProgress < 16) {
                ++this.fallingAttackProgress;
            } else if (this.isUsingFallingAttack()) {
                this.stopFallingAttack();
            }
        }
    }

    protected int func_225508_e_(float p_225508_1_, float p_225508_2_) {
        int damage = super.func_225508_e_(p_225508_1_, p_225508_2_);
        return this.isUsingFallingAttack() ? (int)((float)damage * 0.25f) : damage;
    }

    protected float computeFallingAttackDistance() {
        return MathHelper.func_76131_a((float)(this.yPosWhenStartFallingAttack - (float)this.func_226278_cu_()), (float)0.0f, (float)Float.MAX_VALUE);
    }

    protected float computeFallingAttackDamage(float distanceToTarget, int fallingAttackEnchantmentLevel) {
        float damage = (this.computeFallingAttackDistance() - distanceToTarget) * 0.1f * (float)fallingAttackEnchantmentLevel;
        return MathHelper.func_76131_a((float)damage, (float)0.0f, (float)Float.MAX_VALUE);
    }

    protected float computeKnockbackStrength(float distanceToTarget, int fallingAttackEnchantmentLevel) {
        return MathHelper.func_76131_a((float)((this.computeFallingAttackDistance() - distanceToTarget) * 0.025f * (float)fallingAttackEnchantmentLevel), (float)0.0f, (float)Float.MAX_VALUE);
    }

    public void fallingAttack(Entity target) {
        if (!ForgeHooks.onPlayerAttackTarget((PlayerEntity)((PlayerEntity)this), (Entity)target)) {
            return;
        }
        if (target.func_70075_an() && !target.func_85031_j((Entity)this)) {
            float damageAmount = (float)this.func_233637_b_(Attributes.field_233823_f_);
            float attackDamage = target instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)target).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            this.func_184821_cY();
            if (damageAmount > 0.0f || attackDamage > 0.0f) {
                float distanceToTarget = this.func_70032_d(target);
                int i = EnchantmentHelper.func_77506_a((Enchantment)FallingAttack.SHARPNESS_OF_FALLING_ATTACK, (ItemStack)this.func_184614_ca());
                int fallingAttackLevel = MathHelper.func_76125_a((int)(i + 1), (int)1, (int)(FallingAttack.SHARPNESS_OF_FALLING_ATTACK.func_77325_b() + 1));
                attackDamage += this.computeFallingAttackDamage(distanceToTarget, fallingAttackLevel);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187721_dT, this.func_184176_by(), 1.0f, 1.0f);
                boolean bl3 = !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(Effects.field_76440_q) && !this.func_184218_aH() && target instanceof LivingEntity;
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((PlayerEntity)((PlayerEntity)this), (Entity)target, (boolean)bl3, (float)(bl3 ? 1.5f : 1.0f));
                boolean bl = bl3 = hitResult != null;
                if (bl3) {
                    damageAmount *= hitResult.getDamageModifier();
                }
                damageAmount += attackDamage;
                float targetHealth = 0.0f;
                boolean fireAspectEnchanted = false;
                int fireAspectLevel = EnchantmentHelper.func_90036_a((LivingEntity)this);
                if (target instanceof LivingEntity) {
                    targetHealth = ((LivingEntity)target).func_110143_aJ();
                    if (fireAspectLevel > 0 && !target.func_70027_ad()) {
                        fireAspectEnchanted = true;
                        target.func_70015_d(1);
                    }
                }
                Vector3d vec3d = target.func_213322_ci();
                boolean tookDamage = target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this)), damageAmount * ((float)((Integer)Config.Common.DAMAGE_AMOUNT.get()).intValue() / 100.0f));
                if (tookDamage) {
                    float yaw = (float)MathHelper.func_181159_b((double)(target.func_226277_ct_() - this.func_226277_ct_()), (double)(target.func_226281_cx_() - this.func_226281_cx_())) * 57.29578f;
                    float strength = this.computeKnockbackStrength(distanceToTarget, fallingAttackLevel);
                    strength *= (float)((Integer)Config.Common.KNOCKBACK_AMOUNT.get()).intValue() / 100.0f;
                    if (target instanceof LivingEntity) {
                        ((LivingEntity)target).func_233627_a_(strength, (double)(-MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180)))), (double)(-MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180)))));
                    } else {
                        target.func_70024_g((double)(-MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * strength), 0.1, (double)(MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * strength));
                    }
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                    this.func_70031_b(false);
                    if (target instanceof ServerPlayerEntity && target.field_70133_I) {
                        ((ServerPlayerEntity)target).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(target));
                        target.field_70133_I = false;
                        target.func_213317_d(vec3d);
                    }
                    if (bl3) {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_71009_b(target);
                    }
                    if (attackDamage > 0.0f) {
                        this.func_71047_c(target);
                    }
                    this.func_130011_c(target);
                    if (target instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)target), (Entity)this);
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)this, (Entity)target);
                    ItemStack itemStack2 = this.func_184614_ca();
                    Entity entity = target;
                    if (target instanceof PartEntity) {
                        entity = ((PartEntity)target).getParent();
                    }
                    if (!this.field_70170_p.field_72995_K && !itemStack2.func_190926_b() && entity instanceof LivingEntity) {
                        ItemStack copy = itemStack2.func_77946_l();
                        itemStack2.func_77961_a((LivingEntity)entity, (PlayerEntity)this);
                        if (itemStack2.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)this), (ItemStack)copy, (Hand)Hand.MAIN_HAND);
                            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (target instanceof LivingEntity) {
                        float n = targetHealth - ((LivingEntity)target).func_110143_aJ();
                        this.func_195067_a(Stats.field_188111_y, Math.round(n * 10.0f));
                        if (fireAspectLevel > 0) {
                            target.func_70015_d(fireAspectLevel * 4);
                        }
                        if (this.field_70170_p instanceof ServerWorld && n > 2.0f) {
                            int o = (int)((double)n * 0.5);
                            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, target.func_226277_ct_(), target.func_226283_e_(0.5), target.func_226281_cx_(), o, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.func_71020_j(0.1f);
                } else {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                    if (fireAspectEnchanted) {
                        target.func_70066_B();
                    }
                }
            }
        }
    }

    @Override
    public boolean checkFallingAttack() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        return this.fallingAttackCooldown == 0 && this.field_70170_p.func_226665_a__((Entity)this, new AxisAlignedBB(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b - 2.0, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f)) && !this.func_70617_f_() && !this.func_184218_aH() && !this.field_71075_bZ.field_75100_b && !this.func_189652_ae() && !this.field_70122_E && !this.isUsingFallingAttack() && !this.func_180799_ab() && !this.func_70090_H() && !this.func_70644_a(Effects.field_188424_y) && this.func_184614_ca().func_77973_b() instanceof SwordItem;
    }

    @Override
    public void startFallingAttack() {
        this.fallingAttack = true;
        if (this.func_184613_cA()) {
            this.func_226568_ek_();
        }
    }

    @Inject(method={"startFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void startFallFlying(CallbackInfo ci) {
        if (this.fallingAttack) {
            ci.cancel();
        }
    }

    @Override
    public void stopFallingAttack() {
        this.fallingAttack = false;
        this.fallingAttackProgress = 0;
        this.fallingAttackCooldown = 30;
        this.yPosWhenStartFallingAttack = 0.0f;
        this.func_213293_j(0.0, 0.0, 0.0);
    }

    @Override
    public int getFallingAttackProgress() {
        return this.fallingAttackProgress;
    }

    @Override
    public void setFallingAttackProgress(int fallingAttackProgress) {
        this.fallingAttackProgress = fallingAttackProgress;
    }

    @Override
    public float getFallingAttackYPos() {
        return this.yPosWhenStartFallingAttack;
    }

    @Override
    public void setFallingAttackYPos(float yPos) {
        this.yPosWhenStartFallingAttack = yPos;
    }

    @Override
    public boolean isUsingFallingAttack() {
        return this.fallingAttack;
    }

    @Override
    public float getYawF() {
        return this.storeYaw;
    }

    @Override
    public void setYawF(float yaw) {
        this.storeYaw = yaw;
    }
}

