/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.mixin;

import com.hamusuke.fallingattack.mixin.PlayerEntityMixin;
import com.hamusuke.fallingattack.network.NetworkManager;
import com.hamusuke.fallingattack.network.s2c.FallingAttackS2CPacket;
import com.hamusuke.fallingattack.network.s2c.SyncFallingAttackS2CPacket;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin {
    @Shadow
    @Final
    public MinecraftServer field_71133_b;

    ServerPlayerEntityMixin(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundNBT nbt, CallbackInfo ci) {
        nbt.func_74757_a("UsingFallingAttack", this.fallingAttack);
        nbt.func_74776_a("StartFallingAttackYPos", this.yPosWhenStartFallingAttack);
        nbt.func_74768_a("FallingAttackProgress", this.fallingAttackProgress);
        nbt.func_74776_a("StartFallingAttackYaw", this.storeYaw);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundNBT nbt, CallbackInfo ci) {
        this.fallingAttack = nbt.func_74767_n("UsingFallingAttack");
        this.yPosWhenStartFallingAttack = nbt.func_74760_g("StartFallingAttackYPos");
        this.fallingAttackProgress = nbt.func_74762_e("FallingAttackProgress");
        this.storeYaw = nbt.func_74760_g("StartFallingAttackYaw");
    }

    @Override
    public void sendFallingAttackPacket(boolean start) {
        this.field_71133_b.func_184103_al().func_181057_v().forEach(serverPlayerEntity -> NetworkManager.sendToClient(new FallingAttackS2CPacket(this.func_145782_y(), start), serverPlayerEntity));
    }

    @Override
    public void sendSynchronizeFallingAttackPacket() {
        this.field_71133_b.func_184103_al().func_181057_v().forEach(serverPlayerEntity -> NetworkManager.sendToClient(new SyncFallingAttackS2CPacket(this.func_145782_y(), this.fallingAttack, this.yPosWhenStartFallingAttack, this.fallingAttackProgress, this.storeYaw), serverPlayerEntity));
    }
}

