/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.mixin.client;

import com.hamusuke.fallingattack.config.Config;
import com.hamusuke.fallingattack.mixin.PlayerEntityMixin;
import com.hamusuke.fallingattack.network.NetworkManager;
import com.hamusuke.fallingattack.network.c2s.FallingAttackC2SPacket;
import com.hamusuke.fallingattack.network.c2s.SyncFallingAttackC2SPacket;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ClientPlayerEntity.class})
public abstract class ClientPlayerEntityMixin
extends PlayerEntityMixin {
    @Shadow
    @Final
    protected Minecraft field_71159_c;
    @Nonnull
    protected PointOfView pointOfViewWhenStartFallingAttack = PointOfView.FIRST_PERSON;

    ClientPlayerEntityMixin(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void sendFallingAttackPacket(boolean start) {
        NetworkManager.sendToServer(new FallingAttackC2SPacket(start));
    }

    @Override
    public void startFallingAttack() {
        super.startFallingAttack();
        if (((Boolean)Config.Client.THIRD_PERSON.get()).booleanValue()) {
            this.pointOfViewWhenStartFallingAttack = this.field_71159_c.field_71474_y.func_243230_g();
            this.field_71159_c.field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
        }
    }

    @Override
    public void stopFallingAttack() {
        super.stopFallingAttack();
        if (((Boolean)Config.Client.THIRD_PERSON.get()).booleanValue()) {
            PointOfView pointofview = this.field_71159_c.field_71474_y.func_243230_g();
            this.field_71159_c.field_71474_y.func_243229_a(this.pointOfViewWhenStartFallingAttack);
            if (pointofview.func_243192_a() != this.field_71159_c.field_71474_y.func_243230_g().func_243192_a()) {
                this.field_71159_c.field_71460_t.func_175066_a(this.field_71159_c.field_71474_y.func_243230_g().func_243192_a() ? this.field_71159_c.func_175606_aa() : null);
            }
        }
    }

    @Override
    public void sendSynchronizeFallingAttackPacket() {
        NetworkManager.sendToServer(new SyncFallingAttackC2SPacket());
    }
}

