/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.math.wave;

import com.google.common.collect.Lists;
import com.hamusuke.fallingattack.FallingAttack;
import com.hamusuke.fallingattack.config.Config;
import com.hamusuke.fallingattack.math.wave.AbstractFallingAttackShockWave;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class ServerFallingAttackShockWave
extends AbstractFallingAttackShockWave {
    private final ServerPlayer owner;
    private final ItemStack sword;
    private final List<LivingEntity> exceptEntities = Lists.newArrayList();
    private final BiFunction<Float, Integer, Float> fallingAttackDamageComputer;
    private final BiFunction<Float, Integer, Float> knockbackStrengthComputer;

    public ServerFallingAttackShockWave(ServerPlayer owner, ItemStack swordItem, AABB box, BiFunction<Float, Integer, Float> fallingAttackDamageComputer, BiFunction<Float, Integer, Float> knockbackStrengthComputer) {
        super(owner.m_20182_(), box, owner.f_19853_);
        this.owner = owner;
        this.sword = swordItem;
        this.fallingAttackDamageComputer = fallingAttackDamageComputer;
        this.knockbackStrengthComputer = knockbackStrengthComputer;
    }

    @Override
    public void tick() {
        if (!this.isDead) {
            this.primary.spread(1.7);
            this.secondary.spread(1.7);
            this.getEntitiesStruckByShockWave().forEach(livingEntity -> {
                this.damage((Entity)livingEntity, (float)((this.box.m_82362_() - this.primary.getRadius()) / this.box.m_82362_()));
                this.exceptEntities.add((LivingEntity)livingEntity);
            });
            if (this.primary.getRadius() >= this.box.m_82362_()) {
                this.isDead = true;
            }
        }
    }

    @Override
    protected void damage(Entity target, float damageModifier) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)this.owner, (Entity)target)) {
            return;
        }
        if (target.m_6097_() && !target.m_7313_((Entity)this.owner)) {
            float damageAmount = (float)this.owner.m_21133_(Attributes.f_22281_);
            float attackDamage = target instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)this.sword, (MobType)((LivingEntity)target).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)this.sword, (MobType)MobType.f_21640_);
            if (damageAmount > 0.0f || attackDamage > 0.0f) {
                boolean bl3;
                float distanceToTarget = (float)this.pos.m_82554_(target.m_20182_());
                int fallingAttackLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)FallingAttack.ModRegistries.SHARPNESS_OF_FALLING_ATTACK.get()), (ItemStack)this.sword) + 1;
                fallingAttackLevel = Mth.m_14045_((int)fallingAttackLevel, (int)1, (int)255);
                attackDamage += this.fallingAttackDamageComputer.apply(Float.valueOf(distanceToTarget), fallingAttackLevel).floatValue();
                this.level.m_6263_(null, this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_(), SoundEvents.f_12314_, this.owner.m_5720_(), 1.0f, 1.0f);
                boolean bl = bl3 = !this.owner.m_6147_() && !this.owner.m_20069_() && !this.owner.m_21023_(MobEffects.f_19610_) && !this.owner.m_20159_() && target instanceof LivingEntity;
                if (bl3) {
                    damageAmount *= 1.5f;
                }
                damageAmount += attackDamage;
                float targetHealth = 0.0f;
                boolean fireAspectEnchanted = false;
                int fireAspectLevel = EnchantmentHelper.m_44914_((LivingEntity)this.owner);
                if (target instanceof LivingEntity) {
                    targetHealth = ((LivingEntity)target).m_21223_();
                    if (fireAspectLevel > 0 && !target.m_6060_()) {
                        fireAspectEnchanted = true;
                        target.m_20254_(1);
                    }
                }
                Vec3 vec3d = target.m_20184_();
                boolean tookDamage = target.m_6469_(DamageSource.m_19344_((Player)this.owner), damageAmount * damageModifier * ((float)((Integer)Config.Common.DAMAGE_AMOUNT.get()).intValue() / 100.0f));
                if (tookDamage) {
                    float yaw = (float)(-Mth.m_14136_((double)(target.m_20185_() - this.pos.m_7096_()), (double)(target.m_20189_() - this.pos.m_7094_())));
                    float strength = this.knockbackStrengthComputer.apply(Float.valueOf(distanceToTarget), fallingAttackLevel).floatValue();
                    strength *= (float)((Integer)Config.Common.KNOCKBACK_AMOUNT.get()).intValue() / 100.0f;
                    if (target instanceof LivingEntity) {
                        ((LivingEntity)target).m_147240_((double)strength, (double)Mth.m_14031_((float)yaw), (double)(-Mth.m_14089_((float)yaw)));
                    } else {
                        target.m_5997_((double)(-Mth.m_14031_((float)yaw) * strength), 0.1, (double)(Mth.m_14089_((float)yaw) * strength));
                    }
                    this.owner.m_20256_(this.owner.m_20184_().m_82542_(0.6, 1.0, 0.6));
                    this.owner.m_6858_(false);
                    if (target instanceof ServerPlayer && target.f_19864_) {
                        ((ServerPlayer)target).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(target));
                        target.f_19864_ = false;
                        target.m_20256_(vec3d);
                    }
                    if (bl3) {
                        this.level.m_6263_(null, this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_(), SoundEvents.f_12313_, this.owner.m_5720_(), 1.0f, 1.0f);
                        this.owner.m_5704_(target);
                    }
                    if (attackDamage > 0.0f) {
                        this.owner.m_5700_(target);
                    }
                    this.owner.m_21335_(target);
                    if (target instanceof LivingEntity) {
                        float n = targetHealth - ((LivingEntity)target).m_21223_();
                        this.owner.m_36222_(Stats.f_12928_, Math.round(n * 10.0f));
                        if (fireAspectLevel > 0) {
                            target.m_20254_(fireAspectLevel * 4);
                        }
                        if (n > 2.0f) {
                            int o = (int)((double)n * 0.5);
                            this.castToServer().m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), o, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.level.m_6263_(null, this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_(), SoundEvents.f_12315_, this.owner.m_5720_(), 1.0f, 1.0f);
                    if (fireAspectEnchanted) {
                        target.m_20095_();
                    }
                }
            }
        }
    }

    @Override
    public List<LivingEntity> getEntitiesStruckByShockWave() {
        return this.level.m_6443_(LivingEntity.class, this.box, livingEntity -> {
            double d = ServerFallingAttackShockWave.distanceTo2D(livingEntity.m_20182_(), this.pos);
            boolean flag = !this.exceptEntities.contains(livingEntity) && !livingEntity.m_5833_() && livingEntity != this.owner && d >= this.secondary.getRadius() && this.primary.getRadius() >= d;
            for (int i = 0; i < 2 && flag; ++i) {
                Vec3 vec3d = new Vec3(livingEntity.m_20185_(), livingEntity.m_20227_(0.5 * (double)i), livingEntity.m_20189_());
                BlockHitResult hitResult = this.level.m_45547_(new ClipContext(this.pos, vec3d, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.owner));
                if (hitResult.m_6662_() != HitResult.Type.MISS) continue;
                return true;
            }
            return false;
        });
    }

    public ServerLevel castToServer() {
        return (ServerLevel)this.level;
    }
}

