/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.mixin;

import com.hamusuke.fallingattack.FallingAttack;
import com.hamusuke.fallingattack.config.Config;
import com.hamusuke.fallingattack.enchantment.SharpnessOfFallingAttackEnchantment;
import com.hamusuke.fallingattack.invoker.PlayerInvoker;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerInvoker {
    @Shadow
    @Final
    private Abilities f_36077_;
    protected boolean fallingAttack;
    protected float yPosWhenStartFallingAttack;
    protected int fallingAttackProgress;
    protected int fallingAttackCooldown;
    protected float storeYaw = Float.NaN;

    @Shadow
    public abstract void m_36321_();

    @Shadow
    public abstract void m_36334_();

    @Shadow
    public abstract void m_36399_(float var1);

    @Shadow
    public abstract void m_36222_(ResourceLocation var1, int var2);

    @Shadow
    public abstract void m_5700_(Entity var1);

    @Shadow
    public abstract void m_5704_(Entity var1);

    protected PlayerMixin(EntityType<? extends LivingEntity> p_i48577_1_, Level p_i48577_2_) {
        super(p_i48577_1_, p_i48577_2_);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void tickV(CallbackInfo ci) {
        if (!this.isUsingFallingAttack() && this.fallingAttackCooldown > 0) {
            --this.fallingAttackCooldown;
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    void aiStepV(CallbackInfo ci) {
        if (this.isUsingFallingAttack()) {
            if (!this.f_19853_.m_5776_() && !(this.m_21205_().m_41720_() instanceof SwordItem)) {
                this.stopFallingAttack();
                this.sendFallingAttackPacket(false);
            }
            if (this.fallingAttackProgress < 10) {
                if (this.fallingAttackProgress == 0) {
                    this.m_20334_(0.0, 0.5, 0.0);
                } else if (this.fallingAttackProgress > 5) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.fallingAttackProgress == 9) {
                    this.yPosWhenStartFallingAttack = (float)this.m_20186_();
                }
                ++this.fallingAttackProgress;
            } else if (this.fallingAttackProgress == 10) {
                if (this.m_20069_() || this.m_20077_() || this.f_19853_.m_6042_().f_156647_() > this.m_20183_().m_123342_()) {
                    this.stopFallingAttack();
                    this.m_20256_(Vec3.f_82478_);
                } else if (this.f_19861_) {
                    ++this.fallingAttackProgress;
                    if (!this.f_19853_.m_5776_()) {
                        AABB axisAlignedBB = this.m_20191_().m_82377_(3.0, 0.0, 3.0);
                        Vec3 vector3d = this.m_20182_();
                        this.f_19853_.m_6443_(LivingEntity.class, new AABB(axisAlignedBB.f_82288_, axisAlignedBB.f_82289_, axisAlignedBB.f_82290_, axisAlignedBB.f_82291_, axisAlignedBB.f_82292_ - 1.0, axisAlignedBB.f_82293_), livingEntity -> {
                            boolean flag = !livingEntity.m_5833_() && livingEntity != this;
                            for (int i = 0; i < 2 && flag; ++i) {
                                Vec3 vector3d1 = new Vec3(livingEntity.m_20185_(), livingEntity.m_20227_(0.5 * (double)i), livingEntity.m_20189_());
                                BlockHitResult blockHitResult = this.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                                if (blockHitResult.m_6662_() != HitResult.Type.MISS) continue;
                                return true;
                            }
                            return false;
                        }).forEach(this::fallingAttack);
                        ItemStack sword = this.m_21205_();
                        PlayerMixin playerMixin = this;
                        if (playerMixin instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)playerMixin;
                            ItemStack copy = sword.m_41777_();
                            sword.m_41622_(1, (LivingEntity)serverPlayer, e -> e.m_21166_(EquipmentSlot.MAINHAND));
                            if (sword.m_41619_()) {
                                ForgeEventFactory.onPlayerDestroyItem((Player)((Player)this), (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                            }
                        }
                        this.m_36399_(0.1f);
                    }
                } else {
                    this.m_20334_(0.0, -3.0, 0.0);
                }
            } else if (this.fallingAttackProgress < 16) {
                ++this.fallingAttackProgress;
            } else if (this.isUsingFallingAttack()) {
                this.stopFallingAttack();
            }
        }
    }

    protected int m_5639_(float p_225508_1_, float p_225508_2_) {
        int damage = super.m_5639_(p_225508_1_, p_225508_2_);
        return this.isUsingFallingAttack() ? (int)((float)damage * 0.25f) : damage;
    }

    protected float computeFallingAttackDistance() {
        return Mth.m_14036_((float)(this.yPosWhenStartFallingAttack - (float)this.m_20186_()), (float)0.0f, (float)Float.MAX_VALUE);
    }

    protected float computeFallingAttackDamage(float distanceToTarget, int fallingAttackEnchantmentLevel) {
        float damage = (this.computeFallingAttackDistance() - distanceToTarget) * 0.1f * (float)fallingAttackEnchantmentLevel;
        return Mth.m_14036_((float)damage, (float)0.0f, (float)Float.MAX_VALUE);
    }

    protected float computeKnockbackStrength(float distanceToTarget, int fallingAttackEnchantmentLevel) {
        return Mth.m_14036_((float)((this.computeFallingAttackDistance() - distanceToTarget) * 0.025f * (float)fallingAttackEnchantmentLevel), (float)0.0f, (float)Float.MAX_VALUE);
    }

    public void fallingAttack(Entity target) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)((Player)this), (Entity)target)) {
            return;
        }
        if (target.m_6097_() && !target.m_7313_((Entity)this)) {
            float damageAmount = (float)this.m_21133_(Attributes.f_22281_);
            float attackDamage = target instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)target).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)MobType.f_21640_);
            this.m_36334_();
            if (damageAmount > 0.0f || attackDamage > 0.0f) {
                float distanceToTarget = this.m_20270_(target);
                int i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)FallingAttack.ModRegistries.SHARPNESS_OF_FALLING_ATTACK.get()), (ItemStack)this.m_21205_());
                int fallingAttackLevel = Mth.m_14045_((int)(i + 1), (int)1, (int)(((SharpnessOfFallingAttackEnchantment)((Object)FallingAttack.ModRegistries.SHARPNESS_OF_FALLING_ATTACK.get())).m_6586_() + 1));
                attackDamage += this.computeFallingAttackDamage(distanceToTarget, fallingAttackLevel);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12314_, this.m_5720_(), 1.0f, 1.0f);
                boolean bl3 = !this.m_6147_() && !this.m_20069_() && !this.m_21023_(MobEffects.f_19610_) && !this.m_20159_() && target instanceof LivingEntity;
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)((Player)this), (Entity)target, (boolean)bl3, (float)(bl3 ? 1.5f : 1.0f));
                boolean bl = bl3 = hitResult != null;
                if (bl3) {
                    damageAmount *= hitResult.getDamageModifier();
                }
                damageAmount += attackDamage;
                float targetHealth = 0.0f;
                boolean fireAspectEnchanted = false;
                int fireAspectLevel = EnchantmentHelper.m_44914_((LivingEntity)this);
                if (target instanceof LivingEntity) {
                    targetHealth = ((LivingEntity)target).m_21223_();
                    if (fireAspectLevel > 0 && !target.m_6060_()) {
                        fireAspectEnchanted = true;
                        target.m_20254_(1);
                    }
                }
                Vec3 vec3d = target.m_20184_();
                boolean tookDamage = target.m_6469_(DamageSource.m_19344_((Player)((Player)this)), damageAmount * ((float)((Integer)Config.Common.DAMAGE_AMOUNT.get()).intValue() / 100.0f));
                if (tookDamage) {
                    float yaw = (float)Mth.m_14136_((double)(target.m_20185_() - this.m_20185_()), (double)(target.m_20189_() - this.m_20189_())) * 57.29578f;
                    float strength = this.computeKnockbackStrength(distanceToTarget, fallingAttackLevel);
                    strength *= (float)((Integer)Config.Common.KNOCKBACK_AMOUNT.get()).intValue() / 100.0f;
                    if (target instanceof LivingEntity) {
                        ((LivingEntity)target).m_147240_((double)strength, (double)(-Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)))), (double)(-Mth.m_14089_((float)(yaw * ((float)Math.PI / 180)))));
                    } else {
                        target.m_5997_((double)(-Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * strength), 0.1, (double)(Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * strength));
                    }
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                    this.m_6858_(false);
                    if (target instanceof ServerPlayer && target.f_19864_) {
                        ((ServerPlayer)target).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(target));
                        target.f_19864_ = false;
                        target.m_20256_(vec3d);
                    }
                    if (bl3) {
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12313_, this.m_5720_(), 1.0f, 1.0f);
                        this.m_5704_(target);
                    }
                    if (attackDamage > 0.0f) {
                        this.m_5700_(target);
                    }
                    this.m_21335_(target);
                    if (target instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)target), (Entity)this);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)this, (Entity)target);
                    if (target instanceof LivingEntity) {
                        float n = targetHealth - ((LivingEntity)target).m_21223_();
                        this.m_36222_(Stats.f_12928_, Math.round(n * 10.0f));
                        if (fireAspectLevel > 0) {
                            target.m_20254_(fireAspectLevel * 4);
                        }
                        if (this.f_19853_ instanceof ServerLevel && n > 2.0f) {
                            int o = (int)((double)n * 0.5);
                            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), o, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12315_, this.m_5720_(), 1.0f, 1.0f);
                    if (fireAspectEnchanted) {
                        target.m_20095_();
                    }
                }
            }
        }
    }

    @Override
    public boolean checkFallingAttack() {
        AABB axisAlignedBB = this.m_20191_();
        return this.fallingAttackCooldown == 0 && this.f_19853_.m_45756_((Entity)this, new AABB(axisAlignedBB.f_82288_, axisAlignedBB.f_82289_ - 2.0, axisAlignedBB.f_82290_, axisAlignedBB.f_82291_, axisAlignedBB.f_82292_, axisAlignedBB.f_82293_)) && !this.m_6147_() && !this.m_20159_() && !this.f_36077_.f_35935_ && !this.m_20068_() && !this.f_19861_ && !this.isUsingFallingAttack() && !this.m_20077_() && !this.m_20069_() && !this.m_21023_(MobEffects.f_19620_) && this.m_21205_().m_41720_() instanceof SwordItem;
    }

    @Override
    public void startFallingAttack() {
        this.fallingAttack = true;
        if (this.m_21255_()) {
            this.m_36321_();
        }
    }

    @Inject(method={"startFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void startFallFlying(CallbackInfo ci) {
        if (this.fallingAttack) {
            ci.cancel();
        }
    }

    @Override
    public void stopFallingAttack() {
        this.fallingAttack = false;
        this.fallingAttackProgress = 0;
        this.fallingAttackCooldown = 30;
        this.yPosWhenStartFallingAttack = 0.0f;
    }

    @Override
    public int getFallingAttackProgress() {
        return this.fallingAttackProgress;
    }

    @Override
    public void setFallingAttackProgress(int fallingAttackProgress) {
        this.fallingAttackProgress = fallingAttackProgress;
    }

    @Override
    public float getFallingAttackYPos() {
        return this.yPosWhenStartFallingAttack;
    }

    @Override
    public void setFallingAttackYPos(float yPos) {
        this.yPosWhenStartFallingAttack = yPos;
    }

    @Override
    public boolean isUsingFallingAttack() {
        return this.fallingAttack;
    }

    @Override
    public float getYawF() {
        return this.storeYaw;
    }

    @Override
    public void setYawF(float yaw) {
        this.storeYaw = yaw;
    }
}

