/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.mixin;

import com.hamusuke.fallingattack.mixin.PlayerMixin;
import com.hamusuke.fallingattack.network.NetworkManager;
import com.hamusuke.fallingattack.network.packet.s2c.FallingAttackS2CPacket;
import com.hamusuke.fallingattack.network.packet.s2c.SyncFallingAttackS2CPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin {
    @Shadow
    @Final
    public MinecraftServer f_8924_;

    ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128379_("UsingFallingAttack", this.fallingAttack);
        nbt.m_128350_("StartFallingAttackYPos", this.yPosWhenStartFallingAttack);
        nbt.m_128405_("FallingAttackProgress", this.fallingAttackProgress);
        nbt.m_128350_("StartFallingAttackYaw", this.storeYaw);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        this.fallingAttack = nbt.m_128471_("UsingFallingAttack");
        this.yPosWhenStartFallingAttack = nbt.m_128457_("StartFallingAttackYPos");
        this.fallingAttackProgress = nbt.m_128451_("FallingAttackProgress");
        this.storeYaw = nbt.m_128457_("StartFallingAttackYaw");
    }

    @Override
    public void sendFallingAttackPacket(boolean start) {
        this.f_8924_.m_6846_().m_11314_().forEach(serverPlayerEntity -> NetworkManager.sendToClient(new FallingAttackS2CPacket(this.m_19879_(), start), serverPlayerEntity));
    }

    @Override
    public void sendSynchronizeFallingAttackPacket() {
        this.f_8924_.m_6846_().m_11314_().forEach(serverPlayerEntity -> NetworkManager.sendToClient(new SyncFallingAttackS2CPacket(this.m_19879_(), this.fallingAttack, this.yPosWhenStartFallingAttack, this.fallingAttackProgress, this.storeYaw), serverPlayerEntity));
    }
}

