/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.mixin.client;

import com.hamusuke.fallingattack.config.Config;
import com.hamusuke.fallingattack.mixin.PlayerMixin;
import com.hamusuke.fallingattack.network.NetworkManager;
import com.hamusuke.fallingattack.network.packet.c2s.FallingAttackC2SPacket;
import com.hamusuke.fallingattack.network.packet.c2s.SyncFallingAttackC2SPacket;
import javax.annotation.Nonnull;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends PlayerMixin {
    @Shadow
    @Final
    protected Minecraft f_108619_;
    @Nonnull
    protected CameraType camTypeWhenAttack = CameraType.FIRST_PERSON;

    LocalPlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void sendFallingAttackPacket(boolean start) {
        NetworkManager.sendToServer(new FallingAttackC2SPacket(start));
    }

    @Override
    public void startFallingAttack() {
        super.startFallingAttack();
        if (((Boolean)Config.Client.THIRD_PERSON.get()).booleanValue()) {
            this.camTypeWhenAttack = this.f_108619_.f_91066_.m_92176_();
            this.f_108619_.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        }
    }

    @Override
    public void stopFallingAttack() {
        super.stopFallingAttack();
        if (((Boolean)Config.Client.THIRD_PERSON.get()).booleanValue()) {
            CameraType cameraType = this.f_108619_.f_91066_.m_92176_();
            this.f_108619_.f_91066_.m_92157_(this.camTypeWhenAttack);
            if (cameraType.m_90612_() != this.f_108619_.f_91066_.m_92176_().m_90612_()) {
                this.f_108619_.f_91063_.m_109106_(this.f_108619_.f_91066_.m_92176_().m_90612_() ? this.f_108619_.m_91288_() : null);
            }
        }
    }

    @Override
    public void sendSynchronizeFallingAttackPacket() {
        NetworkManager.sendToServer(new SyncFallingAttackC2SPacket());
    }
}

