/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.network.packet;

import com.hamusuke.fallingattack.invoker.LevelInvoker;
import com.hamusuke.fallingattack.invoker.PlayerInvoker;
import com.hamusuke.fallingattack.math.wave.ClientFallingAttackShockWave;
import com.hamusuke.fallingattack.network.packet.s2c.FallingAttackS2CPacket;
import com.hamusuke.fallingattack.network.packet.s2c.FallingAttackShockWaveS2CPacket;
import com.hamusuke.fallingattack.network.packet.s2c.SyncFallingAttackS2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientPacketHandler {
    private static final Minecraft mc = Minecraft.m_91087_();

    @OnlyIn(value=Dist.CLIENT)
    public static void handle(FallingAttackS2CPacket packet) {
        Entity entity;
        if (ClientPacketHandler.isNotClientPlayerNull() && (entity = ClientPacketHandler.mc.f_91074_.f_108545_.m_6815_(packet.getPlayerEntityId())) instanceof PlayerInvoker) {
            PlayerInvoker invoker = (PlayerInvoker)entity;
            if (packet.isStart()) {
                invoker.startFallingAttack();
            } else {
                invoker.stopFallingAttack();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handle(SyncFallingAttackS2CPacket packet) {
        Entity entity;
        if (ClientPacketHandler.isNotClientPlayerNull() && packet.isUsingFallingAttack() && (entity = ClientPacketHandler.mc.f_91074_.f_108545_.m_6815_(packet.getPlayerEntityId())) instanceof PlayerInvoker) {
            PlayerInvoker invoker = (PlayerInvoker)entity;
            invoker.startFallingAttack();
            invoker.setFallingAttackYPos(packet.getFallingAttackYPos());
            invoker.setFallingAttackProgress(packet.getProgress());
            invoker.setYawF(packet.getFallingAttackYaw());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handle(FallingAttackShockWaveS2CPacket packet) {
        if (ClientPacketHandler.isNotClientPlayerNull()) {
            ((LevelInvoker)ClientPacketHandler.mc.f_91074_.f_108545_).summonShockWave(new ClientFallingAttackShockWave(packet.getPos(), packet.getAABB(), ClientPacketHandler.mc.f_91074_.f_108545_));
        }
    }

    private static boolean isNotClientPlayerNull() {
        return ClientPacketHandler.mc.f_91074_ != null;
    }
}

