/*
 * Decompiled with CFR 0.152.
 */
package com.hamusuke.fallingattack.network.packet.s2c;

import com.hamusuke.fallingattack.network.packet.ClientPacketHandler;
import com.hamusuke.fallingattack.network.packet.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class FallingAttackS2CPacket
implements Packet {
    private final int playerEntityId;
    private final boolean start;

    public FallingAttackS2CPacket(FriendlyByteBuf buffer) {
        this.playerEntityId = buffer.m_130242_();
        this.start = buffer.readBoolean();
    }

    public FallingAttackS2CPacket(int playerEntityId, boolean start) {
        this.playerEntityId = playerEntityId;
        this.start = start;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.playerEntityId);
        buffer.writeBoolean(this.start);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handle(this)));
        ctx.get().setPacketHandled(true);
    }

    public int getPlayerEntityId() {
        return this.playerEntityId;
    }

    public boolean isStart() {
        return this.start;
    }
}

