/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.base;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.apexcore.lib.util.ContainerHelper;
import xyz.apex.forge.fantasyfurniture.block.base.core.SimpleFourWayBlockEntityBlock;
import xyz.apex.forge.fantasyfurniture.block.entity.FurnitureStationBlockEntity;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;

public final class FurnitureStationBlock
extends SimpleFourWayBlockEntityBlock<FurnitureStationBlockEntity> {
    public static final VoxelShape SHAPE = VoxelShaper.or((VoxelShape[])new VoxelShape[]{FurnitureStationBlock.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0), FurnitureStationBlock.func_208617_a((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0), FurnitureStationBlock.func_208617_a((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), FurnitureStationBlock.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), FurnitureStationBlock.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FurnitureStationBlock.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)});
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal((VoxelShape)SHAPE, (Direction)Direction.NORTH);

    public FurnitureStationBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader level, BlockPos pos, ISelectionContext ctx) {
        Direction facing = (Direction)blockState.func_177229_b((Property)field_185512_D);
        return SHAPER.get(facing);
    }

    public ActionResultType func_225533_a_(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity && !this.openContainerScreen(blockState, level, pos, (ServerPlayerEntity)player, hand, stack, stack.func_200301_q())) {
            return ActionResultType.PASS;
        }
        return ActionResultType.func_233537_a_((boolean)level.field_72995_K);
    }

    public void func_180633_a(World level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(level, pos, blockState, placer, stack);
        FurnitureStationBlockEntity blockEntity = (FurnitureStationBlockEntity)((Object)this.getBlockEntity((IBlockReader)level, pos));
        if (blockEntity != null && stack.func_82837_s()) {
            ITextComponent customName = stack.func_200301_q();
            blockEntity.setCustomName(customName);
        }
    }

    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World level, BlockPos pos) {
        return ContainerHelper.getRedstoneSignalFromContainer((IBlockReader)level, (BlockPos)pos);
    }

    protected boolean openContainerScreen(BlockState blockState, World level, BlockPos pos, ServerPlayerEntity player, Hand hand, ItemStack stack, ITextComponent titleComponent) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this.func_220052_b(blockState, level, pos));
        return true;
    }

    @Override
    protected TileEntityType<FurnitureStationBlockEntity> getBlockEntityType() {
        return FurnitureStation.BLOCK_ENTITY.asBlockEntityType();
    }
}

