/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.base.core;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.apex.forge.fantasyfurniture.block.base.core.SimpleFourWayWaterLoggedBlock;

public class ShelfBlock
extends SimpleFourWayWaterLoggedBlock {
    public static final EnumProperty<ConnectionType> CONNECTION_TYPE = EnumProperty.func_177709_a((String)"connection_type", ConnectionType.class);

    public ShelfBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(CONNECTION_TYPE, (Comparable)((Object)ConnectionType.NONE)));
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingBlockState, IWorld level, BlockPos currentPos, BlockPos facingPos) {
        ConnectionType connectionState = ShelfBlock.getConnectionState(level, currentPos, blockState, this);
        return (BlockState)blockState.func_206870_a(CONNECTION_TYPE, (Comparable)((Object)connectionState));
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = super.func_196258_a(ctx);
        ConnectionType connectionState = ShelfBlock.getConnectionState((IWorld)ctx.func_195991_k(), ctx.func_195995_a(), blockState, this);
        return (BlockState)blockState.func_206870_a(CONNECTION_TYPE, (Comparable)((Object)connectionState));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONNECTION_TYPE});
        super.func_206840_a(builder);
    }

    public void func_220069_a(BlockState blockState, World level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(blockState, level, pos, block, fromPos, isMoving);
        ConnectionType connectionState = ShelfBlock.getConnectionState((IWorld)level, pos, blockState, this);
        level.func_175656_a(pos, (BlockState)blockState.func_206870_a(CONNECTION_TYPE, (Comparable)((Object)connectionState)));
    }

    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader level, BlockPos pos, PathType pathType) {
        return false;
    }

    private static ConnectionType getConnectionState(IWorld level, BlockPos pos, BlockState blockState, ShelfBlock baseShelfBlock) {
        Direction facing = (Direction)blockState.func_177229_b((Property)field_185512_D);
        BlockPos leftPos = pos.func_177972_a(facing.func_176735_f());
        BlockPos rightPos = pos.func_177972_a(facing.func_176746_e());
        boolean hasLeft = ShelfBlock.hasConnection(level, leftPos, baseShelfBlock);
        boolean hasRight = ShelfBlock.hasConnection(level, rightPos, baseShelfBlock);
        if (hasLeft && hasRight) {
            return ConnectionType.BOTH;
        }
        if (hasLeft) {
            return ConnectionType.LEFT;
        }
        if (hasRight) {
            return ConnectionType.RIGHT;
        }
        return ConnectionType.NONE;
    }

    private static boolean hasConnection(IWorld level, BlockPos pos, ShelfBlock baseShelfBlock) {
        BlockState blockState = level.func_180495_p(pos);
        return blockState.func_203425_a((Block)baseShelfBlock);
    }

    public static enum ConnectionType implements IStringSerializable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right"),
        BOTH("boh");

        private final String serializedName;

        private ConnectionType(String serializedName) {
            this.serializedName = serializedName;
        }

        public String func_176610_l() {
            return this.serializedName;
        }
    }
}

