/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.base.core;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.fantasyfurniture.block.base.core.IStackedBlock;
import xyz.apex.forge.fantasyfurniture.block.base.core.SimpleFourWayBlock;
import xyz.apex.java.utility.Lazy;

public abstract class SimpleFourWayStackedBlock
extends SimpleFourWayBlock
implements IStackedBlock {
    private final Lazy<Integer> minValue = Lazy.of(() -> IStackedBlock.getMinValue(this.getStackSizeProperty()));
    private final Lazy<Integer> maxValue = Lazy.of(() -> IStackedBlock.getMaxValue(this.getStackSizeProperty()));

    public SimpleFourWayStackedBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)this.getStackSizeProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    public abstract IntegerProperty getStackSizeProperty();

    @Override
    public boolean isForStack(ItemStack stack) {
        return stack.func_77973_b() == this.func_199767_j();
    }

    public ActionResultType func_225533_a_(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        IntegerProperty stackSizeProperty = this.getStackSizeProperty();
        int count = (Integer)blockState.func_177229_b((Property)stackSizeProperty);
        int minValue = (Integer)this.minValue.get();
        int maxValue = (Integer)this.maxValue.get();
        int newCount = this.isForStack(stack) ? count + 1 : count - 1;
        if (newCount < minValue) {
            level.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)stackSizeProperty, (Comparable)Integer.valueOf(minValue)));
            level.func_225521_a_(pos, !player.func_184812_l_(), (Entity)player);
            return ActionResultType.func_233537_a_((boolean)level.field_72995_K);
        }
        if (newCount <= maxValue) {
            if (newCount < count) {
                BlockHelper.playBreakSound((World)level, (BlockPos)pos, (Entity)player);
                if (!player.func_184812_l_()) {
                    SimpleFourWayStackedBlock.func_180635_a((World)level, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this));
                }
            } else {
                BlockHelper.playPlaceSound((World)level, (BlockPos)pos, (Entity)player);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            for (int i = 0; i < 5; ++i) {
                level.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            }
            level.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)stackSizeProperty, (Comparable)Integer.valueOf(newCount)));
            return ActionResultType.func_233537_a_((boolean)level.field_72995_K);
        }
        return ActionResultType.FAIL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.getStackSizeProperty()});
        super.func_206840_a(builder);
    }
}

