/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.base.core;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.apex.forge.fantasyfurniture.block.base.core.SeatBlock;

public class SofaBlock
extends SeatBlock {
    public static final EnumProperty<ConnectionType> CONNECTION_TYPE = EnumProperty.func_177709_a((String)"connection_type", ConnectionType.class);

    public SofaBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(CONNECTION_TYPE, (Comparable)((Object)ConnectionType.NONE)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONNECTION_TYPE});
        super.func_206840_a(builder);
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingBlockState, IWorld level, BlockPos pos, BlockPos facingPos) {
        return SofaBlock.getBlockState(level, pos, blockState, this);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = super.func_196258_a(ctx);
        return SofaBlock.getBlockState((IWorld)ctx.func_195991_k(), ctx.func_195995_a(), blockState, this);
    }

    public void func_180658_a(World level, BlockPos pos, Entity entity, float distance) {
        super.func_180658_a(level, pos, entity, distance * 0.5f);
    }

    public void func_176216_a(IBlockReader level, Entity entity) {
        if (entity.func_226272_bl_()) {
            super.func_176216_a(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    protected void bounceUp(Entity entity) {
        Vector3d deltaMovement = entity.func_213322_ci();
        if (deltaMovement.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(deltaMovement.field_72450_a, -deltaMovement.field_72448_b * (double)0.66f * d0, deltaMovement.field_72449_c);
        }
    }

    public void func_220069_a(BlockState blockState, World level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(blockState, level, pos, block, fromPos, isMoving);
        SofaBlock.updateConnectionBlockState((IWorld)level, pos, blockState, this);
    }

    public static void updateConnectionBlockState(IWorld level, BlockPos pos, BlockState blockState, SofaBlock baseSofaBlock) {
        BlockState newBlockState = SofaBlock.getBlockState(level, pos, blockState, baseSofaBlock);
        if (newBlockState != blockState) {
            level.func_180501_a(pos, newBlockState, 3);
        }
    }

    public static BlockState getBlockState(IWorld level, BlockPos pos, BlockState blockState, SofaBlock baseSofaBlock) {
        ConnectionType connectionType = SofaBlock.getConnectionState(level, pos, blockState, baseSofaBlock);
        return (BlockState)blockState.func_206870_a(CONNECTION_TYPE, (Comparable)((Object)connectionType));
    }

    public static ConnectionType getConnectionState(IWorld level, BlockPos pos, BlockState blockState, SofaBlock baseSofaBlock) {
        BlockState inFrontBlockState;
        BlockState rightBlockState;
        Direction originFacing = (Direction)blockState.func_177229_b((Property)field_185512_D);
        ConnectionType originConnectionType = (ConnectionType)((Object)blockState.func_177229_b(CONNECTION_TYPE));
        BlockPos leftPos = pos.func_177972_a(originFacing.func_176735_f());
        BlockPos rightPos = pos.func_177972_a(originFacing.func_176746_e());
        BlockPos inFrontPos = pos.func_177972_a(originFacing);
        BlockState leftBlockState = level.func_180495_p(leftPos);
        if (SofaBlock.isCornerConnection(leftBlockState, rightBlockState = level.func_180495_p(rightPos), inFrontBlockState = level.func_180495_p(inFrontPos), originFacing, baseSofaBlock)) {
            return ConnectionType.CORNER;
        }
        boolean hasLeft = SofaBlock.isLeftConnection(leftBlockState, originFacing, originConnectionType, baseSofaBlock);
        boolean hasRight = SofaBlock.isRightConnection(rightBlockState, originFacing, originConnectionType, baseSofaBlock);
        if (hasLeft && !hasRight) {
            return ConnectionType.LEFT;
        }
        if (hasRight && !hasLeft) {
            return ConnectionType.RIGHT;
        }
        if (hasLeft && hasRight) {
            return ConnectionType.CENTER;
        }
        return ConnectionType.NONE;
    }

    public static boolean isCornerConnection(BlockState leftBlockState, BlockState rightBlockState, BlockState inFrontBlockState, Direction originFacing, SofaBlock baseSofaBlock) {
        if (!inFrontBlockState.func_203425_a((Block)baseSofaBlock)) {
            return false;
        }
        Direction inFrontFacing = (Direction)inFrontBlockState.func_177229_b((Property)field_185512_D);
        if (leftBlockState.func_203425_a((Block)baseSofaBlock)) {
            Direction leftFacing = (Direction)leftBlockState.func_177229_b((Property)field_185512_D);
            return SofaBlock.isCornerFacing(originFacing, leftFacing, inFrontFacing);
        }
        if (rightBlockState.func_203425_a((Block)baseSofaBlock)) {
            Direction rightFacing = (Direction)rightBlockState.func_177229_b((Property)field_185512_D);
            return SofaBlock.isCornerFacing(originFacing, rightFacing, inFrontFacing);
        }
        return false;
    }

    public static boolean isCornerFacing(Direction originFacing, Direction sidedFacing, Direction inFrontFacing) {
        if (originFacing == sidedFacing) {
            return sidedFacing.func_176735_f() == inFrontFacing || sidedFacing == inFrontFacing.func_176746_e();
        }
        return sidedFacing.func_176734_d() == inFrontFacing || sidedFacing == inFrontFacing.func_176734_d();
    }

    public static boolean isLeftConnection(BlockState leftBlockState, Direction originFacing, ConnectionType originConnectionType, SofaBlock baseSofaBlock) {
        if (!leftBlockState.func_203425_a((Block)baseSofaBlock)) {
            return false;
        }
        if (leftBlockState.func_177229_b((Property)field_185512_D) == originFacing) {
            return true;
        }
        ConnectionType leftConnectionType = (ConnectionType)((Object)leftBlockState.func_177229_b(CONNECTION_TYPE));
        return leftConnectionType == ConnectionType.CORNER || leftConnectionType == ConnectionType.CENTER;
    }

    public static boolean isRightConnection(BlockState rightBlockState, Direction originFacing, ConnectionType originConnectionType, SofaBlock baseSofaBlock) {
        if (!rightBlockState.func_203425_a((Block)baseSofaBlock)) {
            return false;
        }
        if (rightBlockState.func_177229_b((Property)field_185512_D) == originFacing) {
            return true;
        }
        ConnectionType rightConnectionType = (ConnectionType)((Object)rightBlockState.func_177229_b(CONNECTION_TYPE));
        return rightConnectionType == ConnectionType.CORNER || rightConnectionType == ConnectionType.CENTER;
    }

    public static enum ConnectionType implements IStringSerializable
    {
        LEFT("left"),
        RIGHT("right"),
        CENTER("center"),
        CORNER("corner"),
        NONE("single");

        private final String serializedName;

        private ConnectionType(String serializedName) {
            this.serializedName = serializedName;
        }

        public String func_176610_l() {
            return this.serializedName;
        }
    }
}

