/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.block.base.set;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockPattern;
import xyz.apex.forge.fantasyfurniture.block.base.core.WaterLoggedMultiBlock;

public class SetFloorLightBlock
extends WaterLoggedMultiBlock {
    public static final EnumProperty<Side> SIDE = EnumProperty.func_177709_a((String)"side", Side.class);

    public SetFloorLightBlock(AbstractBlock.Properties properties, MultiBlockPattern pattern) {
        super(properties, pattern);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SIDE, (Comparable)((Object)Side.BOTTOM)));
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return this.pattern.isOrigin(blockState) ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SIDE});
        super.func_206840_a(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState blockState, World level, BlockPos pos, Random rng) {
        if (!((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue() && blockState.func_177229_b(SIDE) == Side.TOP) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.5 + 0.34;
            double z = (double)pos.func_177952_p() + 0.5;
            this.onLightParticle(level, pos, blockState, x + 0.27, y, z, rng);
            this.onLightParticle(level, pos, blockState, x - 0.27, y, z, rng);
            this.onLightParticle(level, pos, blockState, x, y, z + 0.27, rng);
            this.onLightParticle(level, pos, blockState, x, y, z - 0.27, rng);
        }
    }

    protected void onLightParticle(World level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, Random rng) {
        level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, pX, pY, pZ, 0.0, 0.0, 0.0);
        level.func_195594_a((IParticleData)ParticleTypes.field_197631_x, pX, pY, pZ, 0.0, 0.0, 0.0);
    }

    public static enum Side implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String serializedName;

        private Side(String serializedName) {
            this.serializedName = serializedName;
        }

        public String func_176610_l() {
            return this.serializedName;
        }
    }
}

