/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.init;

import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.CopyBlockState;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategory;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategoryManager;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockBuilder;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockFactory;
import xyz.apex.forge.apexcore.lib.util.EventBusHelper;
import xyz.apex.forge.fantasyfurniture.block.base.core.BedBlock;
import xyz.apex.forge.fantasyfurniture.block.base.core.ISeatBlock;
import xyz.apex.forge.fantasyfurniture.block.base.core.ShelfBlock;
import xyz.apex.forge.fantasyfurniture.block.base.core.SofaBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetBedDoubleBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetBedSingleBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetBenchBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetBookshelfBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetCarpetBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetChairBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetChandelierBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetChestBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetCushionBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetDeskBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetDrawerBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetDresserBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetFloorLightBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetPaintingSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetPaintingWideBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetShelfBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetSofaBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetStoolBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetTableLargeBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetTableSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetTableWideBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetWallLightBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetWardrobeBlock;
import xyz.apex.forge.fantasyfurniture.block.base.set.SetWardrobeTopperBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerBedDoubleBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerBedSingleBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerBenchBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerBookshelfBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerCarpetBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerChairBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerChandelierBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerChestBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerCushionBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerDeskBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerDrawerBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerDresserBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerFloorLightBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerPaintingSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerPaintingWideBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerShelfBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerSofaBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerStoolBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerTableLargeBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerTableSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerTableWideBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerWallLightBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerWardrobeBlock;
import xyz.apex.forge.fantasyfurniture.block.dunmer.DunmerWardrobeTopperBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicBedDoubleBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicBedSingleBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicBenchBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicBookshelfBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicCarpetBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicChairBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicChandelierBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicChestBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicCushionBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicDeskBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicDrawerBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicDresserBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicFloorLightBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicPaintingSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicPaintingWideBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicShelfBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicSofaBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicStoolBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicTableLargeBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicTableSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicTableWideBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicWallLightBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicWardrobeBlock;
import xyz.apex.forge.fantasyfurniture.block.nordic.NordicWardrobeTopperBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrBedDoubleBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrBedSingleBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrBenchBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrBookshelfBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrCarpetBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrChairBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrChandelierBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrChestBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrCushionBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrDeskBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrDrawerBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrDresserBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrFloorLightBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrPaintingSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrPaintingWideBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrShelfBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrSofaBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrStoolBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrTableLargeBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrTableSmallBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrTableWideBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrWallLightBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrWardrobeBlock;
import xyz.apex.forge.fantasyfurniture.block.venthyr.VenthyrWardrobeTopperBlock;
import xyz.apex.forge.fantasyfurniture.init.FFPatterns;
import xyz.apex.forge.fantasyfurniture.init.FFRegistry;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;
import xyz.apex.forge.fantasyfurniture.init.Registrations;
import xyz.apex.forge.fantasyfurniture.item.VenthyrTableBlockItem;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.BlockBuilder;
import xyz.apex.forge.utility.registrator.builder.ItemBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.entry.ItemEntry;
import xyz.apex.forge.utility.registrator.factory.BlockFactory;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateLangProvider;

public enum FurnitureSet {
    NORDIC("nordic", (BlockFactory<SetCarpetBlock>)((BlockFactory)NordicCarpetBlock::new), (BlockFactory<SetWallLightBlock>)((BlockFactory)NordicWallLightBlock::new), (MultiBlockFactory<SetFloorLightBlock>)((MultiBlockFactory)NordicFloorLightBlock::new), (BlockFactory<SetTableSmallBlock>)((BlockFactory)NordicTableSmallBlock::new), (MultiBlockFactory<SetTableWideBlock>)((MultiBlockFactory)NordicTableWideBlock::new), (MultiBlockFactory<SetTableLargeBlock>)((MultiBlockFactory)NordicTableLargeBlock::new), (BlockFactory<SetStoolBlock>)((BlockFactory)NordicStoolBlock::new), (BlockFactory<SetCushionBlock>)((BlockFactory)NordicCushionBlock::new), (BlockFactory<SetPaintingSmallBlock>)((BlockFactory)NordicPaintingSmallBlock::new), (MultiBlockFactory<SetPaintingWideBlock>)((MultiBlockFactory)NordicPaintingWideBlock::new), (BlockFactory<SetDrawerBlock>)((BlockFactory)NordicDrawerBlock::new), (BlockFactory<SetShelfBlock>)((BlockFactory)NordicShelfBlock::new), (BlockFactory<SetSofaBlock>)((BlockFactory)NordicSofaBlock::new), (MultiBlockFactory<SetDeskBlock>)((MultiBlockFactory)NordicDeskBlock::new), (MultiBlockFactory<SetChairBlock>)((MultiBlockFactory)NordicChairBlock::new), (MultiBlockFactory<SetBenchBlock>)((MultiBlockFactory)NordicBenchBlock::new), (MultiBlockFactory<SetBookshelfBlock>)((MultiBlockFactory)NordicBookshelfBlock::new), (MultiBlockFactory<SetChestBlock>)((MultiBlockFactory)NordicChestBlock::new), (MultiBlockFactory<SetDresserBlock>)((MultiBlockFactory)NordicDresserBlock::new), (MultiBlockFactory<SetWardrobeBlock>)((MultiBlockFactory)NordicWardrobeBlock::new), (MultiBlockFactory<SetWardrobeTopperBlock>)((MultiBlockFactory)NordicWardrobeTopperBlock::new), (MultiBlockFactory<SetBedSingleBlock>)((MultiBlockFactory)NordicBedSingleBlock::new), (MultiBlockFactory<SetBedDoubleBlock>)((MultiBlockFactory)NordicBedDoubleBlock::new), (BlockFactory<SetChandelierBlock>)((BlockFactory)NordicChandelierBlock::new), (BlockFactory<DoorBlock>)((BlockFactory)DoorBlock::new)),
    VENTHYR("venthyr", (BlockFactory<SetCarpetBlock>)((BlockFactory)VenthyrCarpetBlock::new), (BlockFactory<SetWallLightBlock>)((BlockFactory)VenthyrWallLightBlock::new), (MultiBlockFactory<SetFloorLightBlock>)((MultiBlockFactory)VenthyrFloorLightBlock::new), (BlockFactory<SetTableSmallBlock>)((BlockFactory)VenthyrTableSmallBlock::new), (MultiBlockFactory<SetTableWideBlock>)((MultiBlockFactory)VenthyrTableWideBlock::new), (MultiBlockFactory<SetTableLargeBlock>)((MultiBlockFactory)VenthyrTableLargeBlock::new), (BlockFactory<SetStoolBlock>)((BlockFactory)VenthyrStoolBlock::new), (BlockFactory<SetCushionBlock>)((BlockFactory)VenthyrCushionBlock::new), (BlockFactory<SetPaintingSmallBlock>)((BlockFactory)VenthyrPaintingSmallBlock::new), (MultiBlockFactory<SetPaintingWideBlock>)((MultiBlockFactory)VenthyrPaintingWideBlock::new), (BlockFactory<SetDrawerBlock>)((BlockFactory)VenthyrDrawerBlock::new), (BlockFactory<SetShelfBlock>)((BlockFactory)VenthyrShelfBlock::new), (BlockFactory<SetSofaBlock>)((BlockFactory)VenthyrSofaBlock::new), (MultiBlockFactory<SetDeskBlock>)((MultiBlockFactory)VenthyrDeskBlock::new), (MultiBlockFactory<SetChairBlock>)((MultiBlockFactory)VenthyrChairBlock::new), (MultiBlockFactory<SetBenchBlock>)((MultiBlockFactory)VenthyrBenchBlock::new), (MultiBlockFactory<SetBookshelfBlock>)((MultiBlockFactory)VenthyrBookshelfBlock::new), (MultiBlockFactory<SetChestBlock>)((MultiBlockFactory)VenthyrChestBlock::new), (MultiBlockFactory<SetDresserBlock>)((MultiBlockFactory)VenthyrDresserBlock::new), (MultiBlockFactory<SetWardrobeBlock>)((MultiBlockFactory)VenthyrWardrobeBlock::new), (MultiBlockFactory<SetWardrobeTopperBlock>)((MultiBlockFactory)VenthyrWardrobeTopperBlock::new), (MultiBlockFactory<SetBedSingleBlock>)((MultiBlockFactory)VenthyrBedSingleBlock::new), (MultiBlockFactory<SetBedDoubleBlock>)((MultiBlockFactory)VenthyrBedDoubleBlock::new), (BlockFactory<SetChandelierBlock>)((BlockFactory)VenthyrChandelierBlock::new), (BlockFactory<DoorBlock>)((BlockFactory)DoorBlock::new)),
    DUNMER("dunmer", (BlockFactory<SetCarpetBlock>)((BlockFactory)DunmerCarpetBlock::new), (BlockFactory<SetWallLightBlock>)((BlockFactory)DunmerWallLightBlock::new), (MultiBlockFactory<SetFloorLightBlock>)((MultiBlockFactory)DunmerFloorLightBlock::new), (BlockFactory<SetTableSmallBlock>)((BlockFactory)DunmerTableSmallBlock::new), (MultiBlockFactory<SetTableWideBlock>)((MultiBlockFactory)DunmerTableWideBlock::new), (MultiBlockFactory<SetTableLargeBlock>)((MultiBlockFactory)DunmerTableLargeBlock::new), (BlockFactory<SetStoolBlock>)((BlockFactory)DunmerStoolBlock::new), (BlockFactory<SetCushionBlock>)((BlockFactory)DunmerCushionBlock::new), (BlockFactory<SetPaintingSmallBlock>)((BlockFactory)DunmerPaintingSmallBlock::new), (MultiBlockFactory<SetPaintingWideBlock>)((MultiBlockFactory)DunmerPaintingWideBlock::new), (BlockFactory<SetDrawerBlock>)((BlockFactory)DunmerDrawerBlock::new), (BlockFactory<SetShelfBlock>)((BlockFactory)DunmerShelfBlock::new), (BlockFactory<SetSofaBlock>)((BlockFactory)DunmerSofaBlock::new), (MultiBlockFactory<SetDeskBlock>)((MultiBlockFactory)DunmerDeskBlock::new), (MultiBlockFactory<SetChairBlock>)((MultiBlockFactory)DunmerChairBlock::new), (MultiBlockFactory<SetBenchBlock>)((MultiBlockFactory)DunmerBenchBlock::new), (MultiBlockFactory<SetBookshelfBlock>)((MultiBlockFactory)DunmerBookshelfBlock::new), (MultiBlockFactory<SetChestBlock>)((MultiBlockFactory)DunmerChestBlock::new), (MultiBlockFactory<SetDresserBlock>)((MultiBlockFactory)DunmerDresserBlock::new), (MultiBlockFactory<SetWardrobeBlock>)((MultiBlockFactory)DunmerWardrobeBlock::new), (MultiBlockFactory<SetWardrobeTopperBlock>)((MultiBlockFactory)DunmerWardrobeTopperBlock::new), (MultiBlockFactory<SetBedSingleBlock>)((MultiBlockFactory)DunmerBedSingleBlock::new), (MultiBlockFactory<SetBedDoubleBlock>)((MultiBlockFactory)DunmerBedDoubleBlock::new), (BlockFactory<SetChandelierBlock>)((BlockFactory)DunmerChandelierBlock::new), (BlockFactory<DoorBlock>)((BlockFactory)DoorBlock::new));

    public static final ResourceLocation VENTHYR_FANCY_TABLE_ITEM_PROPERTY;
    public final String serializedName;
    public final String englishName;
    public final ITag.INamedTag<Item> itemGroupCategoryTag;
    public final ItemGroupCategory itemGroupCategory;
    public final BlockEntry<?>[] blocks;
    public final ItemEntry<?>[] items;
    public final BlockEntry<Block> woolBlock;
    public final ItemEntry<BlockItem> woolBlockItem;
    public final BlockEntry<? extends SetCarpetBlock> carpetBlock;
    public final ItemEntry<BlockItem> carpetBlockItem;
    public final BlockEntry<? extends SetWallLightBlock> wallLightBlock;
    public final ItemEntry<BlockItem> wallLightBlockItem;
    public final BlockEntry<? extends SetFloorLightBlock> floorLightBlock;
    public final ItemEntry<BlockItem> floorLightBlockItem;
    public final BlockEntry<? extends SetTableSmallBlock> tableSmallBlock;
    public final ItemEntry<BlockItem> tableSmallBlockItem;
    public final BlockEntry<? extends SetTableWideBlock> tableWideBlock;
    public final ItemEntry<BlockItem> tableWideBlockItem;
    public final BlockEntry<? extends SetTableLargeBlock> tableLargeBlock;
    public final ItemEntry<BlockItem> tableLargeBlockItem;
    public final BlockEntry<? extends SetStoolBlock> stoolBlock;
    public final ItemEntry<BlockItem> stoolBlockItem;
    public final BlockEntry<? extends SetCushionBlock> cushionBlock;
    public final ItemEntry<BlockItem> cushionBlockItem;
    public final BlockEntry<? extends SetPaintingSmallBlock> paintingSmallBlock;
    public final ItemEntry<BlockItem> paintingSmallBlockItem;
    public final BlockEntry<? extends SetPaintingWideBlock> paintingWideBlock;
    public final ItemEntry<BlockItem> paintingWideBlockItem;
    public final BlockEntry<? extends SetDrawerBlock> drawerBlock;
    public final ItemEntry<BlockItem> drawerBlockItem;
    public final BlockEntry<? extends SetShelfBlock> shelfBlock;
    public final ItemEntry<BlockItem> shelfBlockItem;
    public final BlockEntry<? extends SetSofaBlock> sofaBlock;
    public final ItemEntry<BlockItem> sofaBlockItem;
    public final BlockEntry<? extends SetDeskBlock> deskLeftBlock;
    public final ItemEntry<BlockItem> deskLeftBlockItem;
    public final BlockEntry<? extends SetDeskBlock> deskRightBlock;
    public final ItemEntry<BlockItem> deskRightBlockItem;
    public final BlockEntry<? extends SetChairBlock> chairBlock;
    public final ItemEntry<BlockItem> chairBlockItem;
    public final BlockEntry<? extends SetBenchBlock> benchBlock;
    public final ItemEntry<BlockItem> benchBlockItem;
    public final BlockEntry<? extends SetBookshelfBlock> bookshelfBlock;
    public final ItemEntry<BlockItem> bookshelfBlockItem;
    public final BlockEntry<? extends SetChestBlock> chestBlock;
    public final ItemEntry<BlockItem> chestBlockItem;
    public final BlockEntry<? extends SetDresserBlock> dresserBlock;
    public final ItemEntry<BlockItem> dresserBlockItem;
    public final BlockEntry<? extends SetWardrobeBlock> wardrobeBlock;
    public final ItemEntry<BlockItem> wardrobeBlockItem;
    public final BlockEntry<? extends SetWardrobeTopperBlock> wardrobeTopperBlock;
    public final ItemEntry<BlockItem> wardrobeTopperBlockItem;
    public final BlockEntry<? extends SetBedSingleBlock> bedSingleBlock;
    public final ItemEntry<BlockItem> bedSingleBlockItem;
    public final BlockEntry<? extends SetBedDoubleBlock> bedDoubleBlock;
    public final ItemEntry<BlockItem> bedDoubleBlockItem;
    public final BlockEntry<? extends SetChandelierBlock> chandelierBlock;
    public final ItemEntry<BlockItem> chandelierBlockItem;
    public final BlockEntry<? extends DoorBlock> doorSingleBlock;
    public final ItemEntry<BlockItem> doorSingleBlockItem;
    public final BlockEntry<? extends DoorBlock> doorDoubleBlock;
    public final ItemEntry<BlockItem> doorDoubleBlockItem;

    private FurnitureSet(String serializedName, BlockFactory<SetCarpetBlock> carpetBlockFactory, BlockFactory<SetWallLightBlock> wallLightBlockFactory, MultiBlockFactory<SetFloorLightBlock> floorLightBlockFactory, BlockFactory<SetTableSmallBlock> tableSmallBlockFactory, MultiBlockFactory<SetTableWideBlock> tableWideBlockFactory, MultiBlockFactory<SetTableLargeBlock> tableLargeBlockFactory, BlockFactory<SetStoolBlock> stoolBlockFactory, BlockFactory<SetCushionBlock> cushionBlockFactory, BlockFactory<SetPaintingSmallBlock> paintingSmallBlockFactory, MultiBlockFactory<SetPaintingWideBlock> paintingWideBlockFactory, BlockFactory<SetDrawerBlock> drawerBlockFactory, BlockFactory<SetShelfBlock> shelfBlockFactory, BlockFactory<SetSofaBlock> sofaBlockFactory, MultiBlockFactory<SetDeskBlock> deskBlockFactory, MultiBlockFactory<SetChairBlock> chairBlockFactory, MultiBlockFactory<SetBenchBlock> benchBlockFactory, MultiBlockFactory<SetBookshelfBlock> bookshelfBlockFactory, MultiBlockFactory<SetChestBlock> chestBlockFactory, MultiBlockFactory<SetDresserBlock> dresserBlockFactory, MultiBlockFactory<SetWardrobeBlock> wardrobeBlockFactory, MultiBlockFactory<SetWardrobeTopperBlock> wardrobeTopperBlockFactory, MultiBlockFactory<SetBedSingleBlock> bedSingleBlockFactory, MultiBlockFactory<SetBedDoubleBlock> bedDoubleBlockFactory, BlockFactory<SetChandelierBlock> chandelierBlockFactory, BlockFactory<DoorBlock> doorBlockFactory) {
        this.serializedName = serializedName;
        boolean isVenthyr = serializedName.equals("venthyr");
        this.englishName = RegistrateLangProvider.toEnglishName((String)serializedName);
        this.itemGroupCategoryTag = FFRegistry.getInstance().moddedItemTag("item_category/" + serializedName);
        this.woolBlock = FurnitureSet.wool(serializedName, this.englishName, this.itemGroupCategoryTag);
        this.woolBlockItem = Registrations.blockItem(this.woolBlock);
        this.carpetBlock = FurnitureSet.carpet(carpetBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.carpetBlockItem = Registrations.blockItem(this.carpetBlock);
        this.wallLightBlock = FurnitureSet.wallLight(wallLightBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.wallLightBlockItem = Registrations.blockItem(this.wallLightBlock);
        this.floorLightBlock = FurnitureSet.floorLight(floorLightBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.floorLightBlockItem = Registrations.blockItem(this.floorLightBlock);
        this.tableSmallBlock = isVenthyr ? FurnitureSet.venthyrTableSmall(tableSmallBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag) : FurnitureSet.tableSmall(tableSmallBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.tableSmallBlockItem = Registrations.blockItem(this.tableSmallBlock);
        this.tableWideBlock = isVenthyr ? FurnitureSet.venthyrTableWide(tableWideBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag) : FurnitureSet.tableWide(tableWideBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.tableWideBlockItem = Registrations.blockItem(this.tableWideBlock);
        this.tableLargeBlock = isVenthyr ? FurnitureSet.venthyrTableLarge(tableLargeBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag) : FurnitureSet.tableLarge(tableLargeBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.tableLargeBlockItem = Registrations.blockItem(this.tableLargeBlock);
        this.stoolBlock = FurnitureSet.stool(stoolBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.stoolBlockItem = Registrations.blockItem(this.stoolBlock);
        this.cushionBlock = FurnitureSet.cushion(cushionBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.cushionBlockItem = Registrations.blockItem(this.cushionBlock);
        this.paintingSmallBlock = FurnitureSet.paintingSmall(paintingSmallBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.paintingSmallBlockItem = Registrations.blockItem(this.paintingSmallBlock);
        this.paintingWideBlock = FurnitureSet.paintingWide(paintingWideBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.paintingWideBlockItem = Registrations.blockItem(this.paintingWideBlock);
        this.drawerBlock = FurnitureSet.drawer(drawerBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.drawerBlockItem = Registrations.blockItem(this.drawerBlock);
        this.shelfBlock = FurnitureSet.shelf(shelfBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.shelfBlockItem = Registrations.blockItem(this.shelfBlock);
        this.sofaBlock = FurnitureSet.sofa(sofaBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.sofaBlockItem = Registrations.blockItem(this.sofaBlock);
        this.deskLeftBlock = FurnitureSet.desk(deskBlockFactory, serializedName, this.englishName, "left", this.itemGroupCategoryTag);
        this.deskLeftBlockItem = Registrations.blockItem(this.deskLeftBlock);
        this.deskRightBlock = FurnitureSet.desk(deskBlockFactory, serializedName, this.englishName, "right", this.itemGroupCategoryTag);
        this.deskRightBlockItem = Registrations.blockItem(this.deskRightBlock);
        this.chairBlock = FurnitureSet.chair(chairBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.chairBlockItem = Registrations.blockItem(this.chairBlock);
        this.benchBlock = FurnitureSet.bench(benchBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.benchBlockItem = Registrations.blockItem(this.benchBlock);
        this.bookshelfBlock = FurnitureSet.bookshelf(bookshelfBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.bookshelfBlockItem = Registrations.blockItem(this.bookshelfBlock);
        this.chestBlock = FurnitureSet.chest(chestBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.chestBlockItem = Registrations.blockItem(this.chestBlock);
        this.dresserBlock = FurnitureSet.dresser(dresserBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.dresserBlockItem = Registrations.blockItem(this.dresserBlock);
        this.wardrobeBlock = FurnitureSet.wardrobeBottom(wardrobeBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.wardrobeBlockItem = Registrations.blockItem(this.wardrobeBlock);
        this.wardrobeTopperBlock = FurnitureSet.wardrobeTop(wardrobeTopperBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.wardrobeTopperBlockItem = Registrations.blockItem(this.wardrobeTopperBlock);
        this.bedSingleBlock = FurnitureSet.bedSingle(bedSingleBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.bedSingleBlockItem = Registrations.blockItem(this.bedSingleBlock);
        this.bedDoubleBlock = FurnitureSet.bedDouble(bedDoubleBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.bedDoubleBlockItem = Registrations.blockItem(this.bedDoubleBlock);
        this.chandelierBlock = FurnitureSet.chandelier(chandelierBlockFactory, serializedName, this.englishName, this.itemGroupCategoryTag);
        this.chandelierBlockItem = Registrations.blockItem(this.chairBlock);
        this.doorSingleBlock = FurnitureSet.door(doorBlockFactory, serializedName, this.englishName, "single", this.itemGroupCategoryTag);
        this.doorSingleBlockItem = Registrations.blockItem(this.chairBlock);
        this.doorDoubleBlock = FurnitureSet.door(doorBlockFactory, serializedName, this.englishName, "double", this.itemGroupCategoryTag);
        this.doorDoubleBlockItem = Registrations.blockItem(this.chairBlock);
        this.blocks = new BlockEntry[]{this.woolBlock, this.carpetBlock, this.wallLightBlock, this.floorLightBlock, this.tableSmallBlock, this.tableWideBlock, this.tableLargeBlock, this.stoolBlock, this.cushionBlock, this.paintingSmallBlock, this.paintingWideBlock, this.drawerBlock, this.shelfBlock, this.sofaBlock, this.deskLeftBlock, this.deskRightBlock, this.chairBlock, this.benchBlock, this.bookshelfBlock, this.chestBlock, this.dresserBlock, this.wardrobeBlock, this.wardrobeTopperBlock, this.bedSingleBlock, this.bedDoubleBlock, this.chandelierBlock, this.doorSingleBlock, this.doorDoubleBlock};
        this.items = new ItemEntry[]{this.woolBlockItem, this.carpetBlockItem, this.wallLightBlockItem, this.floorLightBlockItem, this.tableSmallBlockItem, this.tableWideBlockItem, this.tableLargeBlockItem, this.stoolBlockItem, this.cushionBlockItem, this.paintingSmallBlockItem, this.paintingWideBlockItem, this.drawerBlockItem, this.shelfBlockItem, this.sofaBlockItem, this.deskLeftBlockItem, this.deskRightBlockItem, this.chairBlockItem, this.benchBlockItem, this.bookshelfBlockItem, this.chestBlockItem, this.dresserBlockItem, this.wardrobeBlockItem, this.wardrobeTopperBlockItem, this.bedSingleBlockItem, this.bedDoubleBlockItem, this.chandelierBlockItem, this.doorSingleBlockItem, this.doorDoubleBlockItem};
        this.itemGroupCategory = ItemGroupCategory.builder((String)this.itemGroupCategoryTag.func_230234_a_().toString()).tagged(this.itemGroupCategoryTag).defaultIcon(() -> this.bedSingleBlock.asItemStack()).build();
    }

    static void bootstrap() {
        FFRegistry registry = FFRegistry.getInstance();
        for (FurnitureSet furnitureSet : FurnitureSet.values()) {
            registry.addDataGenerator(ProviderType.LANG, provider -> {
                for (BlockEntry<?> entry : furnitureSet.blocks) {
                    entry.ifPresent(block -> {
                        if (block instanceof ISeatBlock) {
                            ISeatBlock seat = (ISeatBlock)block;
                            provider.add(seat.getOccupiedTranslationKey(), "This seat is occupied");
                        }
                        if (block instanceof BedBlock) {
                            BedBlock bed = (BedBlock)((Object)((Object)block));
                            provider.add(bed.getOccupiedTranslationKey(), "This bed is occupied");
                        }
                    });
                }
            });
            furnitureSet.itemGroupCategory.addTranslationGenerator((AbstractRegistrator)registry, furnitureSet.englishName).addTranslationGenerator((AbstractRegistrator)registry, "en_gb", furnitureSet.englishName);
            registry.addDataGenerator(AbstractRegistrator.LANG_EXT_PROVIDER, provider -> {
                for (BlockEntry<?> entry : furnitureSet.blocks) {
                    entry.ifPresent(block -> {
                        if (block instanceof ISeatBlock) {
                            ISeatBlock seat = (ISeatBlock)block;
                            provider.add("en_gb", seat.getOccupiedTranslationKey(), "This seat is occupied");
                        }
                        if (block instanceof BedBlock) {
                            BedBlock bed = (BedBlock)((Object)((Object)block));
                            provider.add("en_gb", bed.getOccupiedTranslationKey(), "This bed is occupied");
                        }
                    });
                }
            });
            EventBusHelper.addEnqueuedListener(FMLCommonSetupEvent.class, event -> {
                ItemGroupCategoryManager instance = ItemGroupCategoryManager.getInstance((ItemGroup)FFRegistry.MOD_ITEM_GROUP);
                instance.addCategory(furnitureSet.itemGroupCategory);
            });
        }
        EventBusHelper.addEnqueuedListener(FMLClientSetupEvent.class, event -> {
            FurnitureSet.VENTHYR.tableLargeBlockItem.ifPresent(item -> ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)VENTHYR_FANCY_TABLE_ITEM_PROPERTY, (stack, level, entity) -> {
                String strFancy;
                String name;
                CompoundNBT blockStateTag;
                CompoundNBT stackTag = stack.func_77978_p();
                if (stackTag != null && stackTag.func_150297_b("BlockStateTag", 10) && (blockStateTag = stackTag.func_74775_l("BlockStateTag")).func_150297_b(name = VenthyrTableLargeBlock.FANCY.func_177701_a(), 8) && VenthyrTableLargeBlock.FANCY.func_185929_b(strFancy = blockStateTag.func_74779_i(name)).orElse(false).booleanValue()) {
                    return 1.0f;
                }
                return 0.0f;
            }));
            FurnitureSet.VENTHYR.tableWideBlockItem.ifPresent(item -> ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)VENTHYR_FANCY_TABLE_ITEM_PROPERTY, (stack, level, entity) -> {
                String strFancy;
                String name;
                CompoundNBT blockStateTag;
                CompoundNBT stackTag = stack.func_77978_p();
                if (stackTag != null && stackTag.func_150297_b("BlockStateTag", 10) && (blockStateTag = stackTag.func_74775_l("BlockStateTag")).func_150297_b(name = VenthyrTableWideBlock.FANCY.func_177701_a(), 8) && VenthyrTableWideBlock.FANCY.func_185929_b(strFancy = blockStateTag.func_74779_i(name)).orElse(false).booleanValue()) {
                    return 1.0f;
                }
                return 0.0f;
            }));
            FurnitureSet.VENTHYR.tableSmallBlockItem.ifPresent(item -> ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)VENTHYR_FANCY_TABLE_ITEM_PROPERTY, (stack, level, entity) -> {
                String strFancy;
                String name;
                CompoundNBT blockStateTag;
                CompoundNBT stackTag = stack.func_77978_p();
                if (stackTag != null && stackTag.func_150297_b("BlockStateTag", 10) && (blockStateTag = stackTag.func_74775_l("BlockStateTag")).func_150297_b(name = VenthyrTableSmallBlock.FANCY.func_177701_a(), 8) && VenthyrTableSmallBlock.FANCY.func_185929_b(strFancy = blockStateTag.func_74779_i(name)).orElse(false).booleanValue()) {
                    return 1.0f;
                }
                return 0.0f;
            }));
        });
    }

    private static BlockEntry<Block> wool(String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        FFRegistry registry = FFRegistry.getInstance();
        String location = registry.idString("block/" + serializedName + "/wool");
        return (BlockEntry)((BlockBuilder)registry.block(serializedName + "/wool").lang(englishName + " Wool").lang("en_gb", englishName + " Wool").initialProperties(Material.field_151580_n, MaterialColor.field_151659_e).strength(0.8f).sound(SoundType.field_185854_g).noOcclusion().blockState((ctx, provider) -> provider.simpleBlock((Block)ctx.get(), (ModelFile)provider.models().cubeAll(location, new ResourceLocation(location)))).tag(new ITag.INamedTag[]{BlockTags.field_199897_a}).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ItemTags.field_199904_a, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetCarpetBlock> BlockEntry<BLOCK> carpet(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        FFRegistry registry = FFRegistry.getInstance();
        ResourceLocation locationWool = registry.id("block/" + serializedName + "/wool");
        String location = registry.idString("block/" + serializedName + "/carpet");
        return (BlockEntry)((BlockBuilder)registry.block(serializedName + "/carpet", blockFactory).lang(englishName + " Carpet").lang("en_gb", englishName + " Carpet").initialProperties(Material.field_151593_r, MaterialColor.field_151659_e).strength(0.1f).sound(SoundType.field_185854_g).noOcclusion().blockState((ctx, provider) -> provider.simpleBlock((Block)ctx.get(), (ModelFile)provider.models().carpet(location, locationWool))).tag(new ITag.INamedTag[]{BlockTags.field_200028_e}).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ItemTags.field_200035_e, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetWallLightBlock> BlockEntry<BLOCK> wallLight(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/wall_light", blockFactory).lang(englishName + " Wall Light").lang("en_gb", englishName + " Wall Light").initialProperties(Material.field_151594_q).sound(SoundType.field_185848_a).noOcclusion().instabreak().noCollission().lightLevel(blockState -> serializedName.equals("dunmer") || (Boolean)blockState.func_177229_b((Property)SetWallLightBlock.WATERLOGGED) == false ? 14 : 0).blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetFloorLightBlock> BlockEntry<BLOCK> floorLight(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/floor_light", blockFactory, FFPatterns.PATTERN_2x1_FLOOR_LIGHT).lang(englishName + " Floor Light").lang("en_gb", englishName + " Floor Light").initialProperties(Material.field_151594_q).sound(SoundType.field_185848_a).noOcclusion().instabreak().lightLevel(blockState -> (Boolean)blockState.func_177229_b((Property)SetFloorLightBlock.WATERLOGGED) != false || blockState.func_177229_b(SetFloorLightBlock.SIDE) == SetFloorLightBlock.Side.BOTTOM ? 0 : 14).blockState((ctx, provider) -> provider.simpleBlock((Block)ctx.get(), (ModelFile)provider.models().getExistingFile(Registrations.getExistingModelPath(ctx.getId(), "")))).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetTableSmallBlock> BlockEntry<BLOCK> tableSmall(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/table_small", blockFactory).lang(englishName + " Table Small").lang("en_gb", englishName + " Table Small").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetTableSmallBlock> BlockEntry<BLOCK> venthyrTableSmall(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/table_small", blockFactory).setData(ProviderType.LANG, (ctx, provider) -> {
            SetTableSmallBlock block = (SetTableSmallBlock)ctx.get();
            provider.add((Block)block, englishName + " Table Small");
            provider.add(block.func_149739_a() + ".fancy", "Fancy " + englishName + " Table Small");
        })).setData(AbstractRegistrator.LANG_EXT_PROVIDER, (ctx, provider) -> {
            SetTableSmallBlock block = (SetTableSmallBlock)ctx.get();
            provider.add("en_gb", (Block)block, englishName + " Table Small");
            provider.add("en_gb", block.func_149739_a() + ".fancy", "Fancy " + englishName + " Table Small");
        })).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            provider.horizontalBlock((Block)ctx.get(), blockState -> {
                ModelFile.ExistingModelFile existingModel = provider.models().getExistingFile(Registrations.getExistingModelPath(id, ""));
                if (((Boolean)blockState.func_177229_b((Property)VenthyrTableSmallBlock.FANCY)).booleanValue()) {
                    return ((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(id + "_fancy")).parent((ModelFile)existingModel)).texture("table_small", id.func_110624_b() + ":models/" + serializedName + "/table_small_fancy");
                }
                return existingModel;
            });
        }).loot((lootTables, block) -> lootTables.add((Block)block, LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212841_b_((ILootFunction.IBuilder)CopyBlockState.func_227545_a_((Block)block).func_227552_a_((Property)VenthyrTableSmallBlock.FANCY)))))).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item(VenthyrTableBlockItem::new).model((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            ((ItemModelBuilder)provider.withExistingParent(id.func_110624_b() + ":item/" + id.func_110623_a(), Registrations.getExistingModelPath(id, ""))).override().predicate(VENTHYR_FANCY_TABLE_ITEM_PROPERTY, 1.0f).model((ModelFile)provider.getExistingFile(new ResourceLocation(id.func_110624_b(), id.func_110623_a() + "_fancy"))).end();
        }).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).onRegister(item -> {
            ItemStack stack = item.func_190903_i();
            CompoundNBT stackTag = stack.func_196082_o();
            CompoundNBT blockStateTag = new CompoundNBT();
            blockStateTag.func_74778_a(VenthyrTableSmallBlock.FANCY.func_177701_a(), "false");
            stackTag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
            FurnitureStation.registerAdditionalCraftingResult(stack);
            stack = item.func_190903_i();
            stackTag = stack.func_196082_o();
            blockStateTag = new CompoundNBT();
            blockStateTag.func_74778_a(VenthyrTableSmallBlock.FANCY.func_177701_a(), "true");
            stackTag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
            FurnitureStation.registerAdditionalCraftingResult(stack);
        })).build()).register();
    }

    private static <BLOCK extends SetTableWideBlock> BlockEntry<BLOCK> tableWide(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/table_wide", blockFactory, FFPatterns.PATTERN_1x2).lang(englishName + " Table Wide").lang("en_gb", englishName + " Table Wide").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetTableWideBlock> BlockEntry<BLOCK> venthyrTableWide(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)((ItemBuilder)((MultiBlockBuilder)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/table_wide", blockFactory, FFPatterns.PATTERN_1x2).setData(ProviderType.LANG, (ctx, provider) -> {
            SetTableWideBlock block = (SetTableWideBlock)ctx.get();
            provider.add((Block)block, englishName + " Table Wide");
            provider.add(block.func_149739_a() + ".fancy", "Fancy " + englishName + " Table Wide");
        })).setData(AbstractRegistrator.LANG_EXT_PROVIDER, (ctx, provider) -> {
            SetTableWideBlock block = (SetTableWideBlock)ctx.get();
            provider.add("en_gb", (Block)block, englishName + " Table Wide");
            provider.add("en_gb", block.func_149739_a() + ".fancy", "Fancy " + englishName + " Table Wide");
        })).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            provider.horizontalBlock((Block)ctx.get(), blockState -> {
                ModelFile.ExistingModelFile existingModel = provider.models().getExistingFile(Registrations.getExistingModelPath(id, ""));
                if (((Boolean)blockState.func_177229_b((Property)VenthyrTableWideBlock.FANCY)).booleanValue()) {
                    return ((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(id + "_fancy")).parent((ModelFile)existingModel)).texture("table_wide", id.func_110624_b() + ":models/" + serializedName + "/table_wide_fancy");
                }
                return existingModel;
            });
        }).loot((lootTables, block) -> lootTables.add((Block)block, LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212841_b_((ILootFunction.IBuilder)CopyBlockState.func_227545_a_((Block)block).func_227552_a_((Property)VenthyrTableWideBlock.FANCY)))))).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item(VenthyrTableBlockItem::new).model((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            ((ItemModelBuilder)provider.withExistingParent(id.func_110624_b() + ":item/" + id.func_110623_a(), Registrations.getExistingModelPath(id, ""))).override().predicate(VENTHYR_FANCY_TABLE_ITEM_PROPERTY, 1.0f).model((ModelFile)provider.getExistingFile(new ResourceLocation(id.func_110624_b(), id.func_110623_a() + "_fancy"))).end();
        }).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).onRegister(item -> {
            ItemStack stack = item.func_190903_i();
            CompoundNBT stackTag = stack.func_196082_o();
            CompoundNBT blockStateTag = new CompoundNBT();
            blockStateTag.func_74778_a(VenthyrTableWideBlock.FANCY.func_177701_a(), "false");
            stackTag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
            FurnitureStation.registerAdditionalCraftingResult(stack);
            stack = item.func_190903_i();
            stackTag = stack.func_196082_o();
            blockStateTag = new CompoundNBT();
            blockStateTag.func_74778_a(VenthyrTableWideBlock.FANCY.func_177701_a(), "true");
            stackTag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
            FurnitureStation.registerAdditionalCraftingResult(stack);
        })).build()).register();
    }

    private static <BLOCK extends SetTableLargeBlock> BlockEntry<BLOCK> tableLarge(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/table_large", blockFactory, FFPatterns.PATTERN_2x2).lang(englishName + " Table Large").lang("en_gb", englishName + " Table Large").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetTableLargeBlock> BlockEntry<BLOCK> venthyrTableLarge(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)((ItemBuilder)((MultiBlockBuilder)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/table_large", blockFactory, FFPatterns.PATTERN_2x2).setData(ProviderType.LANG, (ctx, provider) -> {
            SetTableLargeBlock block = (SetTableLargeBlock)ctx.get();
            provider.add((Block)block, englishName + " Table Large");
            provider.add(block.func_149739_a() + ".fancy", "Fancy " + englishName + " Table Large");
        })).setData(AbstractRegistrator.LANG_EXT_PROVIDER, (ctx, provider) -> {
            SetTableLargeBlock block = (SetTableLargeBlock)ctx.get();
            provider.add("en_gb", (Block)block, englishName + " Table Large");
            provider.add("en_gb", block.func_149739_a() + ".fancy", "Fancy " + englishName + " Table Large");
        })).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            provider.horizontalBlock((Block)ctx.get(), blockState -> {
                ModelFile.ExistingModelFile existingModel = provider.models().getExistingFile(Registrations.getExistingModelPath(id, ""));
                if (((Boolean)blockState.func_177229_b((Property)VenthyrTableLargeBlock.FANCY)).booleanValue()) {
                    return ((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(id + "_fancy")).parent((ModelFile)existingModel)).texture("table_large", id.func_110624_b() + ":models/" + serializedName + "/table_large_fancy");
                }
                return existingModel;
            });
        }).loot((lootTables, block) -> lootTables.add((Block)block, LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212841_b_((ILootFunction.IBuilder)CopyBlockState.func_227545_a_((Block)block).func_227552_a_((Property)VenthyrTableLargeBlock.FANCY)))))).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item(VenthyrTableBlockItem::new).model((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            ((ItemModelBuilder)provider.withExistingParent(id.func_110624_b() + ":item/" + id.func_110623_a(), Registrations.getExistingModelPath(id, ""))).override().predicate(VENTHYR_FANCY_TABLE_ITEM_PROPERTY, 1.0f).model((ModelFile)provider.getExistingFile(new ResourceLocation(id.func_110624_b(), id.func_110623_a() + "_fancy"))).end();
        }).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).onRegister(item -> {
            ItemStack stack = item.func_190903_i();
            CompoundNBT stackTag = stack.func_196082_o();
            CompoundNBT blockStateTag = new CompoundNBT();
            blockStateTag.func_74778_a(VenthyrTableLargeBlock.FANCY.func_177701_a(), "false");
            stackTag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
            FurnitureStation.registerAdditionalCraftingResult(stack);
            stack = item.func_190903_i();
            stackTag = stack.func_196082_o();
            blockStateTag = new CompoundNBT();
            blockStateTag.func_74778_a(VenthyrTableLargeBlock.FANCY.func_177701_a(), "true");
            stackTag.func_218657_a("BlockStateTag", (INBT)blockStateTag);
            FurnitureStation.registerAdditionalCraftingResult(stack);
        })).build()).register();
    }

    private static <BLOCK extends SetStoolBlock> BlockEntry<BLOCK> stool(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/stool", blockFactory).lang(englishName + " Stool").lang("en_gb", englishName + " Stool").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetCushionBlock> BlockEntry<BLOCK> cushion(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/cushion", blockFactory).lang(englishName + " Cushion").lang("en_gb", englishName + " Cushion").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetPaintingSmallBlock> BlockEntry<BLOCK> paintingSmall(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/painting_small", blockFactory).lang(englishName + " Painting Small").lang("en_gb", englishName + " Painting Small").initialProperties(Material.field_151575_d).sound(SoundType.field_185848_a).noOcclusion().instabreak().noCollission().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetPaintingWideBlock> BlockEntry<BLOCK> paintingWide(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/painting_wide", blockFactory, FFPatterns.PATTERN_1x2_PAINTING).lang(englishName + " Painting Wide").lang("en_gb", englishName + " Painting Wide").initialProperties(Material.field_151575_d).sound(SoundType.field_185848_a).noOcclusion().instabreak().noCollission().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetDrawerBlock> BlockEntry<BLOCK> drawer(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/drawer", blockFactory).lang(englishName + " Drawer").lang("en_gb", englishName + " Drawer").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetShelfBlock> BlockEntry<BLOCK> shelf(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        FFRegistry registry = FFRegistry.getInstance();
        return (BlockEntry)((BlockBuilder)registry.block(serializedName + "/shelf", blockFactory).lang(englishName + " Shelf").lang("en_gb", englishName + " Shelf").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> provider.horizontalBlock((Block)ctx.get(), blockState -> {
            ShelfBlock.ConnectionType connectionType = (ShelfBlock.ConnectionType)((Object)((Object)((Object)blockState.func_177229_b(ShelfBlock.CONNECTION_TYPE))));
            String suffix = connectionType == ShelfBlock.ConnectionType.LEFT || connectionType == ShelfBlock.ConnectionType.RIGHT ? "_" + connectionType.func_176610_l() : (connectionType == ShelfBlock.ConnectionType.BOTH ? "_center" : "");
            return provider.models().getExistingFile(registry.id("block/" + serializedName + "/shelf" + suffix));
        }, 180)).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetSofaBlock> BlockEntry<BLOCK> sofa(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        FFRegistry registry = FFRegistry.getInstance();
        return (BlockEntry)((BlockBuilder)registry.block(serializedName + "/sofa", blockFactory).lang(englishName + " Sofa").lang("en_gb", englishName + " Sofa").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> provider.getVariantBuilder((Block)ctx.get()).forAllStates(blockState -> {
            Direction facing = (Direction)blockState.func_177229_b((Property)SofaBlock.field_185512_D);
            SofaBlock.ConnectionType connectionType = (SofaBlock.ConnectionType)((Object)((Object)((Object)blockState.func_177229_b(SofaBlock.CONNECTION_TYPE))));
            return ConfiguredModel.builder().modelFile((ModelFile)provider.models().getExistingFile(registry.id("block/" + serializedName + "/sofa_" + connectionType.func_176610_l()))).rotationY(((int)facing.func_185119_l() + 180) % 360).build();
        })).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model((ctx, provider) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)provider.withExistingParent("item/" + ctx.getName(), registry.id("block/" + serializedName + "/sofa_single"));
        }).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetDeskBlock> BlockEntry<BLOCK> desk(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, String side, ITag.INamedTag<Item> itemGroupCategoryTag) {
        String engName = englishName + " Desk " + RegistrateLangProvider.toEnglishName((String)side);
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/desk_" + side, blockFactory, FFPatterns.PATTERN_1x2).lang(engName).lang("en_gb", engName).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetChairBlock> BlockEntry<BLOCK> chair(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/chair", blockFactory, FFPatterns.PATTERN_2x1).lang(englishName + " Chair").lang("en_gb", englishName + " Chair").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetBenchBlock> BlockEntry<BLOCK> bench(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/bench", blockFactory, FFPatterns.PATTERN_1x2).lang(englishName + " Bench").lang("en_gb", englishName + " Bench").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetBookshelfBlock> BlockEntry<BLOCK> bookshelf(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/bookshelf", blockFactory, FFPatterns.PATTERN_2x2_VERTICAL).lang(englishName + " Bookshelf").lang("en_gb", englishName + " Bookshelf").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetChestBlock> BlockEntry<BLOCK> chest(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/chest", blockFactory, FFPatterns.PATTERN_1x2).lang(englishName + " Chest").lang("en_gb", englishName + " Chest").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetDresserBlock> BlockEntry<BLOCK> dresser(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/dresser", blockFactory, FFPatterns.PATTERN_1x2).lang(englishName + " Dresser").lang("en_gb", englishName + " Dresser").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetWardrobeBlock> BlockEntry<BLOCK> wardrobeBottom(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/wardrobe_bottom", blockFactory, FFPatterns.PATTERN_2x2_VERTICAL).lang(englishName + " Wardrobe").lang("en_gb", englishName + " Wardrobe").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetWardrobeTopperBlock> BlockEntry<BLOCK> wardrobeTop(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/wardrobe_top", blockFactory, FFPatterns.PATTERN_1x2).lang(englishName + " Wardrobe Top").lang("en_gb", englishName + " Wardrobe Top").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState(Registrations::horizontalBlock).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetBedSingleBlock> BlockEntry<BLOCK> bedSingle(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/bed_single", blockFactory, FFPatterns.PATTERN_BED_SINGLE).lang(englishName + " Bed Single").lang("en_gb", englishName + " Bed Single").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            provider.horizontalBlock((Block)ctx.get(), blockState -> {
                String suffix = "";
                if (serializedName.equals("dunmer")) {
                    suffix = ((SetBedSingleBlock)blockState.func_177230_c()).getMultiBlockPattern().isOrigin(blockState) ? "_head" : "_foot";
                }
                return provider.models().getExistingFile(Registrations.getExistingModelPath(id, suffix));
            });
        }).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).tag(new ITag.INamedTag[]{BlockTags.field_219747_F}).item().model((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            String suffix = "";
            if (serializedName.equals("dunmer")) {
                suffix = "_full";
            }
            provider.withExistingParent(id.func_110624_b() + ":item/" + id.func_110623_a(), Registrations.getExistingModelPath(id, suffix));
        }).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ItemTags.field_219771_F, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetBedDoubleBlock> BlockEntry<BLOCK> bedDouble(MultiBlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((MultiBlockBuilder)FFRegistry.getInstance().multiBlock(serializedName + "/bed_double", blockFactory, FFPatterns.PATTERN_2x2).lang(englishName + " Bed Double").lang("en_gb", englishName + " Bed Double").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            provider.horizontalBlock((Block)ctx.get(), blockState -> {
                String suffix = "";
                if (serializedName.equals("dunmer")) {
                    suffix = ((SetBedDoubleBlock)blockState.func_177230_c()).getMultiBlockPattern().isOrigin(blockState) ? "_head" : "_foot";
                }
                return provider.models().getExistingFile(Registrations.getExistingModelPath(id, suffix));
            });
        }).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).tag(new ITag.INamedTag[]{BlockTags.field_219747_F}).item().model((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            String suffix = "";
            if (serializedName.equals("dunmer")) {
                suffix = "_full";
            }
            provider.withExistingParent(id.func_110624_b() + ":item/" + id.func_110623_a(), Registrations.getExistingModelPath(id, suffix));
        }).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, ItemTags.field_219771_F, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends SetChandelierBlock> BlockEntry<BLOCK> chandelier(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, ITag.INamedTag<Item> itemGroupCategoryTag) {
        return (BlockEntry)((BlockBuilder)FFRegistry.getInstance().block(serializedName + "/chandelier", blockFactory).lang(englishName + " Chandelier").lang("en_gb", englishName + " Chandelier").initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().lightLevel(blockState -> (Boolean)blockState.func_177229_b((Property)SetChandelierBlock.WATERLOGGED) != false ? 0 : 14).blockState(Registrations::simpleBlockWithStates).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item().model(Registrations::blockItem).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag}).build()).register();
    }

    private static <BLOCK extends DoorBlock> BlockEntry<BLOCK> door(BlockFactory<BLOCK> blockFactory, String serializedName, String englishName, String type, ITag.INamedTag<Item> itemGroupCategoryTag) {
        String engName = serializedName.equals("dunmer") ? englishName + " Door " + (type.equals("single") ? 1 : 2) : englishName + " Door " + RegistrateLangProvider.toEnglishName((String)type);
        return (BlockEntry)((BlockBuilder)((ItemBuilder)FFRegistry.getInstance().block(serializedName + "/door_" + type, blockFactory).lang(engName).lang("en_gb", engName).initialProperties(Material.field_151575_d).strength(2.5f).sound(SoundType.field_185848_a).noOcclusion().blockState((ctx, provider) -> {
            ResourceLocation id = ctx.getId();
            String path = id.func_110623_a();
            String namespace = id.func_110624_b();
            provider.doorBlock((DoorBlock)ctx.get(), new ResourceLocation(namespace, "block/" + path + "_bottom"), new ResourceLocation(namespace, "block/" + path + "_top"));
        }).loot((lootTables, block) -> lootTables.add((Block)block, BlockLootTables.func_239829_a_((Block)block))).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).tag(new ITag.INamedTag[]{BlockTags.field_200152_g}).item().clearDataGenerator(ProviderType.ITEM_MODEL)).tag(new ITag.INamedTag[]{FurnitureStation.CRAFTABLE, itemGroupCategoryTag, ItemTags.field_200154_g}).build()).register();
    }

    static {
        VENTHYR_FANCY_TABLE_ITEM_PROPERTY = FFRegistry.getInstance().id("venthyr_fancy");
    }
}

