/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.integration.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xyz.apex.forge.fantasyfurniture.client.screen.FurnitureStationContainerScreen;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;
import xyz.apex.java.utility.tuple.Triple;

public final class FurnitureStationRecipes {
    private final List<ItemStack> outputs;
    private final List<Ingredient> inputs;
    private final IDrawable furnitureSlotRenderer;
    private final IDrawable vanillaSlotRenderer;

    FurnitureStationRecipes(Collection<ItemStack> outputs, IJeiHelpers jei) {
        this.outputs = ImmutableList.copyOf(outputs);
        IGuiHelper gui = jei.getGuiHelper();
        this.furnitureSlotRenderer = gui.createDrawable(FurnitureStationContainerScreen.TEXTURE, 176, 18, 18, 18);
        this.vanillaSlotRenderer = gui.getSlotDrawable();
        this.inputs = Arrays.asList(Ingredient.func_199805_a(FurnitureStation.CLAY), Ingredient.func_199805_a(FurnitureStation.WOOD), Ingredient.func_199805_a(FurnitureStation.STONE));
    }

    void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients(this.inputs);
        ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
    }

    void setRecipe(IRecipeLayout recipeLayout) {
        IGuiItemStackGroup groups = recipeLayout.getItemStacks();
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        this.setupInputSlots(groups);
        this.setupOutputSlots(groups, (IFocus<ItemStack>)focus);
        recipeLayout.moveRecipeTransferButton(110, 68);
    }

    void draw(MatrixStack pose, IDrawable background) {
        this.renderBlock(pose, background);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_243246_a(pose, (ITextComponent)new TranslationTextComponent("text.fantasyfurniture.jei.ingredients"), 0.0f, 52.0f, -1);
        font.func_243246_a(pose, (ITextComponent)new TranslationTextComponent("text.fantasyfurniture.jei.results"), 0.0f, 84.0f, -1);
    }

    private boolean isItemValid(ItemStack stack, @Nullable IFocus<ItemStack> focus) {
        if (focus == null || focus.getMode() == IFocus.Mode.INPUT) {
            return true;
        }
        return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((ItemStack)focus.getValue()));
    }

    private void setupInputSlots(IGuiItemStackGroup groups) {
        int xSize = this.vanillaSlotRenderer.getWidth() + 2;
        int xSpacing = xSize + 1;
        int x = 0;
        for (int i = 0; i < this.inputs.size(); ++i) {
            Ingredient input = this.inputs.get(i);
            groups.init(i, true, x, 65);
            groups.set(i, Arrays.asList(input.func_193365_a()));
            groups.setBackground(i, this.vanillaSlotRenderer);
            x += xSpacing;
        }
    }

    private void setupOutputSlots(IGuiItemStackGroup groups, @Nullable IFocus<ItemStack> focus) {
        int slotCounterStart;
        int itemsPerRow = 6;
        int itemsPerCol = 4;
        int xSize = this.furnitureSlotRenderer.getWidth() + 2;
        int ySize = this.furnitureSlotRenderer.getHeight() + 2;
        int xSpacing = xSize + 1;
        int ySpacing = ySize + 1;
        int xStart = 0;
        int yStart = 178 - ySpacing * itemsPerCol;
        int x = xStart;
        int y = yStart;
        int slotCounter = slotCounterStart = 3;
        HashMap slotMap = Maps.newHashMap();
        for (ItemStack stack : this.outputs) {
            if (!this.isItemValid(stack, focus)) continue;
            int itemX = x;
            int itemY = y;
            Triple slotData2 = slotMap.computeIfAbsent(slotCounter, $ -> Triple.create((Object)itemX, (Object)itemY, (Object)Lists.newArrayList()));
            ((List)slotData2.getRight()).add(stack);
            ++slotCounter;
            if ((x += xSpacing) < xStart + xSpacing * itemsPerRow) continue;
            x = xStart;
            if ((y += ySpacing) < yStart + ySpacing * itemsPerCol) continue;
            slotCounter = slotCounterStart;
            y = yStart;
        }
        slotMap.forEach((slot, slotData) -> {
            groups.init(slot.intValue(), false, ((Integer)slotData.getLeft()).intValue(), ((Integer)slotData.getMiddle()).intValue());
            groups.set(slot.intValue(), (List)slotData.getRight());
            groups.setBackground(slot.intValue(), this.furnitureSlotRenderer);
        });
    }

    private void renderBlock(MatrixStack pose, IDrawable background) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockState blockState = FurnitureStation.BLOCK.defaultBlockState();
        IBakedModel model = mc.func_175602_ab().func_184389_a(blockState);
        float frameTime = mc.func_184121_ak();
        float blockBobOffset = 0.0f;
        float f1 = MathHelper.func_76126_a((float)(((float)mc.field_71439_g.field_70173_aa + frameTime) / 5.0f + blockBobOffset)) * 0.5f + 0.5f;
        float f2 = model.func_177552_f().func_181688_b((ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND).field_178363_d.func_195900_b();
        double blockYOffset = f1 + 0.25f * f2;
        float blockRotation = ((float)mc.field_71439_g.field_70173_aa + frameTime) / 1.25f + blockBobOffset;
        int width = background.getWidth();
        int height = background.getHeight();
        double centerX = (double)width / 2.0;
        double centerY = (double)height / 2.0 - 64.0;
        double y = centerY - 4.0 + blockYOffset;
        pose.func_227860_a_();
        pose.func_227861_a_(centerX, y, 10.0);
        pose.func_227862_a_(-32.0f, -32.0f, -32.0f);
        pose.func_227861_a_(-0.5, -0.5, 0.0);
        pose.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-25.0f));
        pose.func_227861_a_(0.5, 0.0, -0.5);
        pose.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(blockRotation));
        pose.func_227861_a_(-0.5, 0.0, 0.5);
        pose.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.func_227861_a_(0.0, 0.0, -1.0);
        mc.field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        mc.func_175602_ab().renderBlock(blockState, pose, (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        buffer.func_228461_a_();
        pose.func_227865_b_();
        pose.func_227865_b_();
    }
}

