/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.net;

import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.net.NetworkManager;
import xyz.apex.forge.fantasyfurniture.init.FurnitureStation;

public class SyncFurnitureStationResultsPacket
extends AbstractPacket {
    private final ItemStack[] results;

    public SyncFurnitureStationResultsPacket() {
        this.results = (ItemStack[])FurnitureStation.getCraftingResults().stream().map(ItemStack::func_77946_l).toArray(ItemStack[]::new);
    }

    public SyncFurnitureStationResultsPacket(PacketBuffer buffer) {
        super(buffer);
        int count = buffer.readInt();
        this.results = new ItemStack[count];
        for (int i = 0; i < count; ++i) {
            this.results[i] = buffer.func_150791_c();
        }
    }

    protected void encode(PacketBuffer buffer) {
        buffer.writeInt(this.results.length);
        for (ItemStack stack : this.results) {
            buffer.writeItemStack(stack, false);
        }
    }

    protected void process(NetworkManager network, NetworkEvent.Context ctx) {
        FurnitureStation.syncCraftingResultsFromServer(this);
    }

    public ItemStack[] getResults() {
        return this.results;
    }
}

