/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.block;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.core.init.PlayerPlushie;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;
import xyz.apex.forge.apexcore.revamp.block.BaseBlock;
import xyz.apex.java.utility.nullness.NonnullConsumer;

public final class PlayerPlushieBlock
extends BaseBlock.WithBlockEntity<PlayerPlushieBlockEntity> {
    public static final VoxelShape SHAPE = PlayerPlushieBlock.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)13.0, (double)14.0);
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal(SHAPE, Direction.NORTH);

    public PlayerPlushieBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    protected void registerProperties(NonnullConsumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Object)FACING_4_WAY);
        consumer.accept((Object)WATERLOGGED);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader level, BlockPos pos, ISelectionContext ctx) {
        Direction facing = PlayerPlushieBlock.getFacing(blockState);
        return SHAPER.get(facing);
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader level, BlockPos pos, PathType pathType) {
        return false;
    }

    public void func_180633_a(World level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        SupporterManager.SupporterInfo supporterInfo = PlayerPlushie.getSupporterInfo(stack);
        PlayerPlushieBlockEntity blockEntity = (PlayerPlushieBlockEntity)((Object)this.getBlockEntity((IBlockReader)level, pos));
        if (blockEntity != null && supporterInfo != null) {
            blockEntity.setSupporterInfo(supporterInfo);
        }
    }

    public void func_149666_a(ItemGroup itemGroup, NonNullList<ItemStack> stacks) {
        stacks.addAll(PlayerPlushie.getPlushieItems());
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected TileEntityType<PlayerPlushieBlockEntity> getBlockEntityType() {
        return PlayerPlushie.PLAYER_PLUSHIE_BLOCK_ENTITY.asBlockEntityType();
    }

    public ItemStack getPickBlock(BlockState blockState, RayTraceResult result, IBlockReader level, BlockPos pos, PlayerEntity player) {
        SupporterManager.SupporterInfo supporterInfo;
        PlayerPlushieBlockEntity blockEntity = (PlayerPlushieBlockEntity)((Object)this.getBlockEntity(level, pos));
        if (blockEntity != null && (supporterInfo = blockEntity.getSupporterInfo()) != null) {
            return PlayerPlushie.getPlushieItem(supporterInfo);
        }
        return super.getPickBlock(blockState, result, level, pos, player);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        SupporterManager.SupporterInfo info = PlayerPlushie.getSupporterInfo(stack);
        if (info != null) {
            String username = info.getUsername();
            if (level instanceof World) {
                World world = (World)level;
                PlayerEntity player = info.getPlayer(arg_0 -> ((World)world).func_217371_b(arg_0));
                if (player != null) {
                    username = player.func_195047_I_();
                }
            }
            String supportLevelName = info.getLevel().func_176610_l().toLowerCase(Locale.ROOT);
            String letter = supportLevelName.substring(0, 1).toUpperCase(Locale.ROOT);
            supportLevelName = letter + supportLevelName.substring(1);
            tooltip.add((ITextComponent)new StringTextComponent(username).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}).func_240702_b_(" (").func_230529_a_((ITextComponent)new StringTextComponent(supportLevelName).func_240699_a_(TextFormatting.AQUA)).func_240702_b_(")"));
        }
    }
}

