/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;
import xyz.apex.forge.apexcore.lib.util.ProfileHelper;
import xyz.apex.forge.apexcore.lib.util.SkinHelper;
import xyz.apex.forge.apexcore.lib.util.reflection.MethodHelper;
import xyz.apex.forge.apexcore.revamp.block.BaseBlock;

public class PlayerPlushieBlockEntityRenderer
extends TileEntityRenderer<PlayerPlushieBlockEntity> {
    private final PlayerModel<PlayerEntity> playerModelSlim;
    private final Iterable<ModelRenderer> headPartsSlim;
    private final Iterable<ModelRenderer> bodyPartsSlim;
    private final PlayerModel<PlayerEntity> playerModelThick;
    private final Iterable<ModelRenderer> headPartsThick;
    private final Iterable<ModelRenderer> bodyPartsThick;
    private final Map<UUID, ResourceLocation> playerSkins = Maps.newHashMap();
    public boolean renderLayers = true;

    public PlayerPlushieBlockEntityRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
        this.playerModelSlim = new PlayerModel(0.0f, true);
        this.playerModelThick = new PlayerModel(0.0f, false);
        this.headPartsSlim = PlayerPlushieBlockEntityRenderer.getHeadParts(this.playerModelSlim);
        this.headPartsThick = PlayerPlushieBlockEntityRenderer.getHeadParts(this.playerModelThick);
        this.bodyPartsSlim = PlayerPlushieBlockEntityRenderer.getBodyParts(this.playerModelSlim);
        this.bodyPartsThick = PlayerPlushieBlockEntityRenderer.getBodyParts(this.playerModelThick);
    }

    public void render(PlayerPlushieBlockEntity blockEntity, float partialTick, MatrixStack pose, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        Iterable<ModelRenderer> bodyParts;
        Iterable<ModelRenderer> headParts;
        PlayerModel<PlayerEntity> playerModel;
        String playerName;
        UUID playerId;
        SupporterManager.SupporterInfo supporterInfo = blockEntity.getSupporterInfo();
        if (supporterInfo == null) {
            playerId = ProfileHelper.DUMMY_PROFILE.getId();
            playerName = ProfileHelper.DUMMY_PROFILE.getName();
        } else {
            playerId = supporterInfo.getPlayerId();
            playerName = supporterInfo.getUsername();
        }
        SkinHelper.getSkins(playerId, playerName, texture -> this.playerSkins.put(playerId, (ResourceLocation)texture));
        if (SkinHelper.isSlim(playerId, playerName)) {
            playerModel = this.playerModelSlim;
            headParts = this.headPartsSlim;
            bodyParts = this.bodyPartsSlim;
        } else {
            playerModel = this.playerModelThick;
            headParts = this.headPartsThick;
            bodyParts = this.bodyPartsThick;
        }
        ResourceLocation skin = this.playerSkins.containsKey(playerId) ? this.playerSkins.get(playerId) : DefaultPlayerSkin.func_177334_a((UUID)playerId);
        RenderType renderType = RenderType.func_228644_e_((ResourceLocation)skin);
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(renderType);
        pose.func_227860_a_();
        PlayerPlushieBlockEntityRenderer.setupPlayerModel(playerModel, this.renderLayers);
        PlayerPlushieBlockEntityRenderer.renderPlayerModel(blockEntity, playerModel, headParts, bodyParts, pose, buffer, combinedLight, combinedOverlay);
        pose.func_227865_b_();
    }

    private static void poseForPlushie(PlayerModel<PlayerEntity> playerModel) {
        playerModel.field_78116_c.field_78795_f = 0.0f;
        playerModel.field_78116_c.field_78796_g = 0.0f;
        playerModel.field_78116_c.field_78808_h = 0.0f;
        playerModel.field_78115_e.field_78795_f = -0.4f;
        playerModel.field_78115_e.field_78796_g = 0.0f;
        playerModel.field_78115_e.field_78808_h = 0.0f;
        playerModel.field_178724_i.field_78795_f = 0.0f;
        playerModel.field_178724_i.field_78796_g = 0.0f;
        playerModel.field_178724_i.field_78808_h = -0.5f;
        playerModel.field_178723_h.field_78795_f = 0.0f;
        playerModel.field_178723_h.field_78796_g = 0.0f;
        playerModel.field_178723_h.field_78808_h = 0.5f;
        playerModel.field_178722_k.field_78795_f = -1.6f;
        playerModel.field_178722_k.field_78796_g = -0.5f;
        playerModel.field_178722_k.field_78808_h = 0.0f;
        playerModel.field_178721_j.field_78795_f = -1.6f;
        playerModel.field_178721_j.field_78796_g = 0.5f;
        playerModel.field_178721_j.field_78808_h = 0.0f;
        playerModel.field_78116_c.field_78800_c = 0.0f;
        playerModel.field_78116_c.field_78797_d = 0.0f;
        playerModel.field_78116_c.field_78798_e = 0.0f;
        playerModel.field_78115_e.field_78800_c = 0.0f;
        playerModel.field_78115_e.field_78797_d = 0.0f;
        playerModel.field_78115_e.field_78798_e = 0.0f;
        playerModel.field_178724_i.field_78800_c = 4.1f;
        playerModel.field_178724_i.field_78797_d = 2.0f;
        playerModel.field_178724_i.field_78798_e = 0.0f;
        playerModel.field_178723_h.field_78800_c = -4.2f;
        playerModel.field_178723_h.field_78797_d = 2.0f;
        playerModel.field_178723_h.field_78798_e = 0.0f;
        playerModel.field_178722_k.field_78800_c = 1.0f;
        playerModel.field_178722_k.field_78797_d = 12.0f;
        playerModel.field_178722_k.field_78798_e = -3.5f;
        playerModel.field_178721_j.field_78800_c = -1.0f;
        playerModel.field_178721_j.field_78797_d = 12.0f;
        playerModel.field_178721_j.field_78798_e = -3.0f;
    }

    private static void setupPlayerModel(PlayerModel<PlayerEntity> playerModel, boolean renderLayers) {
        playerModel.func_178719_a(true);
        playerModel.field_228270_o_ = false;
        playerModel.field_217114_e = true;
        PlayerPlushieBlockEntityRenderer.poseForPlushie(playerModel);
        playerModel.field_178733_c.func_217177_a(playerModel.field_178722_k);
        playerModel.field_178731_d.func_217177_a(playerModel.field_178721_j);
        playerModel.field_178734_a.func_217177_a(playerModel.field_178724_i);
        playerModel.field_178732_b.func_217177_a(playerModel.field_178723_h);
        playerModel.field_178730_v.func_217177_a(playerModel.field_78115_e);
        playerModel.field_178720_f.func_217177_a(playerModel.field_78116_c);
        playerModel.field_178733_c.field_78806_j = renderLayers;
        playerModel.field_178731_d.field_78806_j = renderLayers;
        playerModel.field_178734_a.field_78806_j = renderLayers;
        playerModel.field_178732_b.field_78806_j = renderLayers;
        playerModel.field_178730_v.field_78806_j = renderLayers;
        playerModel.field_178720_f.field_78806_j = renderLayers;
    }

    private static void renderPlayerModel(PlayerPlushieBlockEntity blockEntity, PlayerModel<PlayerEntity> playerModel, Iterable<ModelRenderer> headParts, Iterable<ModelRenderer> bodyParts, MatrixStack pose, IVertexBuilder buffer, int combinedLight, int combinedOverlay) {
        if (blockEntity.func_145830_o()) {
            pose.func_227861_a_(0.5, 0.5, 0.5);
            BlockState blockState = blockEntity.func_195044_w();
            Direction facing = BaseBlock.getFacing(blockState);
            pose.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing.func_185119_l()));
            pose.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            pose.func_227861_a_(0.0, 0.0, 0.2);
        } else {
            pose.func_227861_a_(0.5, 0.5, 0.5);
            pose.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
        double yOffset = -0.35;
        if (playerModel.field_217114_e) {
            yOffset = -0.65;
        }
        pose.func_227861_a_(0.0, yOffset, 0.0);
        if (playerModel.field_217114_e) {
            pose.func_227860_a_();
            boolean scaleHead = true;
            float babyHeadScale = 2.0f;
            float babyBodyScale = 2.0f;
            float yHeadOffset = 16.0f;
            float zHeadOffset = 0.0f;
            float bodyYOffset = 24.0f;
            if (scaleHead) {
                float f = 1.5f / babyHeadScale;
                pose.func_227862_a_(f, f, f);
            }
            pose.func_227861_a_(0.0, (double)(yHeadOffset / 16.0f), (double)(zHeadOffset / 16.0f));
            headParts.forEach(renderer -> renderer.func_228309_a_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
            playerModel.field_178720_f.func_228309_a_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.func_227865_b_();
            pose.func_227860_a_();
            float f1 = 1.0f / babyBodyScale;
            pose.func_227862_a_(f1, f1, f1);
            pose.func_227861_a_(0.0, (double)(bodyYOffset / 16.0f), 0.0);
            bodyParts.forEach(renderer -> renderer.func_228309_a_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
            pose.func_227865_b_();
        } else {
            headParts.forEach(renderer -> renderer.func_228309_a_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
            bodyParts.forEach(renderer -> renderer.func_228309_a_(pose, buffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f));
        }
    }

    private static Iterable<ModelRenderer> getHeadParts(PlayerModel<PlayerEntity> playerModel) {
        try {
            return (Iterable)MethodHelper.invokeMethod(AgeableModel.class, playerModel, "headParts", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            return ImmutableList.of((Object)playerModel.field_78116_c);
        }
    }

    private static Iterable<ModelRenderer> getBodyParts(PlayerModel<PlayerEntity> playerModel) {
        try {
            return (Iterable)MethodHelper.invokeMethod(AgeableModel.class, playerModel, "bodyParts", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            return ImmutableList.of((Object)playerModel.field_178733_c, (Object)playerModel.field_178731_d, (Object)playerModel.field_178734_a, (Object)playerModel.field_178732_b, (Object)playerModel.field_178730_v, (Object)playerModel.field_78115_e, (Object)playerModel.field_178723_h, (Object)playerModel.field_178724_i, (Object)playerModel.field_178721_j, (Object)playerModel.field_178722_k, (Object)playerModel.field_178720_f);
        }
    }
}

