/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public final class BlockHelper {
    public static ToIntFunction<BlockState> litBlockEmission(int lightEmission) {
        return blockState -> (Boolean)blockState.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? lightEmission : 0;
    }

    public static Boolean never(BlockState blockState, IBlockReader level, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    public static Boolean always(BlockState blockState, IBlockReader level, BlockPos pos, EntityType<?> entityType) {
        return true;
    }

    public static Boolean ocelotOrParrot(BlockState blockState, IBlockReader level, BlockPos pos, EntityType<?> entityType) {
        return entityType == EntityType.field_200781_U || entityType == EntityType.field_200783_W;
    }

    public static boolean always(BlockState blockState, IBlockReader level, BlockPos pos) {
        return true;
    }

    public static boolean never(BlockState blockState, IBlockReader level, BlockPos pos) {
        return false;
    }

    public static void playBreakSound(World level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.func_180495_p(pos);
        SoundType soundType = blockState.getSoundType((IWorldReader)level, pos, entity);
        level.func_184133_a(null, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public static void playPlaceSound(World level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.func_180495_p(pos);
        SoundType soundType = blockState.getSoundType((IWorldReader)level, pos, entity);
        level.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public static void playStepSound(World level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.func_180495_p(pos);
        SoundType soundType = blockState.getSoundType((IWorldReader)level, pos, entity);
        level.func_184133_a(null, pos, soundType.func_185844_d(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public static void playFallSound(World level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.func_180495_p(pos);
        SoundType soundType = blockState.getSoundType((IWorldReader)level, pos, entity);
        level.func_184133_a(null, pos, soundType.func_185842_g(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public static void playHitSound(World level, BlockPos pos, @Nullable Entity entity) {
        BlockState blockState = level.func_180495_p(pos);
        SoundType soundType = blockState.getSoundType((IWorldReader)level, pos, entity);
        level.func_184133_a(null, pos, soundType.func_185846_f(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public static BlockState copyBlockProperties(BlockState from, BlockState to) {
        for (Property property : from.func_235904_r_()) {
            to = BlockHelper.copyBlockProperty(from, to, property);
        }
        return to;
    }

    public static <T extends Comparable<T>> BlockState copyBlockProperty(BlockState from, BlockState to, Property<T> property) {
        if (from.func_235901_b_(property) && to.func_235901_b_(property)) {
            return (BlockState)to.func_206870_a(property, from.func_177229_b(property));
        }
        return to;
    }
}

