/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.multiblock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockFourWay;
import xyz.apex.java.utility.nullness.NonnullBiFunction;
import xyz.apex.java.utility.nullness.NonnullQuadFunction;
import xyz.apex.java.utility.nullness.NonnullTriPredicate;

public final class MultiBlockPattern {
    public static final int INDEX_ORIGIN = 0;
    private final List<BlockPos> localPositions;
    private final IntegerProperty blockProperty;
    @Nullable
    private final NonnullBiFunction<BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace;
    @Nullable
    private final NonnullBiFunction<BlockState, BlockPos, BlockPos> originFromWorldSpace;
    @Nullable
    private final NonnullQuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier;
    @Nullable
    private final NonnullTriPredicate<IWorldReader, BlockPos, BlockState> placementPredicate;
    private final boolean placeSoundPerBlock;

    private MultiBlockPattern(Builder builder) {
        this.worldSpaceFromLocalSpace = builder.worldSpaceFromLocalSpace;
        this.originFromWorldSpace = builder.originFromWorldSpace;
        this.placementPredicate = builder.placementPredicate;
        this.placeSoundPerBlock = builder.placeSoundPerBlock;
        this.placementStateModifier = builder.placementStateModifier;
        ImmutableList.Builder list = ImmutableList.builder();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int y = 0; y < builder.layers.size(); ++y) {
            String[] patterns = (String[])builder.layers.get(y);
            pos.func_185336_p(y);
            for (int x = 0; x < patterns.length; ++x) {
                String pattern = patterns[x];
                pos.func_223471_o(x);
                for (int z = 0; z < pattern.length(); ++z) {
                    char token = pattern.charAt(z);
                    pos.func_223472_q(z);
                    if (Character.isWhitespace(token)) continue;
                    list.add((Object)pos.func_185334_h());
                }
            }
        }
        this.localPositions = list.build();
        this.blockProperty = IntegerProperty.func_177719_a((String)"multi_block_index", (int)0, (int)this.localPositions.size());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockItemUseContext ctx, BlockState defaultBlockState) {
        World level = ctx.func_195991_k();
        BlockPos origin = ctx.func_195995_a();
        for (BlockPos localSpace : this.localPositions) {
            BlockState blockState;
            BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(defaultBlockState, origin, localSpace);
            if (!this.passesPlacementTests((IWorldReader)level, worldSpace, blockState = level.func_180495_p(worldSpace))) continue;
            return defaultBlockState;
        }
        return null;
    }

    public boolean canSurvive(IWorldReader level, BlockPos pos, BlockState blockState) {
        int index = this.getIndex(blockState);
        BlockPos origin = this.getOriginFromWorldSpace(blockState, pos, this.localPositions.get(index));
        for (BlockPos localSpace : this.localPositions) {
            BlockState testBlockState;
            BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(blockState, origin, localSpace);
            if (this.passesPlacementTests(level, worldSpace, testBlockState = level.func_180495_p(worldSpace))) continue;
            return false;
        }
        return true;
    }

    public void onPlace(BlockState blockState, World level, BlockPos origin, BlockState oldBlockState, boolean isMoving) {
        if (!oldBlockState.func_203425_a(blockState.func_177230_c()) && (Integer)blockState.func_177229_b((Property)this.blockProperty) == 0) {
            SoundType soundType = blockState.getSoundType((IWorldReader)level, origin, null);
            SoundEvent placeSound = soundType.func_185841_e();
            for (int i = 1; i < this.localPositions.size(); ++i) {
                BlockPos localSpace = this.localPositions.get(i);
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(blockState, origin, localSpace);
                BlockState placementBlockState = (BlockState)blockState.func_206870_a((Property)this.blockProperty, (Comparable)Integer.valueOf(i));
                placementBlockState = this.getPlacementState(worldSpace, placementBlockState, i);
                level.func_180501_a(worldSpace, placementBlockState, 11);
                if (!this.placeSoundPerBlock) continue;
                level.func_184133_a(null, worldSpace, placeSound, SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            }
        }
    }

    public void onRemove(BlockState blockState, World level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
        Block block = blockState.func_177230_c();
        int index = (Integer)blockState.func_177229_b((Property)this.blockProperty);
        BlockPos origin = this.getOriginFromWorldSpace(blockState, pos, this.localPositions.get(index));
        for (BlockPos localSpace : this.localPositions) {
            BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(blockState, origin, localSpace);
            if (worldSpace.equals((Object)pos) || !level.func_180495_p(worldSpace).func_203425_a(block)) continue;
            level.func_175655_b(worldSpace, false);
        }
    }

    public void rotate(BlockState blockState, IWorld level, BlockPos origin, Rotation rotation, BlockState rotatedBlockState) {
        int index = (Integer)blockState.func_177229_b((Property)this.blockProperty);
        if (index != 0) {
            for (int i = 1; i < this.localPositions.size(); ++i) {
                BlockPos localSpace = this.localPositions.get(i);
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(rotatedBlockState, origin, localSpace);
                level.func_180501_a(worldSpace, (BlockState)rotatedBlockState.func_206870_a((Property)this.blockProperty, (Comparable)Integer.valueOf(i)), 3);
            }
        }
    }

    public void createBlockStateDefinition(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.blockProperty});
    }

    private boolean passesPlacementTests(IWorldReader level, BlockPos pos, BlockState blockState) {
        if (!blockState.func_185904_a().func_76222_j()) {
            return false;
        }
        if (this.placementPredicate != null) {
            return this.placementPredicate.test((Object)level, (Object)pos, (Object)blockState);
        }
        return true;
    }

    BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.func_206870_a((Property)this.blockProperty, (Comparable)Integer.valueOf(0));
    }

    public int getIndex(BlockState blockState) {
        return (Integer)blockState.func_177229_b((Property)this.blockProperty);
    }

    public boolean isOrigin(BlockState blockState) {
        return blockState.func_235903_d_((Property)this.blockProperty).map(index -> index == 0).orElse(false);
    }

    public BlockPos getWorldSpaceFromLocalSpace(BlockState blockState, BlockPos origin, BlockPos localSpace) {
        if (this.worldSpaceFromLocalSpace != null) {
            BlockPos newLocalSpace = (BlockPos)this.worldSpaceFromLocalSpace.apply((Object)blockState, (Object)localSpace);
            return origin.func_177971_a((Vector3i)newLocalSpace);
        }
        return origin.func_177971_a((Vector3i)localSpace);
    }

    public BlockPos getOriginFromWorldSpace(BlockState blockState, BlockPos worldSpace, BlockPos localSpace) {
        if (this.originFromWorldSpace != null) {
            BlockPos newLocalSpace = (BlockPos)this.originFromWorldSpace.apply((Object)blockState, (Object)localSpace);
            return worldSpace.func_177973_b((Vector3i)newLocalSpace);
        }
        return worldSpace.func_177973_b((Vector3i)localSpace);
    }

    public List<BlockPos> getLocalPositions() {
        return this.localPositions;
    }

    private BlockState getPlacementState(BlockPos pos, BlockState blockState, int index) {
        if (this.placementStateModifier != null) {
            return (BlockState)this.placementStateModifier.apply((Object)this, (Object)pos, (Object)blockState, (Object)index);
        }
        return blockState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<String[]> layers = Lists.newArrayList();
        @Nullable
        private NonnullBiFunction<BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace;
        @Nullable
        private NonnullBiFunction<BlockState, BlockPos, BlockPos> originFromWorldSpace;
        @Nullable
        private NonnullQuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier;
        @Nullable
        private NonnullTriPredicate<IWorldReader, BlockPos, BlockState> placementPredicate;
        private boolean placeSoundPerBlock = false;

        private Builder() {
        }

        public Builder layer(String ... layers) {
            Collections.addAll(this.layers, new String[][]{layers});
            return this;
        }

        public Builder worldSpaceFromLocalSpace(NonnullBiFunction<BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace) {
            this.worldSpaceFromLocalSpace = worldSpaceFromLocalSpace;
            return this;
        }

        public Builder originFromWorldSpace(NonnullBiFunction<BlockState, BlockPos, BlockPos> originFromWorldSpace) {
            this.originFromWorldSpace = originFromWorldSpace;
            return this;
        }

        public Builder setSpacesFor4Way() {
            return this.worldSpaceFromLocalSpace((NonnullBiFunction<BlockState, BlockPos, BlockPos>)((NonnullBiFunction)(blockState, pos) -> {
                Direction facing = (Direction)blockState.func_177229_b((Property)MultiBlockFourWay.FACING);
                if (facing == Direction.NORTH) {
                    return pos.func_190942_a(Rotation.CLOCKWISE_90);
                }
                if (facing == Direction.SOUTH) {
                    return pos.func_190942_a(Rotation.COUNTERCLOCKWISE_90);
                }
                if (facing == Direction.EAST) {
                    return pos.func_190942_a(Rotation.CLOCKWISE_180);
                }
                return pos;
            })).originFromWorldSpace((NonnullBiFunction<BlockState, BlockPos, BlockPos>)((NonnullBiFunction)(blockState, pos) -> {
                Direction facing = (Direction)blockState.func_177229_b((Property)MultiBlockFourWay.FACING);
                if (facing == Direction.NORTH) {
                    return pos.func_190942_a(Rotation.CLOCKWISE_90);
                }
                if (facing == Direction.SOUTH) {
                    return pos.func_190942_a(Rotation.COUNTERCLOCKWISE_90);
                }
                if (facing == Direction.EAST) {
                    return pos.func_190942_a(Rotation.CLOCKWISE_180);
                }
                return pos;
            }));
        }

        public Builder placementStateModifier(NonnullQuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier) {
            this.placementStateModifier = placementStateModifier;
            return this;
        }

        public Builder placementPredicate(NonnullTriPredicate<IWorldReader, BlockPos, BlockState> placementPredicate) {
            this.placementPredicate = placementPredicate;
            return this;
        }

        public Builder placeSoundPerBlock() {
            this.placeSoundPerBlock = true;
            return this;
        }

        public MultiBlockPattern build() {
            return new MultiBlockPattern(this);
        }
    }
}

