/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.net;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.apexcore.core.ApexCore;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.net.PacketHolder;
import xyz.apex.java.utility.nullness.NonnullPredicate;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class NetworkManager {
    public static final PacketDistributor<ServerPlayerEntity> ALL_EXCEPT = new PacketDistributor(NetworkManager::allExcept, NetworkDirection.PLAY_TO_CLIENT);
    private final SimpleChannel instance;
    private final BiMap<Class<? extends AbstractPacket>, Integer> packetIdMap = HashBiMap.create();
    private int packetIdCounter = 0;

    public NetworkManager(String modId, String channelName, String channelVersion) {
        this(modId, channelName, (NonnullSupplier<String>)((NonnullSupplier)() -> channelVersion), (NonnullPredicate<String>)((NonnullPredicate)channelVersion::equals), (NonnullPredicate<String>)((NonnullPredicate)channelVersion::equals));
    }

    public NetworkManager(String modId, String channelName, NonnullSupplier<String> channelVersionSupplier, NonnullPredicate<String> clientAcceptedVersions, NonnullPredicate<String> serverAcceptedVersions) {
        this.instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, channelName)).clientAcceptedVersions(clientAcceptedVersions).serverAcceptedVersions(serverAcceptedVersions).networkProtocolVersion(channelVersionSupplier).simpleChannel();
        this.instance.registerMessage(0, PacketHolder.class, this::encodePacket, this::decodePacket, this::consumePacket);
    }

    public void registerPacket(Class<? extends AbstractPacket> packetType) {
        int packetId = this.packetIdCounter++;
        this.packetIdMap.put(packetType, (Object)packetId);
    }

    public void registerPackets(Class<? extends AbstractPacket> ... packetTypes) {
        Arrays.stream(packetTypes).forEach(this::registerPacket);
    }

    public void sendToServer(AbstractPacket packet) {
        this.instance.sendToServer((Object)new PacketHolder(packet));
    }

    public void sendTo(AbstractPacket packet, ServerPlayerEntity player) {
        this.instance.sendTo((Object)new PacketHolder(packet), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendTo(AbstractPacket packet, PacketDistributor.PacketTarget packetTarget) {
        this.instance.send(packetTarget, (Object)new PacketHolder(packet));
    }

    public void reply(AbstractPacket packet, NetworkEvent.Context ctx) {
        this.instance.reply((Object)new PacketHolder(packet), ctx);
    }

    private void encodePacket(PacketHolder packet, PacketBuffer buffer) {
        Class<?> packetType = packet.packet.getClass();
        Validate.isTrue((boolean)this.packetIdMap.containsKey(packetType), (String)"Attempt to encode unregistered PacketType: '%s'", (Object[])new Object[]{packetType});
        int packetId = (Integer)this.packetIdMap.get(packetType);
        buffer.writeInt(packetId);
        packet.packet.encode(buffer);
    }

    private PacketHolder decodePacket(PacketBuffer buffer) {
        int packetId = buffer.readInt();
        Class packetType = (Class)this.packetIdMap.inverse().get((Object)packetId);
        AbstractPacket packet = null;
        try {
            packet = (AbstractPacket)packetType.getConstructor(PacketBuffer.class).newInstance(buffer);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            ApexCore.LOGGER.error("Failed to decode PacketType: '{}'", (Object)packetType, (Object)e);
        }
        Validate.notNull(packet);
        return new PacketHolder(packet);
    }

    private void consumePacket(PacketHolder packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        packet.packet.process(this, ctx);
        ctx.setPacketHandled(true);
    }

    private static Consumer<IPacket<?>> allExcept(PacketDistributor<ServerPlayerEntity> packetDistributor, Supplier<ServerPlayerEntity> playerSupplier) {
        return packet -> {
            ServerPlayerEntity player = (ServerPlayerEntity)playerSupplier.get();
            for (ServerPlayerEntity otherPlayer : player.field_71133_b.func_184103_al().func_181057_v()) {
                if (player.func_110124_au().equals(otherPlayer.func_110124_au())) continue;
                otherPlayer.field_71135_a.func_147359_a(packet);
            }
        };
    }
}

